(function(){
	var quickview = angular.module('quickview', []);


	//QuickViewController is used by the external quickview window.
	//This is the main controller in the external quickview window mode.
	quickview.controller('QuickViewExternalController', ['$window','$scope','$timeout','$filter','model','QuickView','Event','$q',
	                                   function($window, $scope, $timeout, $filter, model, QuickView, Event, $q){//Even though EncounterAccessor is not used. it must be inject to initialize enums ins
		var co = 0;
		var mO;
		var registeredKeys;
		model.activeController('qv')
		// var qvEvents = ["onQvSuccess", "onQvClose", "onQvMinimize", "onQvExternalize", "onQvActivityChange"];
		function init(){
			$scope.loaded = false;
			mO = {};
			if($window.ofysPayload){
				mO = $window.ofysPayload();
				delete mO.model;
				// var newScope = $scope.$parent.$new();
				// $scope = angular.copy(originalScope);
				registeredKeys = Object.keys(mO);
				$.extend($scope, mO);
//				model = mO.model;
				model.activeMenu('qviewer');
				prepareExternalQV(mO);
				//currPatient is required for patient summary.(med-summary should eventually not use model )
				// model.patient().currPatient = mO.quickViewData.pat;
				$scope.patient = mO.quickViewData.pat;
			}else{
				if(co < 100){
					$timeout(init, 0);
				}else{
					$scope.failedToLoad = true;
					$scope.title = $filter('translate')("error");
					$scope.qv = {noList: true};
					$scope.templateUrl = "error_view.html";
				}
				co += 1;
			}
			$window.onbeforeunload = function(){
				if ($window.isPopingBack === true) {
				}else if(mO.quickViewData && mO.quickViewData.qvActData.isDirty){
					if(mO.quickViewData.qvActData.cancel){
						mO.quickViewData.qvActData.cancel();
					}
				}
			}
			$timeout(function () {
				// refresh is not reliable without this forced load flag used by the ngif directive to make sure dom contents are redrawn.
				$scope.loaded = true;
			}, 300)
		}

		$scope.listSize = function () {
			var s = model.browserSettings('list_qv_size');
			return s===undefined ? 1 : s*1;
		}

		function prepareExternalQV(mObj){
			QuickView.createEvents(mObj, QuickView.qvEvent);
			//Pour fermer le modal et retourner un objet
			mObj.qv.$$success = function (res) {
				Event.emit(mObj.qv.onQvSuccess, {mObj: mObj}, function(){
					$window.close();
					QuickView.cleanUpExternalQV(mObj);
				});
			};

			//Pour fermer le modal
			mObj.qv.$$close = function (){
				var defer = $q.defer();
				QuickView.close(mObj).then(defer.resolve, defer.reject);
				if(QuickView.modalDirty(mObj.qv)){
					if(mObj.qv.externalViewer.forceFocus){
						mObj.qv.externalViewer.forceFocus($window);
					}
					defer.reject();
				}
				return defer.promise;
			};

			mObj.qv.$$minimize = function () {
				Event.emit(mObj.qv.onQvMinimize, {mObj: mObj}, function(){
					$timeout(doPopBack, 500)//This is here for when poping back eform. to make sure that the presave feature has time to send to server.
				});
			};

			mObj.qv.$$externalize = function () {
				Event.emit(mObj.qv.onQvExternalize, {mObj: mObj}, function(){
					$scope.popBack()
				});
			};
			//Pour changer l'item courant du quickview
			mObj.qv.$$changeActivity =  function (act) {
				// var oldAct = mObj.quickViewData.qvActData;
				// var newAct = act;

				// return Event.emit(mObj.qv.onQvActivityChange, {mObj: mObj, oldAct: oldAct, newAct: newAct}, function(){
				// 	mObj.quickViewData.qvActData = act;
				// 	QuickView.updateQVHashOldNew(oldAct, newAct);
				// });
				return QuickView.eventPromise(function(p){
					if(mObj.qv.$$changeActivityLock){//prevents bugs when multiple activity changes are registered before on is finished.
						p.reject();
						return;
					}
					var oldAct = mObj.quickViewData.qvActData;
					var newAct = act;
					var newHash = mObj.qv.externalViewerParentQV.getActivityHash(newAct);
					var newActQv = mObj.qv.externalViewerParentQV.getQVbyHash(newHash) ;
					if(newActQv){//activity already opened in another quickview use it instead of opening a new one.
						mObj.qv.externalViewerParentQV.open(newActQv).then(p.resolve, p.reject);
					}else{
						mObj.qv.$$changeActivityLock = true;
						mObj.isVisible = true; //In case the quickview does not change the activity. it means that it is in editmode.
						function success(){
							mObj.quickViewData.qvActData = act;
							function fn(){
								mObj.qv.externalViewerParentQV.updateQVHashOldNew(oldAct, newAct);
							}
							$window.updateParent(fn);
							mObj.qv.$$changeActivityLock = false;
							mObj.isVisible = true;//external version is always visible.
							p.resolve();
						}
						function fail(){
							mObj.qv.$$changeActivityLock = false;
							p.reject();
						}
						Event.emit(mObj.qv.onQvActivityChange, {mObj: mObj, oldAct: oldAct, newAct: newAct}, success, fail);
					}
				});
			};

			mObj.qv.noList = (typeof mObj.listUrl === 'undefined');
			return mObj;
		}


		model.qv().isExternal = true;

		// window.addEventListener("beforeunload", function(e){
		// 	if(!$scope.poppingBack){
		// 		var confirmationMessage = "\o/";

		// 		e.returnValue = confirmationMessage;     // Gecko, Trident, Chrome 34+
		// 		return confirmationMessage;
		// 	}
		// }, false);

		$scope.popBack = function(){
			mO.qv.$$minimize()
		}

		function doPopBack(){
			$scope.poppingBack = true;
			//$log.log(model.activeMenu());
			if($scope.failedToLoad){
				$window.close();
			}else{
				QuickView.cleanUpExternalQV(mO);
				$window.ofysBackToParent(mO);
			}
		};
		init();
		$window.ofysExternalWindowReload = function(){
			if(registeredKeys){
				for (var i = 0; i < registeredKeys.length; i++) {
					delete $scope[registeredKeys[i]];
				}
				registeredKeys = null;
				$timeout(init, 10);
			}else{
				init();
			}
		};
		$window.ofysExternalWindowForceRefresh = function () {

		};
	}]);

	/** COMMENT: QUICKVIEW VIEWBAR
	 *
	 * VIEWBAR: S'occupe de la gestion de la bar d'activité dans la quickview
	 */
	quickview.directive('quickViewBar', ['model','QuickView', 'utils', function(model, QuickView, utils) {
		return {
			restrict: 'EA',
			templateUrl: '/dashboard/resources/ofys/quickview/qv_bar.html?v=bj',
			scope: {},
			link: function(scope, element, attrs) {
				//internal flag to show if an activity contains other items (group item)
				scope.showGroupMenu = false;
				//Currently displayed group items e.g patient activities.
				scope.groupMenuItems = [];

				scope.getQVItems = function(){
					return OfysUtils.ObjectValuesAsArray(model.qv().itemsGroupCount > 1 ? model.qv().group : model.qv().items);
				};

				//Set the current group items
				//Resolves group items reference by id
				function extractItems(itemsIds){
					var res = [];
					for(var i = 0; i < itemsIds.length; i++){
						res.push(model.qv().items[itemsIds[i]]);
					}
					return res;
				}

				//Centers the grouped items bar relative to the active group
				function positionMenu(ev){
					if(ev){
						var pos = $(ev.currentTarget).position();
						var menuWidth = $("#quickViewGroupItems").outerWidth();
						var itemWidth = $(ev.currentTarget).outerWidth();
						var menuStart = pos.left - ((menuWidth /2)-(itemWidth /2));
						menuStart = menuStart < 0 ? 0: menuStart;
						$("#quickViewGroupItems").css("left", menuStart+'px');
					}

				}

				//called when a quickview item is hovered
				scope.itemHasHover = function(qvItem, ev){
					clearGroup();
					qvItem.quickViewData.icon.amHovered = true;
					qvItem.quickViewData.icon.active = true;
					if(QuickView.isGroup(qvItem)){
						scope.activeGroup = qvItem.quickViewData;
						positionMenu(ev);
						scope.groupMenuItems = extractItems(qvItem.groupContent);
						scope.showGroupMenu = true;
					}
				};

				//called when a quickview item looses hover
				scope.itemLostHover = function(qvItem){
					qvItem.quickViewData.icon.amHovered = false;
					if(QuickView.isGroup(qvItem)){

					}else{
						qvItem.quickViewData.icon.active = false;
					}
				};

				//called when the quickview is hovered
				scope.barHasHover = function(qvItem){
				};

				function clearGroup(){
					if(scope.activeGroup){
						scope.activeGroup.icon.active  = false;
					}
				}
				//called when the quickview looses hover
				scope.barLostHover = function(){
					scope.groupMenuItems = [];
					scope.showGroupMenu = false;
					clearGroup();
				};

				scope.openQv = function(mObj){
					if (model.isSumEdit() !== true){						
						OpenQVEditClose(mObj)
					} else {
						model.closeSummary().then(function(){
							OpenQVEditClose(mObj)
						});
					}
				};
				
				function OpenQVEditClose(mObj){
					model.isSumEdit(false)
					utils.showPopoverOverlay(false)
					if(mObj.qv && mObj.qv.modal){
						mObj.qv.$$minimize();
					}else {
						if (mObj.quickViewData.icon.type!='group') {
							QuickView.open(mObj);
						}
					}
				}

				scope.externalQV = function(mObj){
					if (mObj.quickViewData.icon.type!='group') {
						scope.itemLostHover(mObj);
						QuickView.external(mObj);
					}
				};

				function removeFromGroup(mObj){
					if(scope.groupMenuItems.length > 0){
						var i = scope.groupMenuItems.indexOf(mObj);
						scope.groupMenuItems.splice(i,1);
						if(QuickView.isGroup(mObj)){
							scope.groupMenuItems = extractItems(mObj.groupContent);
							scope.showGroupMenu = false;
						}
					}
				}
				scope.extActive = QuickView.externaliseFeatureActive()
				scope.externActive = function(value){
					return value.quickViewData.icon.amHovered &&
							!value.qv.isExternal && scope.extActive;
				}
				scope.closeQv = function(mObj){
					if(mObj.qv.isExternal && mObj.qv.externalViewer && mObj.qv.$$close){
						if(mObj.qv.externalViewer.closed){
							if(QuickView.modalDirty(mObj.qv)){
								scope.openQv(mObj)
							}
						}else{
							mObj.qv.$$close().then(function(){
								// doClose() // pas necessaire car appeller dans $$close si present ca peux causé la cache patient de se vider.
							}, function(){
								mObj.qv.externalViewer.focus();
							});
						}
					}else{
						doClose();
					}

					function doClose(){
						QuickView.close(mObj).then(function(){
							removeFromGroup(mObj);
						});
					}
					// if(QuickView.isGroup(mObj)){
					// 	closeGroupItems(mObj.groupContent);
					// }else{
					// 	closeItem(mObj);
					// }
				};

			}
		};
	}]);

	quickview.directive('quickViewDir', ['$timeout', '$filter', 'model','TaskAccessor','$http','B2BAccessor','AppointmentAccessor','CourrielAccessor','rxvigilance',
											'PrintAccessor','FlView','RessourceAccessor', 'QValidation',
	                                     function($timeout, $filter, model, TaskAccessor,$http,B2BAccessor,AppointmentAccessor,CourrielAccessor,rxvigilance,
	                                     			PrintAccessor,FlView, ressourceAccessor, QValidation) {
		return {
			restrict: 'EA',
			templateUrl: '/dashboard/resources/ofys/quickview/qv_modal.html?v=bj',
			scope: {
				model: '=',
				quickViewData: '=',
				qv: "=",
				listUrl: "=",
				templateTitleUrl: "=",
				templateUrl: "=",
				title: "=title"
			},
			link: function(scope, element, attrs) {
				scope.qv.templateTitleUrlClick = function(){
					scope.qv.$$changeActivity(scope.quickViewData.pat ? scope.quickViewData.pat : scope.quickViewData.qvActData);
				};
				scope.qv.getReports = function(){
					model.print().type.id = scope.quickViewData.pat.id
					model.print().type.type = "patient"
					
					PrintAccessor.getAvailableReports(model.print().type, function(res){
						res.data.sort((a,b) => (a.name > b.name) ? 1 : ((b.name > a.name) ? -1 : 0))
						for(list of res.data){
							list.reports.sort((a,b) => (a.name > b.name) ? 1 : ((b.name > a.name) ? -1 : 0))
						}
						model.print().currList = res.data;
						FlView.open({templateUrl: "/dashboard/resources/ofys/print/print.html", list: res.data, type: scope.quickViewData.pat}, {
							backdrop: 'static',windowClass: "printmodal"}).then(function(data){
								
						});
					});
				}
				ressourceAccessor.getRessBilled(scope.quickViewData.pat, function(res){
					scope.qv.listInvoice = res
				}, function(errors){
					scope.qv.listInvoice = [];
                    console.error(errors);
                })
                scope.qv.hasUnpaid = function(){
					return scope.qv.listInvoice ? scope.qv.listInvoice.some(e => e.status == "NON_PAYE" || e.status == "PMT_PARTIEL") : false
				}
				scope.qv.openBillAndInvoice = function(){
					scope.invoiceEdit = true;
					ressourceAccessor.getRessBilled(scope.quickViewData.pat, function(res){
						FlView.open(
							{
								templateUrl: "/dashboard/resources/ofys/ress/invoice.html?v=ay", 
								pat: scope.quickViewData.pat, list: res,
								beforeCancel: function(e, obj){
									return QValidation.closeContext($filter('translate')('UnsavedChanges'), "invoice").then(function(successful){
										if(!successful){
											e.prevent();
										}
										scope.invoiceEdit = false;
										return successful;
									});
								},
								fl:{}
							}, 
							{
								backdrop: 'static',windowClass: "top-modal1"
							}
						)
					})
				}
				scope.openNewTask = function(){
					TaskAccessor.openNew();
				};

				scope.openNewReminder = function(){
					$http.get('/dashboard/Patients/ws/newReminder').then(function success(response){
					});
				};

				B2BAccessor.popoverApiInit(scope);

				scope.listSize = function () {
					var s = model.browserSettings('list_qv_size');
					return s===undefined ? 1 : s;
				}
				scope.model = model;
				scope.openNewMessage = function(){
					if (scope.quickViewData && scope.quickViewData.qvActData) {
						if (scope.quickViewData.qvActData.patient == undefined) {
							if(scope.quickViewData && scope.quickViewData.pat){
								scope.quickViewData.qvActData.patient = scope.quickViewData.pat;
							} else if (scope.patient){
								scope.quickViewData.qvActData.patient = scope.patient;
							}
						}
					}
					CourrielAccessor.openNew();
				};

				scope.openAppointmentEdit = function(){
					AppointmentAccessor.openEdit(model.user().profil.id, function(){
						model.notice().ifEmbeded($filter('translate')('embedOpenAppointment'));
					});
				};

				scope.apptsArrivedCount = function() {
					var c=0;
					if (model.appointment().currDate==moment().format(OfysUtils.DATEFORMAT) &&
							model.appointment() &&
							model.appointment().currList &&
							model.appointment().currList.length>0 &&
							model.user().profil && model.currentApptMd().id===model.user().profil.id) {
						c = model.appointment().currList.filterLength(function(a){return a.arrivedTime!==undefined&&a.seenTime===undefined;});
					}
					return c;
				}

				scope.getPatient = function() {
					return scope.quickViewData.pat;
				};

				scope.openVigilanceSanteMd = function(){
					var url = 'https://www.vigilance.ca/medecins';
					if (typeof openExternalBroswer === "function") {
						openExternalBroswer(url);
					    // safe to use the function
					} else {
						window.open(url,'_blank');
					}
				};
				scope.openVigilanceSante = function(){
					var url = 'https://www.vigilance.ca';
					if (typeof openExternalBroswer === "function") {
						openExternalBroswer(url);
						// safe to use the function
					} else {
						window.open(url,'_blank');
					}
				};
				scope.openRxVigilanceHome = function(){
					rxvigilance.openRxViglanceService(rxvigilance.openHome);
				};
				scope.openRxVigilanceMonog = function(item){
					rxvigilance.openRxViglanceService(rxvigilance.openMonograph, item);
				};
				scope.openRxVigilanceAntibio = function() {
					rxvigilance.openRxViglanceService(rxvigilance.openAntibio);
				};
				scope.openRxVigilanceTabComp = function() {
					rxvigilance.openRxViglanceService(rxvigilance.openTabComp);
				};
				scope.openRxVigilanceFeuilletInfo = function() {
					rxvigilance.openRxViglanceService(rxvigilance.openFeuilletInfo);
				};
				scope.openRxVigilanceIndicTher = function() {
					rxvigilance.openRxViglanceService(rxvigilance.openIndicTher);
				};
				scope.openRxVigilanceCalculGros = function() {
					rxvigilance.openRxViglanceService(rxvigilance.openCalculGros);
				};
				scope.openRxVigilanceDocProf = function() {
					rxvigilance.openRxViglanceService(rxvigilance.openDocProf);
				};
				scope.openRxVigilanceEngineQueryViewer = function(pt, addedRx) {
					if (pt.viewbag.analyseRxv===undefined) pt.viewbag.analyseRxv = {};
					pt.viewbag.analyseRxv.isWorking = true;
					rxvigilance.openRxViglanceService(rxvigilance.engineQueryViewer, pt, addedRx, pt.viewbag.analyseRxv);
				};
				scope.openRxVigilanceEngineQueryJson = function(pt, addedRx) {
					if (pt.viewbag.analyseRxv===undefined) pt.viewbag.analyseRxv = {};
					if (pt.viewbag.analyseRxv.isWorking===true) return;
					pt.viewbag.analyseRxv.isWorking = true;
					rxvigilance.openRxViglanceService(rxvigilance.engineQueryJson, pt, addedRx, pt.viewbag.analyseRxv);
				};
//				scope.openEncounter = function(){
//					$http.get('/dashboard/Patients/patientEncounter?idPatient=' + scope.patient.id);
//					model.notice().ifEmbeded($filter('translate')('embedOpenEncounter'));
//				};

				 scope.patient = scope.quickViewData.pat;
				// scope.qvActData = scope.quickViewData.qvActData;
				$timeout(function(){
					var sections = 'PatientData';
					if (model.patientQvAllDataTabs().activeTab!=sections) {
						// reselect au cas ou il y a eu error d'initialisatin (erreur ... on ...)
						model.patientQvAllDataTabs().activeTab = sections;
					}
					$timeout(function(){
						var o = $('.selected')[0];
						if (o) {
							o.scrollIntoView(false);
						}
					}, 800);
//					var p = $(window)[0];	// ne fonctionne pas car != window mais une div avec flow.
//					var elem_position = o.offsetTop;
//				    var window_height = p.innerHeight;
//				    var y = elem_position - window_height/2;
//				    p.scrollTo(0,y);
					},100);
			}
		};
	}]);

	quickview.factory('QuickView', ['$window','$uibModal','$filter', 'model','$timeout','Event','$q','$log','$window','$state',
	                                function($window, $uibModal, $filter, model, $timeout, Event, $q,$log, $window,$state) {
		var iNextQvId = 0;
		function getNextQvId(){
			var prefix = 'qv_';
			iNextQvId++;
			//TODO use atomic integer for value of i. if not could cause problems with external view.
			while(model.qv().items[prefix+iNextQvId] !== undefined)iNextQvId++;
			return prefix+iNextQvId;
		}

		$window.onbeforeunload = function(){
			if(hasDirtyExternals(true)){
				var closeMsg = "Veuillez sauvegarder ou annuler les modifications avant de fermer la fenêtre.";
				event.returnValue = closeMsg;
				return closeMsg
			}
		}

		function hasDirtyExternals(close){
			var dirty = false;
			Object.keys(model.qv().items).forEach(function(e){
				if(!dirty && service.modalDirty(model.qv().items[e].qv)){
					dirty = true
				}
				if(close){
					model.qv().items[e].qv.$$close();
				}
			})
			return dirty;
		}

		//Update hash object references for look up
		//called when new item is added and when the activity of an existing quickview is changed.
		function updateQVHash(input, reason){
			var hash = service.getActivityHash(input);
			if(hash){
				if(reason && reason.searchAndDelete){
					searchAndDeleteOldHash(input);
				}
				if(reason && reason.deleteOnly)return;

				service.qvByHash[hash] = input.$$_qv_id;
			}
		}

		function searchAndDeleteOldHash(input){
			if(input.$$_qv_id){
				//Since the hash of a quickview could change (e.g if another activity is selected)
				//to find old hash, the qvByHash Object must be searched to make sure that id does not exist more than once
				var param = OfysUtils.findParameterWithValue(service.qvByHash, input.$$_qv_id);
				if(param){
					delete service.qvByHash[param];
				}
			}
		}

		/*
		 * Application can define callback functions in the qv object.
		 * onQvSuccess : called when the modal is closed with a return object. when opened for results.
		 * onQvClose : called when the modal is closed without a user defined return object. (modal object mObj is returned)
		 * onQvMinimize : called when the modal is minimized.
		 * onQvExternalize : called when the modal is externalized(pop up window).
		 *
		 * to listen to the events define the handler. e.g :
		 *
		 * 		Event.on(qv.onQvSuccess, function(modalObject){});
		 *
		 * to remove the handler. e.g :
		 *
		 * 		Event.off(qv.onQvSuccess);
		 */
		var qvEvent = ["onQvSuccess", "onQvClose", "onQvMinimize", "onQvExternalize", "onQvActivityChange"];

		//Unit function adds a modal event
		function addModalEvent(mObj, eventType){
			if(!mObj.qv[eventType]){
				mObj.qv[eventType] = eventType+ mObj.$$_qv_id;
				Event.addEvent(mObj.qv[eventType], {});
			}
		}

		//Unit function removes a modal event
		function removeModalEvent(mObj, eventType){
			Event.removeEvent(mObj.qv[eventType]);
			delete mObj.qv[eventType];
		}

		//List function adds a modal events
		function addEvents(mObj, qvEventsArray){
			if(!mObj.qv.$$eventsReady){
				for(var i = 0; i< qvEventsArray.length; i++){
					addModalEvent(mObj, qvEventsArray[i]);
				}
				mObj.qv.$$eventsReady = true;
			}
		}

		//List function removes a modal events
		function removeEvents(mObj, qvEventsArray){
			for(var i = 0; i< qvEventsArray.length; i++){
				removeModalEvent(mObj, qvEventsArray[i]);
			}
			delete mObj.qv.$$eventsReady;
		}

		function cleanUpModalInstance(mObj, newInput){
			if(newInput){//Transfer modal to another newInput activity object(encounter, labo, doc etc.)
				newInput.qv.modal = mObj.qv.modal;
				newInput.update = mObj.update
			}else{//Close the quickview and the modal
				setQVActive(false)
				//only close if the one being cleaned up is the current one. otherwise externalising caused a bug
				if(mObj.qv === service.currentModal){
					service.currentModal = null;
				}
			}
			delete mObj.qv.modal;
			if(model.qv().group[mObj.groupId]){
				delete model.qv().group[mObj.groupId].isOpen;
			}
		}

		function addNewQuickViewIfPossible(input){
			if(model.activeController() === 'qv'){
				input.externalise = true;
				return $window.ofysPayload().qv.externalViewerParentQV.add(input)
			}

			var mObj, openType;

			//hackish variable that skips adding the options
			//'$$'prefixed variables are internal variables that are deleted DO NOT Use this variable outside the QuickView factory
			var skippOptionsSet = input.$$skippOptionsSet?true: false;
			var isPopingBack = input.$$popingBack?true: false;
			delete input.$$skippOptionsSet;
			delete input.$$popingBack;

			var isNewEntry = false;

			//if the input has the $$_qv_id property then it has already been added and only the modal needs to be opened.
			if(input.$$_qv_id){
				openType = 'qvBar';
				mObj = input;
			}else{
				//Check if qv is open to make sure the same activity is not added more than once.
				var qvHash = service.getActivityHash(input);
				if(qvHash){
					mObj = service.getQVbyHash(qvHash);
					openType = 'reOpen';
				}
			}

			// if mObj is still undefined at this point, then no quickview exist with the same hash  and
			// it is a new activity that should be added to quickview list.
			if(!mObj ){
				openType = 'firstOpen';

				if(!input.$$_qv_id){
					isNewEntry = true;
					input.$$_qv_id = getNextQvId();
					mObj = {
							title: "",
							templateUrl:"placeHolder_index.html",
							quickViewData: {
								icon: {
									title: "Document",
									cssClasses :"fa-folder"
								},
							},
							qv: {},
							isVisible: true
					};

					$.extend(mObj, input);
					updateQVHash(mObj);
					if(input.quickViewData && input.quickViewData.pat && input.quickViewData.pat.viewbag){
						var pt = input.quickViewData.pat;
						model.patientsInQv(''+pt.id, pt);
					}

				}else{
					mObj = input;
				}


				//Adds icons and other quickview specific options
				//useful when adding an element to quickview without opening the quickview modal. (open later use cases).
				if(!skippOptionsSet){
					if(mObj.quickViewData){
						service.addQuickViewOptions(mObj.quickViewData);
					}
				}
			}

			if(isNewEntry){
				if(!service.isGroup(mObj)){
					model.qv().items[mObj.$$_qv_id] = mObj;
				}
				//Update grouping of multiple quickviews
				//if the new entry is of a another patient a new group
				//is created that compiles all the quickview that belongs to that patient.
				service.addToGroup(mObj, isPopingBack);
			}

			//Add events if necessary if event already exists it is not added again.
			addEvents(mObj, qvEvent);

			return mObj;
		}
		function setQVActive(state){
			$timeout(function(){
				service.qvActive = state;
			}, 0);
		}

		//Closes a quickview activity
		//The reason parameter used in the removeFromGroup function could be:
		//- external : the activity is being poped to an external view (loose reference is kept by the containing group for closing later on)
		//- kill : the activity viewing is terminated and all resources should be freed
		function closeQuickViewItem(input, reason){
			var defer = $q.defer();
			function doCloseQuickViewItem(){
				try{
					if(input.qv.isExternal && input.qv.externalViewer){
						input.qv.externalViewer.close()
					}
					service.removeFromGroup(input, reason);
					setQVActive(false)
					if(!input.$$_qv_id){

					}else if(model.qv().items[input.$$_qv_id] !== undefined){
						model.qv().items[input.$$_qv_id].isOpen = false;
						updateQVHash(input, {searchAndDelete: true, deleteOnly: true});
						delete model.qv().items[input.$$_qv_id];
					}
					if (input.quickViewData!== undefined && input.quickViewData.pat!== undefined && !service.isGroup(input)) {
						model.patientsInQv(''+input.quickViewData.pat.id, null);
					}
					removeEvents(input, qvEvent);
					if(model.summaryExternalViewer === input){
						delete model.summaryExternalViewer;
					}
					if(input.qv && input.qv.modal){
						input.qv.modal.dismiss('cancel');
						input.qv.modal.closed.then(defer.resolve, defer.reject);
					}else if(model.qv().isExternal){
						$window.close();
						defer.resolve()
					}
					return true;
				}catch(e){
					$log.error(e);
					defer.reject();
				}
				return false;// Event api.. sync.. will be changed eventually and so should this.
			}

			//Code to sync open and close of modal this ensures that a modal can only be closed after it has been opened.
			if(input.lockClose && input.lockCloseCount < 5){
				input.lockCloseCount = input.lockCloseCount + 1;
				defer.reject();
				return defer.promise;
			}
			if(input.lockCloseCount && input.lockCloseCount > 4){
				// While this is not technically an error. It shows that a potential maximum stack calls would have occured. with the close call.
				$log.error("Too many close calls of quickview before modal open.")
			}
			input.lockCloseCount = 0;

			if(input.qv.onQvClose){
				Event.emit(input.qv.onQvClose, {mObj: input}, doCloseQuickViewItem);
			}else{
				doCloseQuickViewItem();
			}
			return defer.promise;
		}

		//Used in debuggin parts to figure out the context of the quickview.
		//Returns a print out of the url(Appointment, Patient, External, LabDoc.. etc), nature fo the quickview, type of document opened.
		function getQuickviewContextString(mObj){
			var items = model.qv().items;
			var groups = model.qv().group[mObj.groupId];
			return "route url: " + $state.current.name +
				" isExternal : "+ model.qv().isExternal +
				" docType : " + mObj.quickViewData.viewerType +
				" qv id : " + mObj.$$_qv_id +
				" sibling QVs : " + (groups !== undefined? groups.groupContent.length : 0) +
				" No of Quickviews : " + (items !== undefined ? Object.keys(items).length: 0) ;
		}

		//Closes all group elements (activities, external views and modals that are open)
		function closeQuickViewGroup(input, reason){
			//Close all open external windows of this group
			//TODO a verfier avec le external active.
    		// while(input.groupExternals.length > 0){
			// 	if(input.groupExternals[0].externalViewer){
			// 		input.groupExternals[0].externalViewer.close();
			// 	}
    		// 	input.groupExternals.splice(0, 1);
			// }

			function closeAll(){
				if(input.groupContent.length > 0){
					return closeQuickViewItem(model.qv().items[input.groupContent[0]]).then(closeAll);
				}else{
					return $q(function(res, rej){res()});//Everything has been close return an immediately resolved promise.
				}
			}

			function doGroupClose(){
				//Close all activities of the group
				return closeAll().then(function(){
					closeQuickViewItem(input)
				});
			}

			return doGroupClose()
		}

		//Closes the quickview this is the destruction method.
		//if the modal is opened it is closed
		//The reference in the quickview list is removed.
		function closeQuickView(input, reason){
			if(service.isGroup(input) ){
				return closeQuickViewGroup(input, reason);
			}else{
				return closeQuickViewItem(input, reason);
			}
		}

		function cleanUpForExternal(mObj){
			service.removeEvents(mObj, service.qvEvent);
			//To make sure that scope references are not kept on the old scope,
			//all qv functions must be deleted and recreated on the external window.
			delete mObj.qv.$$success;
			delete mObj.qv.$$close;
			delete mObj.qv.$$minimize;
			delete mObj.qv.$$externalize;
			delete mObj.qv.$$changeActivity;
			delete mObj.qv.externalViewer;
			delete mObj.qv.externalViewerParentQV;
		}

		//Pop out the quickview modal to an external view window.
		function externaliseQuickView(mObj, reuseWindowMObj){
			// var closeReason = {id:mObj.$$_qv_id, type: "external", externalViewer: externalViewer};

			// service.close(mObj, closeReason);
			if(mObj.qv.$$minimize){
				mObj.qv.$$minimize();
			}

			cleanUpModalInstance(mObj);
			cleanUpForExternal(mObj);

			mObj.qv.isExternal = true;

			function getCleanExternalWindow(mObj, url){
				if(mObj.qv && mObj.qv.externalViewer){
					var wx = mObj.qv.externalViewer;
					mObj.qv.isExternal = false;
					mObj.reloadRequired = true;
					delete mObj.qv.externalViewer;
					delete mObj.qv.externalViewerParentQV
					removeLoadEvent(wx)
					// wx.location.reload();
					return wx;
				}
			}

			function removeLoadEvent(wx){
				if(model.isIE || model.isEmbeded){//IE compatibilities
					delete wx.onload;
					delete wx.onbeforeunload;
				}else{
					wx.removeEventListener('load',setWindowData,false);
					wx.removeEventListener('beforeunload', beforeWindowClose);
					wx.removeEventListener('resize', setWidthHeightPosition);
				}
			}

			function addLoadEvent(){
				if(model.isIE || model.isEmbeded){//IE compatibilities
					externalViewer.onload = setWindowData;
					externalViewer.onbeforeunload =  beforeWindowClose;
				}else{
					externalViewer.addEventListener('load',setWindowData,false);
					externalViewer.addEventListener('beforeunload', beforeWindowClose);
					externalViewer.addEventListener('resize', setWidthHeightPosition);
				}
			}

			function setWidthHeightPosition(){
				localStorage.setItem('externalWindowHeight', externalViewer.innerHeight);
				localStorage.setItem('externalWindowWidth', externalViewer.innerWidth);
				localStorage.setItem('externalWindowX', externalViewer.screenX);
				localStorage.setItem('externalWindowY', externalViewer.screenY);
			}
			function getWidthHeightPosition(){
				var pos = {};
				pos.h = localStorage.getItem('externalWindowHeight');
				pos.w = localStorage.getItem('externalWindowWidth');
				pos.x = localStorage.getItem('externalWindowX');
				pos.y = localStorage.getItem('externalWindowY');
				pos.h = pos.h ? (pos.h*1) : Math.floor(screen.height*0.9);
				pos.w = pos.w ? (pos.w*1) : Math.floor(screen.width*0.8);
				pos.x = pos.x ? (pos.x*1) : 0;
				pos.y = pos.y ? (pos.y*1) : 0;
				return pos;
			}

			if (!$window.location.origin) {
				$window.location.origin = window.location.protocol + "//" + $window.location.hostname + ($window.location.port ? ':' + $window.location.port: '');
			}
			var url = $window.location.origin + $window.location.pathname +"#/qviewer";
			var externalViewer;
			if(!reuseWindowMObj){
				var pos = getWidthHeightPosition()
				externalViewer = $window.open(url, '_blank',
						'location=no,height='+pos.h+',width='+pos.w+',top='+pos.y+', left='+pos.x+', scrollbars=yes,resizable=1, status=yes');
			}else if(reuseWindowMObj.qv && reuseWindowMObj.qv.externalViewer){
				externalViewer = getCleanExternalWindow(reuseWindowMObj, url);
			}
			if(!externalViewer){
				model.notice().fail($filter("translate")("FailedToOpenExternal"));
				return false;
			}
			// service.add(mObj);
			mObj.qv.externalViewer = externalViewer;
			mObj.qv.externalViewerParentQV = service;

			addLoadEvent();

			if(reuseWindowMObj && reuseWindowMObj.reloadRequired){
				setWindowData();
				if(externalViewer && externalViewer.ofysExternalWindowReload){
					externalViewer.ofysExternalWindowReload();
					externalViewer.ofysExternalWindowForceRefresh();
				}
				delete reuseWindowMObj.reloadRequired;
			}
			function getRootScope(){
				var $body = angular.element(document.body);
				var $rootScope = $body.injector().get('$rootScope');
				return $rootScope;
			}

			function setWindowData(event){
				externalViewer.ofysPayload = function(){
					return mObj;
				};
				externalViewer.updateParent = function(fn){
					getRootScope().$apply(fn);
				};
				externalViewer.forceFocus = function Bounce(w) {
						w.blur();
						$window.focus();
				};


				externalViewer.ofysBackToParent = function(mObj){
					externalViewer.isPopingBack = true;
					getRootScope().$apply(function () {
						mObj.$$popingBack = true;
						delete mObj.qv.isExternal;
						// cleanUpForExternal(mObj)
						//Update patient cache
						// var pt = mObj.quickViewData.pat;
						// model.patientsInQv(''+pt.id, pt);

						// service.add(mObj);
						// service.createEvents(mObj, service.qvEvent);
						$timeout(function(){
							service.open(mObj);
						}, 0)
					});
					externalViewer.close();
				};
			}

			/**
			 * This function works with the $window.onbeforeunload in QuickViewExternalController
			 * This function that is in the parent popover seems to work best for halting the closing and
			 * $window.onbeforeunload has to exist otherwise this on is not always called.
			 * $window.onbeforeunload is useful to call the $$close method on the modal object to show the dirty text in the window.
			 * @param {*} event
			 */
			function beforeWindowClose(event){
				$log.log("Fermeture du quickview externe avec l'id "+ mObj.$$_qv_id);
				if (externalViewer.isPopingBack === true) {
				}else if(service.modalDirty(mObj.qv)){
					// Le close semble marché géré par le beforeunload de QuickViewExternalController
					var closeMsg = "Veuillez sauvegarder ou annuler les modifications avant de fermer la fenêtre.";
					event.returnValue = closeMsg;
					return closeMsg
				}else{
					if(mObj.qv.externalViewer !== undefined && !mObj.qv.externalViewer.closed && !OfysUtils.isSafariBrowser()){// pour eviter que le patient soit enlever 2 fois
						service.close(mObj)
					}
				}
			}
			return true;
		}



		function eventPromise(fn){
			var p = $q.defer();
			try{
				fn(p)
			}catch(e){
				model.notice().fail(e.message);
				$log.error(e);
				p.reject(e);
			}

			return p.promise;
		}

		// function closeOrMinimiseDirty(qv, input){
		// 	if(service.isGroup(input)){
		// 		$log.log("Its a group!!")
		// 		return qv.$$minimize();
		// 	}
		// 	if(service.modalDirty(qv)){
		// 		return qv.$$minimize();
		// 	}else{
		// 		return qv.$$close();
		// 	}
		// }

		function closeOrMinimiseDirty(qv, input){
			if(service.isGroup(input)){
				$log.log("Its a group!!")
				return qv.$$minimize();
			}
			if(service.modalDirty(qv)){
				return qv.$$minimize();
			}else{
				return qv.$$close();
			}
		}

		function openModal(mObj, input){
			var modalInstance;
			function modalApi() {

				//Pour fermer le modal et retourner un objet
				mObj.qv.$$success = function (res) {
					return eventPromise(function(p){
						function success(){
							modalInstance.close(res);
							delete mObj.qv.onQvSuccess;
							cleanUpModalInstance(mObj);
							p.resolve(res)
						}
						Event.emit(mObj.qv.onQvSuccess, {mObj: mObj},success, p.reject );
					})
				};

				/**
				 * if newInput is passed, the quickview calls the close action event
				 * but the modal instance is not closed, only cleanup is done for when open data is called for data update
				 *
				 * it is useful for when an activity change happens but the state of the editor is dirty.
				 * In this case we want to keep the dirty editor and open another editor. Closing the dirty modal causes
				 * fluidity issues since the user waits for the animation of the modal closing to finish.
				 * Not closing the modal and just updating the modal data gives better fluidity of changing editor to editor.
				 */
				mObj.qv.$$close = function (newInput) {
					return eventPromise(function(p){
						service.close(mObj, newInput).then(function(){
							cleanUpModalInstance(mObj, newInput);
							p.resolve(arguments);
						}, p.reject);
					});
				};

				/**
				 * if newInput is passed, the quickview calls the minimize action event
				 * but the modal instance is not changed, only the modal data is updated.
				 */
				mObj.qv.$$minimize = function (newInput) {
					return eventPromise(function(p){
						//console.log(getQuickviewContextString(mObj));
						function success(){
							if(model.qv().items[mObj.$$_qv_id]){
								model.qv().items[mObj.$$_qv_id].isVisible = true;
								model.qv().items[mObj.$$_qv_id].isOpen = false;
							}else{
								$log.error("Could not minimize quickview because of missing item with context: " + getQuickviewContextString(mObj));
							}
							if(!newInput){
								modalInstance.dismiss('cancel');
							}
							cleanUpModalInstance(mObj, newInput);
							p.resolve();
						}
						Event.emit(mObj.qv.onQvMinimize, {mObj: mObj}, success, p.reject);
					});
				};

				mObj.qv.$$externalize = function () {
					return service.external(mObj);
				};

				//Pour changer l'item courant du quickview
				mObj.qv.$$changeActivityLock =  false
				mObj.qv.$$changeActivity =  function (act) {
					return eventPromise(function(p){
						if(mObj.qv.$$changeActivityLock){//prevents bugs when multiple activity changes are registered before on is finished.
							p.reject();
							return;
						}
						var oldAct = mObj.quickViewData.qvActData;
						var newAct = act;
						var newHash = service.getActivityHash(newAct);
						var newActQv =service.getQVbyHash(newHash) ;
						if(newActQv){//activity already opened in another quickview use it instead of opening a new one.
							closeOrMinimiseDirty(mObj.qv, newActQv).then(function(){
								service.open(newActQv).then(p.resolve, p.reject);
							});
						}else{
							mObj.qv.$$changeActivityLock = true;
							mObj.isVisible = true; //In case the quickview does not change the activity. it means that it is in editmode.
							function success(){
								mObj.quickViewData.qvActData = act;
								service.updateQVHashOldNew(oldAct, newAct);
								mObj.qv.$$changeActivityLock = false;
								mObj.isVisible = false;
								p.resolve();
							}
							function fail(){
								mObj.qv.$$changeActivityLock = false;
								p.reject();
							}
							Event.emit(mObj.qv.onQvActivityChange, {mObj: input, oldAct: oldAct, newAct: newAct}, success, fail);
						}
					});
				};
				// $timeout(updateModalInstance, 0);
				// updateModalInstance();
				mObj.qv.noList = (typeof mObj.listUrl === 'undefined');
				return mObj;
			}

			function updateModalInstance(){
				if(mObj.$$_qv_id !== undefined){
					if(!mObj.qv.modal){
						mObj.qv.modal = modalInstance;
					}
					try{
						if(mObj.quickViewData.pat){
							model.qv().group[mObj.groupId].isOpen = true;
						}
					}catch(e){
						$log.error(e);
					}
					//console.log(getQuickviewContextString(mObj))
					if(model.qv().items[mObj.$$_qv_id]){
						model.qv().items[mObj.$$_qv_id].isVisible = false;
						model.qv().items[mObj.$$_qv_id].isOpen = true;
					}else{
						$log.error("Could not find quickview item with context: " + getQuickviewContextString(mObj));
					}
					service.currentModal = mObj.qv;
				}
				delete mObj.lockClose;
				mObj.lockCloseCount = 0;
			}

			if(mObj.qv.modal){
				modalInstance = mObj.qv.modal;
				if(mObj.update){
					mObj.update(modalApi());
				}
				model.patientDataUpdated(true);
				model.actUpdated(true);
				return $q(function(resolve, reject){resolve()});
			}else{
				modalInstance = $uibModal.open({
					animation: false,
					keyboard: false,
					templateUrl: "qvModal_index.html",
					controller: 'ModalInstanceCtrl',
					backdrop: 'static',
					size: "qv",
					resolve: {
						mObject: modalApi
					}
				});

				setQVActive(true)

				
				mObj.lockClose = true;
				mObj.lockCloseCount = 0;
				return modalInstance.opened.then(updateModalInstance);
			}
		}

		var service = {
				//stores all the open quickview according to a hash that should
				//uniquely identify the content. if the content is changed the has is updated too.
				qvByHash: {},
				qvActive: false,
				qvEvent: qvEvent,
				eventPromise: eventPromise,
				externaliseFeatureActive: function(){
					return !model.isEmbeded;
				},
				modalDirty: function (m){
					return m && m.isDirty && m.isDirty();
				},
				cleanUpExternalQV:function (mObj){
					service.removeEvents(mObj, service.qvEvent);
					mObj.qv.isExternal = false;
					delete mObj.qv.$$success;
					delete mObj.qv.$$close;
					delete mObj.qv.$$minimize;
					delete mObj.qv.$$externalize;
					delete mObj.qv.$$changeActivity;
					delete mObj.qv.externalViewer;
					delete mObj.qv.externalViewerParentQV;
				},
				getActivityHash: function (input){
					if(input.quickViewData && input.quickViewData.qvActData &&
							input.quickViewData.qvActData.uid){
						return input.quickViewData.qvActData.uid;
					}else if(input.uid){
						return input.uid;
					}else if( typeof input.getDataHash === "function"){
						return input.getDataHash();
					}
				},
				getQVbyHash:function (hash){
					if(service.qvByHash[hash]){
						return model.qv().items[service.qvByHash[hash]];
					}
				},
				getQVPayLoad: function(act, opt, pat, patTitle){
					var payload = {
							quickViewData: {
								qvActData: act,
								pat: pat,
								options: opt,
								patTitle: patTitle,
							},
							groupId: "pat"+ (pat ? pat.id : act.idPatient),
							listUrl: "/dashboard/resources/ofys/pat/patientQvAllData.html?v=bj",
							templateTitleUrl: "qvPatient_index.html",
							templateUrl:"qv_viewer_index.html",
							onGroupReady: function (obj) {
									var objPat = obj.quickViewData.pat;

									model.qv().group[obj.groupId].quickViewData.pat = objPat ;
									model.qv().group[obj.groupId].quickViewData.icon.cssClasses = service.getGenderIcon(objPat.gender);
									model.qv().group[obj.groupId].quickViewData.icon.title = model.getPatIdTitle(objPat);
									model.qv().group[obj.groupId].quickViewData.icon.initials = objPat.firstName[0] + "." + objPat.lastName[0] + ".";
							}
					};
					if(opt.canPopBack === undefined){
						opt.canPopBack = true;
					}
					if(opt.noList){
						delete payload.listUrl;
					}
					if(pat && pat.viewbag && pat.viewbag.patData){
						payload.quickViewData.patData = pat.viewbag.patData;
					}
					return payload;
				},
				openCurrentUserQV: function (act, opt) {
					this.open(this.getUserQVPayLoad(act, opt, model.user().sessionUser.user));
				},
				getUserQVPayLoad: function(act, opt, user){

					var payload = {
						quickViewData:{qvActData:act, user: user, options: opt,
							hideMsgBtn: true,
							hideTaskBtn: true,},
						groupId: "user"+ user.id,
						listUrl: "/dashboard/resources/ofys/user/userQvAllData.html?v=bj",
						templateTitleUrl: "qvUser_index.html",
						templateUrl:"qv_viewer_index.html",
						getDataHash: function () {
							return
						},
						onGroupReady: function (obj) {
							var objUser = obj.quickViewData.user;

							model.qv().group[obj.groupId].quickViewData.user = objUser ;
							model.qv().group[obj.groupId].quickViewData.icon.cssClasses = "fa-user-md";
							// model.qv().group[obj.groupId].quickViewData.icon.title = model.getPatIdTitle(objUser);
							// model.qv().group[obj.groupId].quickViewData.icon.initials = objUser.firstName[0] + "." + objUser.lastName[0] + ".";
						}
					};
					if(opt.canPopBack === undefined){
						opt.canPopBack = true;
					}

					if(opt.noList){
						delete payload.listUrl;
					}
					if(user.viewbag && user.viewbag.userData){
						payload.quickViewData.userData = user.viewbag.userData;
					}
					return payload;
				},
				getFaxQVPayLoad: function(act, opt, user){

					var payload = {
							quickViewData:{qvActData:act, user: user, options: opt},
								groupId: "user"+ user.id,
								listUrl: "/dashboard/resources/ofys/fax/faxQvData.html?v=bj",
								templateTitleUrl: "qvFax_index.html",
								templateUrl:"qv_viewer_index.html",
								getDataHash: function () {
									return
								},
								onGroupReady: function (obj) {
									var objUser = obj.quickViewData.user;
									model.qv().group[obj.groupId].quickViewData.user = objUser ;
									model.qv().group[obj.groupId].quickViewData.icon.cssClasses = "fa-fax";
								}
					};
					if(opt.canPopBack === undefined){
						opt.canPopBack = true;
					}
					if(opt.noList){
						delete payload.listUrl;
					}
					payload.quickViewData.fax = {ids:opt.ids};

					return payload;
				},
				getSuiviPrevQVPayLoad: function(act, user){

					var payload = {
							quickViewData:{qvActData:act, user: user, options: opt},
								groupId: "user"+ user.id,
								listUrl: "/dashboard/resources/ofys/suiviprev/suiviPrevQvData.html?v=bj",
								templateTitleUrl: "qvSuiviPrev_index.html",
								templateUrl:"qv_viewer_index.html",
								getDataHash: function () {
									return
								},
								onGroupReady: function (obj) {
									var objUser = obj.quickViewData.user;
									model.qv().group[obj.groupId].quickViewData.user = objUser ;
									model.qv().group[obj.groupId].quickViewData.icon.cssClasses = "fa-hourglass-half";
								}
					};
					if(opt.canPopBack === undefined){
						opt.canPopBack = true;
					}
					if(opt.noList){
						delete payload.listUrl;
					}

					return payload;
				},
				eventsActive :function(qv){
					for (let i = 0; i < qvEvent.length; i++) {
						if(!qv[qvEvent[i]]){
							return false;
						};
					}
					return true;
				},
				updateQVHashById: function(qvId){
					if(qvId){
						updateQVHash(model.qv().items[qvId], {searchAndDelete: true});
					}
				},
				updateQVHashOldNew: function(oldAct, newAct){
					if(oldAct && newAct && newAct.uid && oldAct.uid){
						service.qvByHash[newAct.uid] = service.qvByHash[oldAct.uid];
						delete service.qvByHash[oldAct.uid];
					}
				},
				isGroup: function (qvItem){
					return qvItem.quickViewData.icon && qvItem.quickViewData.icon.type === 'group';
				},
				isExternal: function (reason){
					return reason && reason.type === "external";
				},
				//Add an item to a group corresponding to the right group. Called when oppeing a new activity. added to the right patient.
			    addToGroup: function(obj, isPopingBack){
			    	if(model.qv().group[obj.groupId] === undefined){
						try{
							//angular.copy seem to cause an error in certain cases in IE where
							//form code may cause
							//'Can't execute code from a freed script'
							//Error: Impossible d'exécuter le code à partir d'un script libéré
							//falling back to jquery extend in that case
							model.qv().group[obj.groupId] = angular.copy(obj);
						}catch(e){
							try{
								model.qv().group[obj.groupId] = $.extend(true, {}, obj);
							}catch(e){
								//Both attemps failed Nuclear option required.
								$log.error(e);
								return;
							}
						}

			    		model.qv().group[obj.groupId].$$_qv_id = getNextQvId();

						model.qv().group[obj.groupId].groupContent = []; //refrence to group items are stored. only the id
						// model.qv().group[obj.groupId].groupExternals = []; // if a group items is externalized then a reference to the window is kept in this array
						model.qv().group[obj.groupId].quickViewData = {icon:{type : "group"}};// view data of the group;
						if(obj.onGroupReady !== undefined){
							obj.onGroupReady(obj);
						}

						model.qv().itemsGroupCount = model.qv().itemsGroupCount + 1;
					}
					model.qv().group[obj.groupId].groupContent.push(obj.$$_qv_id);
					// $log.log(model.qv().group);

					if(isPopingBack){
						// var i = 0;
						// while(i < model.qv().group[obj.groupId].groupExternals.length &&
						// 		model.qv().group[groupId].groupExternals[i].id !== obj.$$_qv_id){
						// 	i++;
			    		// }
						// if(model.qv().group[obj.groupId].groupExternals[i] &&
						// 		model.qv().group[obj.groupId].groupExternals[i].id === obj.$$_qv_id){
						// 	model.qv().group[obj.groupId].groupExternals.splice(i, 1);
						// }
					}
			    },

			    //Removes an item from a group.
			    //Called when closing a patient activity to remove it from the patient group
			    removeFromGroup: function(obj, reason){
			    	if(model.qv().group[obj.groupId] !== undefined){
			    		var itemIndex = model.qv().group[obj.groupId].groupContent.indexOf(obj.$$_qv_id);
			    		if(itemIndex > -1){
			    			// if(service.isExternal(reason)){
							// 	console.log(model.qv().group[obj.groupId]);
			    			// 	model.qv().group[obj.groupId].groupExternals.push(reason);
			    			// }
			    			model.qv().group[obj.groupId].groupContent.splice(itemIndex,1 );
			    		}
			    		if(model.qv().group[obj.groupId].groupContent.length === 0){
			    			delete model.qv().group[obj.groupId];
			    			model.qv().itemsGroupCount = model.qv().itemsGroupCount - 1;
			    		}
			    	}

			    },
			    //Pop out the quickview modal to and external view.
				external: function(mObj, reuseWindowMObj){
					return eventPromise(function(p){
						if(mObj.qv.onQvExternalize){
							Event.emit(mObj.qv.onQvExternalize, {mObj: mObj}, function(){
								externaliseQuickView(mObj, reuseWindowMObj);
								p.resolve(mObj)
							}, p.reject);
						}else{
							externaliseQuickView(mObj, reuseWindowMObj);
							p.resolve(mObj);
						}
					});
				},
				createEvents: function(mObj, qvEventArray){
					addEvents(mObj, qvEventArray);
				},
				removeEvents: function(mObj, qvEventArray){
					removeEvents(mObj, qvEventArray);
				},
				add: function(input){
					return addNewQuickViewIfPossible(input);
				},

				//returns a class that represents the gender passed in parameter
				getGenderIcon: function (gender){
					if(gender === 'M'){
						return "fa-mars";
					}else if(gender === 'F'){
						return "fa-venus";
					}else{
						return "fa-transgender";
					}
				},
				addQuickViewOptions: function(quickViewData){

					function setDefault(hasPatient){
						if(hasPatient){
							quickViewData.icon.cssClasses = service.getGenderIcon(quickViewData.pat.gender);
							quickViewData.icon.title=model.getPatIdTitle(quickViewData.pat);
							quickViewData.viewerType = "pat";
						}else{
							quickViewData.icon.cssClasses="fa-info-circle";
							quickViewData.icon.title="";
							quickViewData.viewerType = "unknown";
						}
					}


					var actData = quickViewData.qvActData;
					var patIdTitle = "Patient X\n";
					var hasPatient = quickViewData.pat && quickViewData.pat.id;
					if (!quickViewData.icon) {
						quickViewData.icon = {};
					}
					if (hasPatient) {
						patIdTitle = model.getPatIdTitle(quickViewData.pat) + "\n";
						quickViewData.icon.initials = quickViewData.pat.firstName[0] + "." + quickViewData.pat.lastName[0] + ".";
					}

					if (angular.isUndefined(actData)) {
						setDefault(hasPatient);
					}else if(actData.className === "CLaboFile" || actData.className === "CLaboResultsProfessionnal"){
						quickViewData.icon.cssClasses="fa-flask labo-cr";
						quickViewData.icon.title= patIdTitle + $filter('translate')('Laboratory') + ": "+ actData.req;
						quickViewData.viewerType = "lab";
					}else if(actData.className === "CLaboReportHeaderFlat"){
						quickViewData.icon.cssClasses="fa-flask labo-cr";
						// var scannedBy = actData.str ? actData.str.replace('~ListScaned.SCANNED_BY~', $filter('translate')('ScannedBy')): "";
						// quickViewData.icon.title= patIdTitle + $filter('translate')('Scan') + ": " + scannedBy;
						quickViewData.viewerType =  "labdsq";
					}else if(actData.className === "CBasePatientImage" || actData.className === "CPatientImage"){
						quickViewData.icon.cssClasses="fa-file-text-o doc-cr";
						var scannedBy = actData.str ? actData.str.replace('~ListScaned.SCANNED_BY~', $filter('translate')('ScannedBy')): "";
						quickViewData.icon.title= patIdTitle + $filter('translate')('Scan') + ": " + scannedBy;
						quickViewData.viewerType =  "doc";
					}else if(actData.className === "CFaxSend"){
						quickViewData.icon.cssClasses="fa-fax doc-cr";
						//var scannedBy = actData.str ? actData.str.replace('~ListScaned.SCANNED_BY~', $filter('translate')('ScannedBy')): "";
						//quickViewData.icon.title= patIdTitle + $filter('translate')('Scan') + ": " + scannedBy;
						quickViewData.viewerType =  "fax";
					}else if(actData.className === "CImagingResultExam"){
						quickViewData.icon.cssClasses="fa-file-text-o doc-cr";
						// var scannedBy = actData.str ? actData.str.replace('~ListScaned.SCANNED_BY~', $filter('translate')('ScannedBy')): "";
						// quickViewData.icon.title= patIdTitle + $filter('translate')('Scan') + ": " + scannedBy;
						quickViewData.viewerType =  "docdsq";
					}else if(actData.className === "CPatientDischargeCareSummary"){
						quickViewData.icon.cssClasses="fa-file-text-o doc-cr";
						// var scannedBy = actData.str ? actData.str.replace('~ListScaned.SCANNED_BY~', $filter('translate')('ScannedBy')): "";
						// quickViewData.icon.title= patIdTitle + $filter('translate')('Scan') + ": " + scannedBy;
						quickViewData.viewerType =  "sommhospdsq";
					} else if(actData.className === "CCourrielTexte"){
						quickViewData.icon.cssClasses="fa-envelope-o msg-cr";
						quickViewData.icon.title= patIdTitle + $filter('translate')('Message') + ": " + actData.dataText;
						quickViewData.viewerType = "courriel";
//					} else if((actData.className === "CChatMessage" || actData.className === "CBaseChatMessage")){
//						quickViewData.icon.cssClasses="fa-envelope-o msg-cr";
//						quickViewData.icon.title= patIdTitle + $filter('translate')('Message') + ": " + actData.dataText;
//						quickViewData.viewerType = "msg";
					}else if(actData.className === "CAppointment"){
						quickViewData.icon.cssClasses="fa-calendar appoint-cr";
						quickViewData.icon.title= patIdTitle + $filter('translate')('Appointment') + ": " + actData.date;
						quickViewData.viewerType = "app";
					}else if(actData.className === "CPatientSurvey"){
						quickViewData.icon.cssClasses="fa-quora";
						quickViewData.icon.title= patIdTitle + $filter('translate')('PatientSurvey') + ": " + actData.titleFr;
						quickViewData.viewerType = "srvy";
					}else if(actData.className === "CTask"){
						quickViewData.icon.cssClasses="fa-check-circle task-cr";
						quickViewData.icon.title= patIdTitle + $filter('translate')('Task') + ": " + actData.patientText;
						quickViewData.viewerType = "task";
					}else if(actData.className === "CPatientRecall"){
						quickViewData.icon.cssClasses="fa-bell-o reminder-cr";
						quickViewData.icon.title= patIdTitle + $filter('translate')('RemindersNotClin') + ": " + actData.date;
						quickViewData.viewerType = "reminder";
					}else if(actData.className === "CEncounter"){
						quickViewData.icon.cssClasses="fa-folder cons-cr";
						if(actData.editMode || (actData.viewbag && actData.viewbag.editEnc && actData.viewbag.editEnc.editMode)){
							quickViewData.icon.cssClasses += " red";
						}
						quickViewData.icon.title= patIdTitle + $filter('translate')('ENCOUNTER') + ": " + actData.date;
						quickViewData.viewerType = "enc";
					}else if(actData.className === "CFormData"){
						var edited = "";
						if (actData.prop && actData.prop.readonly===false) {
							edited = " red";
						}
						quickViewData.icon.cssClasses="fa-list-alt form-cr" + edited;
						quickViewData.icon.title= patIdTitle + $filter('translate')('Form') + ": " + actData.form.name;
						quickViewData.viewerType = "form";
					}else if(actData.className === "CSummary"){
						var edited = "";
						// if (actData.prop && actData.prop.readonly===false) {
						// 	edited = " red";
						// }
						quickViewData.icon.cssClasses="fa-id-card-o form-cr" + edited;
						quickViewData.icon.title= patIdTitle + $filter('translate')('PatientMedSummary');
						quickViewData.viewerType = "summary";
					}else{
						setDefault(hasPatient);
					}
					return quickViewData;
				},
				close: function(input, reason){
					return eventPromise(function(p){
						closeQuickView(input, reason).then(p.resolve, p.reject);
					});
				},
				//Helper function for quickview cleanup (prop)
				removeAllEventHandlers:  function (scope){
					var events = Object.keys(scope.qv.ActiveEventsRef);
					for(var i = 0 ; i< events.length; i++){
						Event.off(scope.qv.ActiveEventsRef[events[i]]);
						delete scope.qv.ActiveEventsRef[events[i]];
					}
				},
				isCurrent: function(qv){
					return qv.qv === service.currentModal;
				},
				open : function (input){
					// FIXME désactivé si pour patient car gèle (fait des CACHE ++ jusqu'a plus de mémoire)
					// if (input.templateTitleUrl=="qvPatient_index.html") return;
					if (model.isSumEdit() === true){
						return $q.reject()
					}
					var instantResolvedPromise = $q(function(resolve, reject){resolve()});
					function verifExternal(obj){
						if(obj.qv && obj.qv.isExternal && obj.qv.externalViewer){
							if(!obj.qv.externalViewer.closed && obj.qv.externalViewer.forceFocus){
								obj.qv.externalViewer.forceFocus($window)
								return true
							}else{
								service.cleanUpExternalQV(obj)//The window was closed without cleaning up it's state.
								service.createEvents(mObj, service.qvEvent)
							}
						}

					}
					if(model.activeController() === 'qv'){
						input.externalise = true;
						$window.ofysPayload().qv.externalViewerParentQV.open(input)
						return instantResolvedPromise;
					}
					var mObj = service.add(input);

					if(input.quickViewData.options.setExternal){
						delete input.quickViewData.options.setExternal;
						return service.external(mObj);
					}

					if(verifExternal(mObj)){
						return instantResolvedPromise
					}
					if(mObj.externalise){
						delete mObj.externalise;
						return service.external(mObj);
					}
					function show(){
						return openModal(mObj, input);
					}
					// currentModal default undefined, ::
					// Stores a reference to a modal quickview useful for the last opened modal.
					if(service.currentModal){
						return closeOrMinimiseDirty(service.currentModal, mObj).then(show);
					}
					return show();
				}
		};

		return service;
	}]);

})();