/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.models;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XPersonGroup;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.CEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObject;
import ca.infodata.ofys.ui.dashboard.models.CBaseUser;
import java.util.ArrayList;
import java.util.HashSet;

public class CPersonGroup
extends CEditableDataObject {
    private static final long serialVersionUID = 1L;
    public String className = CPersonGroup.class.getSimpleName();
    public Integer id;
    public String name;
    public Boolean isDeleted;
    public ArrayList<CBaseUser> persons;
    public String personsNames = "";

    public CPersonGroup() {
    }

    public CPersonGroup(XPersonGroup group) {
        this.init(group);
    }

    private void init(XPersonGroup group) {
        super.init((IEditableDataObject)group);
        this.id = group.getId();
        this.name = group.getName();
        this.isDeleted = group.getIsDeleted();
        if (group.getPersons() != null) {
            this.persons = new ArrayList();
            for (Integer p : group.getPersons()) {
                CBaseUser np = new CBaseUser(Application.get().getPersonPluginController().getUserByIdPerson(p));
                XBaseProfessionnal prof = Application.get().getPersonPluginController().getBaseProfessionnalByIdPerson(p, false, false);
                if (prof != null) {
                    np.useAppt = prof.useAppointment;
                }
                this.personsNames = this.personsNames + np.personName + "; ";
                this.persons.add(np);
            }
        }
    }

    public static CPersonGroup c(XPersonGroup x) {
        return x == null ? null : new CPersonGroup(x);
    }

    public XPersonGroup x() {
        XPersonGroup x = new XPersonGroup();
        super.x((EditableDataObject)x);
        x.setId(this.id);
        x.setName(this.name);
        x.setIsDeleted(this.isDeleted);
        if (this.persons != null) {
            HashSet<Integer> userPersons = new HashSet<Integer>();
            for (CBaseUser u : this.persons) {
                userPersons.add(u.idPerson);
            }
            x.setPersons(userPersons);
        }
        return x;
    }

    public <T> CEditableDataObject convertc(T type) {
        XPersonGroup x = (XPersonGroup)XPersonGroup.class.cast(type);
        this.init(x);
        return this;
    }

    public XPersonGroup convertx() {
        return this.x();
    }
}

