/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.client;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.IEformAccessor;
import ca.infodata.ofys.data.middle.dataobjects.eform.XAttenteResultats;
import ca.infodata.ofys.data.middle.dataobjects.eform.XBaseEform;
import ca.infodata.ofys.data.middle.dataobjects.eform.XBaseEformData;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEform;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEformData;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEformDataCriteria;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.StatusException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EFormAccessorClient {
    private static final Logger logger = Logger.getLogger(EFormAccessorClient.class.getName());
    private final IEformAccessor accessor;

    public EFormAccessorClient() {
        this(Application.get().getDataAccessors().getEformAccessor());
    }

    public EFormAccessorClient(IEformAccessor accessor) {
        this.accessor = accessor;
    }

    public IEformAccessor getAccessor() {
        return this.accessor;
    }

    public List<XBaseEformData> listByPerson(Integer id, Boolean withRevision) throws Exception {
        ReturnObject response = this.accessor.listByPerson(id, withRevision);
        this.manageNonOkResponse(response);
        return (List)response.getObj();
    }

    public List<XBaseEformData> listByPatient(Integer id, Boolean fillPatient, Boolean withRevision) throws Exception {
        ReturnObject response = this.accessor.listByPatient(id, withRevision);
        this.manageNonOkResponse(response);
        return (List)response.getObj();
    }

    public List<XEformData> listData(XEformDataCriteria criteria) throws Exception {
        ReturnObject response = this.accessor.listData(criteria);
        this.manageNonOkResponse(response);
        return (List)response.getObj();
    }

    public List<XBaseEformData> dataByIdAnchors(Integer[] ids, Boolean fillPatient, Boolean withRevision) throws Exception {
        ReturnObject response = this.accessor.dataByIdAnchors(ids, fillPatient, withRevision);
        this.manageNonOkResponse(response);
        return (List)response.getObj();
    }

    public List<XBaseEform> list(boolean filterOnClient) throws Exception {
        ReturnObject response = this.accessor.list(filterOnClient);
        this.manageNonOkResponse(response);
        return (List)response.getObj();
    }

    public XEform get(Integer idForm, Integer idFormData) throws Exception {
        ReturnObject response = this.accessor.get(idForm, idFormData);
        this.manageNonOkResponse(response);
        return (XEform)response.getObj();
    }

    public XEform getByCode(String code) throws Exception {
        ReturnObject response = this.accessor.getByCode(code);
        this.manageNonOkResponse(response);
        return (XEform)response.getObj();
    }

    public XEformData getData(Integer id) throws Exception {
        ReturnObject response = this.accessor.getData(id);
        this.manageNonOkResponse(response);
        XEformData xData = (XEformData)response.getObj();
        String s = xData.getData();
        if (s != null && s.length() > 0) {
            String u8 = "";
            try {
                u8 = Application.get().getBase64Processor().decodeUTF8(s);
            }
            catch (UnsupportedEncodingException e) {
                logger.log(Level.SEVERE, "unable to decode EformData", e);
            }
            xData.setData(u8);
        }
        return (XEformData)response.getObj();
    }

    public XEformData saveData(XEformData data) throws Exception {
        String prevData = data.getData();
        data.setData(Application.get().getBase64Processor().encodeUTF8(data.getData()));
        ReturnObject response = this.accessor.saveData(data, false);
        this.manageNonOkResponse(response);
        XEformData retData = (XEformData)response.getObj();
        retData.setData(prevData);
        return retData;
    }

    public XAttenteResultats save(XAttenteResultats data) throws Exception {
        ReturnObject response = this.accessor.saveAttenteResultats(data);
        XAttenteResultats retData = (XAttenteResultats)response.getObj();
        return retData;
    }

    public void removeFromFavorites(int idForm) throws Exception {
        ReturnObject response = this.accessor.removeAsFavorite(idForm);
        this.manageNonOkResponse(response);
    }

    public void addToFavorites(int idForm) throws Exception {
        ReturnObject response = this.accessor.addAsFavorite(idForm);
        this.manageNonOkResponse(response);
    }

    public void delAttenteResultats(int id) throws Exception {
        ReturnObject response = this.accessor.delAttenteResultats(id);
        this.manageNonOkResponse(response);
    }

    public void deleteFormData(int id) throws Exception {
        ReturnObject response = this.accessor.deleteFormData(id);
        this.manageNonOkResponse(response);
    }

    public void unDeleteFormData(int id) throws Exception {
        ReturnObject response = this.accessor.unDeleteFormData(id);
        this.manageNonOkResponse(response);
    }

    public void setInactiveList(int[] idEforms) throws Exception {
        ReturnObject response = this.accessor.setInactiveList(idEforms);
        this.manageNonOkResponse(response);
    }

    public void setActiveList(int[] idEforms) throws Exception {
        ReturnObject response = this.accessor.setActiveList(idEforms);
        this.manageNonOkResponse(response);
    }

    public List<XBaseEform> listFavorites() throws Exception {
        ReturnObject response = this.accessor.listFavorites();
        this.manageNonOkResponse(response);
        return (List)response.getObj();
    }

    private void manageNonOkResponse(ReturnObject r) throws Exception {
        if (r == null) {
            throw new Exception("Null response");
        }
        if (r.getStatus() == null) {
            throw new Exception("No status response");
        }
        if (!r.getStatus().isOkToProceed()) {
            throw new StatusException((IStatus)r.getStatus());
        }
    }
}

