/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.core;

import ca.infodata.ofys.client.web.core.WebApplication;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class JsonAsMap {
    private final Map<String, Object> map = new HashMap<String, Object>();

    public JsonAsMap(Map<String, Object> source) {
        if (source != null) {
            this.map.putAll(source);
        }
    }

    public JsonAsMap() {
    }

    public void put(String key, Object value) {
        this.map.put(key, value);
    }

    public Object get(String key) {
        return this.map.get(key);
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    public boolean has(String key) {
        return this.map.containsKey(key);
    }

    public <T> T get(String key, Class<T> c) {
        if (this.has(key)) {
            Object value = this.get(key);
            try {
                return WebApplication.get().getConvertProcessor().convert(value, c);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to read key " + key + " with value " + value + " as " + c.getName(), e);
            }
        }
        return null;
    }

    public <T> T get(String key, T defaultValue, Class<T> c) {
        T t;
        if (this.has(key) && (t = this.get(key, c)) != null) {
            return t;
        }
        return defaultValue;
    }

    public <T> T get2(String key, Supplier<T> defaultValueSupplier, Class<T> c) {
        T t;
        if (this.has(key) && (t = this.get(key, c)) != null) {
            return t;
        }
        return defaultValueSupplier.get();
    }

    public Object getRequired(String key) {
        if (this.has(key)) {
            Object value = this.get(key);
            if (value == null) {
                throw new IllegalArgumentException("Key" + key + " is required to be non null");
            }
            return value;
        }
        throw new IllegalArgumentException("Key " + key + " is required");
    }

    public <T> T getRequired(String key, Class<T> c) {
        if (this.has(key)) {
            T value = this.get(key, c);
            if (value == null) {
                throw new IllegalArgumentException("Key" + key + " is required to be non null");
            }
            return value;
        }
        throw new IllegalArgumentException("Key " + key + " is required");
    }
}

