/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.controller;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.base64.Base64DecodedString;
import ca.infodata.ofys.client.web.controller.AbstractWebController;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.client.web.core.WebSocketFilterById;
import ca.infodata.ofys.client.web.core.routes.RouterFunction;
import ca.infodata.ofys.client.web.core.routes.RouterFunctions;
import ca.infodata.ofys.data.middle.dataobjects.IDDataObject;
import ca.infodata.ofys.data.middle.dataobjects.XBasePatient;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XPatientListText;
import ca.infodata.ofys.data.middle.dataobjects.identifiers.XBaseIdentifierType;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.patient.XFusionPatient;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.dashboard.accessor.AppointmentSyncAccessorClient;
import ca.infodata.ofys.ui.dashboard.accessor.CompletionComboSyncAccessor;
import ca.infodata.ofys.ui.dashboard.accessor.PatientSyncAccessorClient;
import ca.infodata.ofys.ui.dashboard.accessor.ReportSyncAccessorClient;
import ca.infodata.ofys.ui.dashboard.models.CBaseIdentifierType;
import ca.infodata.ofys.ui.dashboard.models.CBasePatient;
import ca.infodata.ofys.ui.dashboard.models.CEditableDataObjectList;
import ca.infodata.ofys.ui.dashboard.models.CFusionPatient;
import ca.infodata.ofys.ui.dashboard.models.CPatient;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocalDateRange;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PatientController
extends AbstractWebController {
    private static final Logger logger = Logger.getLogger(PatientController.class.getName());
    private final PatientSyncAccessorClient patientAccessor = new PatientSyncAccessorClient();
    private final ReportSyncAccessorClient reportAccessor = new ReportSyncAccessorClient();
    private final AppointmentSyncAccessorClient appointmentAccessor = new AppointmentSyncAccessorClient();

    public PatientController() {
        this.getNotificationSystemConsumer().setHandleMethod(this::handleNotification);
    }

    private void handleNotification(DataObjectUpdatedNotification notification) {
        if (notification != null && notification.getObject() instanceof XPatient) {
            try {
                CPatient jMsg = new CPatient((XPatient)notification.getObject());
                ServerResponses.sendJsonToClient(notification.getClientId(), "patient.update", (Object)jMsg);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "notification=" + StringUtils.safeToString((Logger)logger, (Object)notification), e);
            }
        }
    }

    public List<Object> getPatientActivities(Integer idProf, Integer idPatient, LocalDateRange dateRange) {
        if (idPatient != null) {
            List<Object> activities = this.patientAccessor.getPatientActivities(idProf, idPatient, dateRange);
            return activities;
        }
        return null;
    }

    public void setCurrentPatientAsync(Integer id) {
        Application.get().getApplicationUiPlugin().setCurrentPatient(id);
    }

    public void printPatientDocuments(IPatient patient) {
        Application.get().getApplicationUiPlugin().openPatientPrintDialog(patient);
    }

    public void openPatientEditor(Integer idPatient) {
        XPatient patient = this.getXPatient(idPatient);
        Application.get().getApplicationUiPlugin().openPatientEditEditor(patient);
    }

    public void openPatientEncounterEditor(Integer idPatient) {
        XPatient patient = this.getXPatient(idPatient);
        Application.get().getApplicationUiPlugin().openEncounterEditor(patient);
    }

    public ArrayList<String> activitiesGroupOrder(ArrayList<String> groupList) {
        ArrayList<String> orderByDate = groupList;
        Collections.sort(orderByDate, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                SimpleDateFormat sdf = new SimpleDateFormat("d MMMM yyyy");
                int i = 0;
                try {
                    Date d1 = sdf.parse((String)o1);
                    Date d2 = sdf.parse((String)o2);
                    i = -d1.compareTo(d2);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                return i;
            }
        });
        return orderByDate;
    }

    private XPatient[] convertToX(XPatientListText[] patients) {
        if (patients == null) {
            return null;
        }
        XPatient[] res = new XPatient[patients.length];
        for (int i = 0; i < patients.length; ++i) {
            res[i] = patients[i].getPatient();
        }
        return res;
    }

    private CPatient[] XToCPatient(XPatient[] patients) {
        if (patients == null) {
            return new CPatient[0];
        }
        CPatient[] res = new CPatient[patients.length];
        for (int i = 0; i < patients.length; ++i) {
            res[i] = new CPatient(patients[i]);
        }
        return res;
    }

    public XPatient getPatient(int id) {
        return Application.get().getCache().getPatientCache().get(id);
    }

    public XPatient getXPatient(int id) {
        return this.patientAccessor.getPatient(id);
    }

    public XPatient getXPatient(Object patient) {
        if (patient == null) {
            return null;
        }
        if (patient instanceof XPatient) {
            return (XPatient)patient;
        }
        if (patient instanceof XPatientListText) {
            return ((XPatientListText)patient).getPatient();
        }
        if (patient instanceof XBasePatient) {
            return this.patientAccessor.getPatient(((XBasePatient)patient).getId());
        }
        if (patient instanceof IDDataObject) {
            return this.patientAccessor.getPatient(((IDDataObject)patient).getId());
        }
        if (patient instanceof Integer) {
            return this.patientAccessor.getPatient((Integer)patient);
        }
        throw new IllegalArgumentException("unsupported type " + patient);
    }

    @Override
    public RouterFunction<?> getRoutes() {
        return RouterFunctions.routes("/dashboard", RouterFunctions.routeAction("/Patients/editPatient", req -> {
            Integer idPatient = req.getRequiredQueryParam("idPatient", Integer.class);
            this.openPatientEditor(idPatient);
            return ServerResponses.SUCCESS();
        }), RouterFunctions.routeAction("/Patients/patientEncounter", req -> {
            Integer idPatient = req.getRequiredQueryParam("idPatient", Integer.class);
            this.openPatientEncounterEditor(idPatient);
            return ServerResponses.SUCCESS();
        }), RouterFunctions.routes("/Patients/ws", RouterFunctions.routeAction("/newReminder", req -> {
            CPatient p = req.getPostBody(CPatient.class);
            Application.get().getApplicationUiPlugin().openNewRecallEditor(p.x());
            return ServerResponses.SUCCESS();
        }), RouterFunctions.routeAction("/new", req -> {
            if (Application.get().getApplicationUiPlugin().openNewPatientEditor()) {
                return ServerResponses.SUCCESS();
            }
            return ServerResponses.ERROR("New patient dialog could not be created");
        }), RouterFunctions.routeAction("/print", req -> {
            try {
                CPatient p = req.getPostBody(CPatient.class);
                this.printPatientDocuments((IPatient)p.x());
                return ServerResponses.SUCCESS();
            }
            catch (Exception e) {
                return ServerResponses.ERROR("\u00c9chec d'impression. " + e.getMessage());
            }
        }), RouterFunctions.routeAction("/get", req -> {
            Integer idPatient = req.getRequiredQueryParam("idPatient", Integer.class);
            XPatient xPatient = this.getXPatient(idPatient);
            if (xPatient != null) {
                return ServerResponses.toJsonActionResult((Object)new CPatient(xPatient));
            }
            return ServerResponses.ERROR("Could not find patient");
        }), RouterFunctions.routeAction("/getByIds", req -> {
            String ids = req.getRequiredQueryParam("ids");
            CPatient[] list = this.XToCPatient(this.convertToX(this.patientAccessor.getPatientsByIds(ids)));
            return ServerResponses.toJsonActionResult(list);
        }), RouterFunctions.routeAction("/getCreatinine", req -> {
            Integer idPatient = req.getRequiredQueryParam("idPatient", Integer.class);
            String creatinine = this.getCreatinine(idPatient);
            return ServerResponses.toJsonActionResult(creatinine);
        }), RouterFunctions.routeAction("/curr", req -> {
            Integer idPatient = req.getRequiredQueryParam("idPatient", Integer.class);
            if (idPatient > 0) {
                this.setCurrentPatientAsync(idPatient);
                return ServerResponses.SUCCESS();
            }
            return ServerResponses.ERROR("Invalid patient id argument");
        }), RouterFunctions.routeAction("/getFusionPatient", req -> {
            Integer idPatient = req.getRequiredQueryParam("idPatient", Integer.class);
            List<CBasePatient> fusionPatient = this.getFusionPatient(idPatient);
            return ServerResponses.toJsonActionResult(fusionPatient);
        }), RouterFunctions.routeAction("/lastseen", req -> {
            CPatient[] list = this.XToCPatient(this.patientAccessor.findLastSeen());
            return ServerResponses.toJsonActionResult(list);
        }), RouterFunctions.routeAction("/identifiers", req -> {
            List<CBaseIdentifierType> list = this.findIdentifiers();
            return ServerResponses.toJsonActionResult(list);
        }), RouterFunctions.routeAction("/save", req -> {
            CPatient cpatient = req.getPostBody(CPatient.class);
            Boolean askQuestion = req.getQueryParam("askQuestion", true, Boolean.class);
            return ServerResponses.toJsonActionResult(this.save(cpatient, askQuestion));
        }), RouterFunctions.routeAction("/saveFusion", req -> {
            CFusionPatient fusionPatient = req.getPostBody(CFusionPatient.class);
            return ServerResponses.toJsonActionResult(this.saveFusion(fusionPatient, false));
        }), RouterFunctions.routeAction("/openFile", req -> {
            this.openPatientFile(null, null);
            return ServerResponses.SUCCESS();
        }), RouterFunctions.routeAction("/telmedtexto", req -> {
            Integer idPatient = req.getRequiredQueryParam("idPatient", Integer.class);
            String cell = req.getRequiredQueryParam("cell", String.class);
            String room = req.getRequiredQueryParam("room", String.class);
            if (StringUtils.isNotEmpty((String)cell) && idPatient != null && idPatient > 0) {
                String messageBase = "TelMed Ofys https://tm.ofys.biz/" + room;
                try {
                    HashMap<String, Serializable> mapAppt = new HashMap<String, Serializable>();
                    mapAppt.put("id", idPatient);
                    mapAppt.put("no", (Serializable)((Object)cell));
                    mapAppt.put("txt", (Serializable)((Object)messageBase));
                    Application.get().getDataAccessors().getPatientAccessor().sendTexto(mapAppt);
                }
                catch (StatusException e1) {
                    return ServerResponses.ERROR(e1.getMessage());
                }
                catch (Exception e2) {
                    return ServerResponses.ERROR(e2.getMessage());
                }
            }
            return ServerResponses.SUCCESS();
        }), RouterFunctions.routeAction("/telmedemail", req -> {
            Integer idPatient = req.getRequiredQueryParam("idPatient", Integer.class);
            String email = req.getRequiredQueryParam("email", String.class);
            String with = req.getRequiredQueryParam("with", String.class);
            String room = req.getRequiredQueryParam("room", String.class);
            Integer idClient = req.getRequiredQueryParam("idClient", Integer.class);
            String messageBase = "<a href=\"https://tm.ofys.biz/" + room + "\">TelMed Ofys</a>";
            try {
                HashMap<String, Serializable> map = new HashMap<String, Serializable>();
                map.put("idClient", idClient);
                map.put("idPatient", idPatient);
                map.put("txt", (Serializable)((Object)messageBase));
                map.put("with", (Serializable)((Object)with));
                map.put("email", (Serializable)((Object)email));
                map.put("type", (Serializable)((Object)"telmed"));
                Application.get().getDataAccessors().getPatientAccessor().sendEmails(map);
            }
            catch (StatusException e1) {
                return ServerResponses.ERROR(e1.getMessage());
            }
            catch (Exception e2) {
                return ServerResponses.ERROR(e2.getMessage());
            }
            return ServerResponses.SUCCESS();
        }), RouterFunctions.routeAction("/setAsUsed", req -> {
            Integer id = req.getRequiredQueryParam("idPatient", Integer.class);
            this.patientAccessor.setAsUsed(id);
            return ServerResponses.toJsonActionResult(null);
        }), RouterFunctions.routeAction("/search", req -> {
            CPatient[] list;
            try {
                Base64DecodedString q = req.getQueryParam("q", Base64DecodedString.BLANK, Base64DecodedString.class);
                list = this.XToCPatient(this.convertToX(this.patientAccessor.findPatient(q.getDecoded())));
            }
            catch (Exception e) {
                list = this.XToCPatient(null);
                logger.log(Level.SEVERE, "Patient search failed", e);
            }
            return ServerResponses.toJsonActionResult(list);
        }), RouterFunctions.routeAction("/patientDependents", req -> {
            Integer id = req.getRequiredQueryParam("idPatient", Integer.class);
            CPatient[] list = this.XToCPatient(this.patientAccessor.findPatientDependents(id));
            return ServerResponses.toJsonActionResult(list);
        }), RouterFunctions.routeAction("/findPatientExactNoDossier", req -> {
            Base64DecodedString noDossier = req.getRequiredQueryParam("noDossier", Base64DecodedString.class);
            XPatient xPatient = this.patientAccessor.findPatientExactNoDossier(noDossier.getDecoded());
            if (xPatient != null) {
                return ServerResponses.toJsonActionResult((Object)new CPatient(xPatient));
            }
            return ServerResponses.ERROR("Could not find patient");
        }), RouterFunctions.routeAction("/searchAdvanced", req -> {
            CPatient[] list;
            try {
                PatientSyncAccessorClient.PatientSearchQuery data = req.getPostBody(PatientSyncAccessorClient.PatientSearchQuery.class);
                if (data.q != null && !data.q.equals("")) {
                    data.q = Application.get().getBase64Processor().decodeUTF8(data.q);
                }
                if (data.noLimit == null) {
                    data.noLimit = false;
                }
                if (data.noTelephone == null) {
                    data.noTelephone = "";
                }
                if (data.inObjectUsage == null) {
                    data.inObjectUsage = false;
                }
                if (data.idProfessionnal == null) {
                    data.idProfessionnal = -1;
                }
                if (data.idIntervenant == null) {
                    data.idIntervenant = -1;
                }
                if (data.rdvsToMove == null) {
                    data.rdvsToMove = false;
                }
                if (data.returnOneOrNull == null) {
                    data.returnOneOrNull = false;
                }
                list = this.XToCPatient(this.convertToX(this.patientAccessor.findPatient(data)));
            }
            catch (Exception e) {
                list = this.XToCPatient(null);
                logger.log(Level.SEVERE, "Patient advanced search failed", e);
            }
            return ServerResponses.toJsonActionResult(list);
        })));
    }

    public String getCreatinine(int idPatient) {
        String p = "";
        try {
            p = (String)this.patientAccessor.getPatientFlagDetail(idPatient).getObj();
            return p;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "failed to get creatinine", e);
            return null;
        }
    }

    public List<CBasePatient> getFusionPatient(int idPatient) {
        ArrayList<CBasePatient> patientList = new ArrayList<CBasePatient>();
        try {
            XFusionPatient p = (XFusionPatient)this.patientAccessor.getFusionPatient(idPatient).getObj();
            for (IPatient pat : p.getTargetPatients()) {
                patientList.add(new CBasePatient(new XBasePatient(pat)));
            }
            return patientList;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "failed to get fusion patient", e);
            return null;
        }
    }

    public List<CBaseIdentifierType> findIdentifiers() {
        List<?> res = new CompletionComboSyncAccessor().findAllCompletionComboType(XBaseIdentifierType.type);
        CEditableDataObjectList<CBaseIdentifierType> types = new CEditableDataObjectList<CBaseIdentifierType>(res, CBaseIdentifierType.class);
        return types;
    }

    public ReturnObject save(CPatient pat, boolean askQuestion) {
        XPatient xpat = pat.x();
        ReturnObject answer = this.patientAccessor.save(xpat, askQuestion);
        if (pat.mustDeleteFutureAppointmentAndRecallOnDelete.booleanValue()) {
            this.appointmentAccessor.suppressFuturApp(pat.idPatient);
        }
        XPatient[] res = answer.getObj() instanceof XPatient ? new XPatient[]{(XPatient)answer.getObj()} : (XPatient[])answer.getObj();
        IStatus notif = answer.getStatus().getStatus(IStatus.Severity.NEED_MORE_INFO);
        IStatus duplicatePatient = answer.getStatus().getStatus("DUPLICATE_PATIENT");
        if (res != null) {
            ArrayList<CPatient> retour = new ArrayList<CPatient>();
            for (XPatient i : res) {
                if (notif == null && answer.getStatus().isOK()) {
                    this.newLocalDataObjectNotificationSafe(i);
                }
                retour.add(new CPatient(i));
            }
            if (duplicatePatient != null && duplicatePatient.getData() != null && duplicatePatient.getData() instanceof ArrayList) {
                ArrayList<CPatient> possibledupes = new ArrayList<CPatient>();
                ArrayList xpossibledupes = (ArrayList)notif.getData();
                for (XPatient app : xpossibledupes) {
                    possibledupes.add(new CPatient(app));
                }
                duplicatePatient.setData(possibledupes);
            }
            answer.setObj(retour);
        }
        return answer;
    }

    public ReturnObject saveFusion(CFusionPatient fusionPatient, Boolean askQuestion) {
        XFusionPatient xfusion = new XFusionPatient();
        for (CBasePatient cbase : fusionPatient.getTargetPatients()) {
            xfusion.getTargetPatients().add(cbase.x());
        }
        xfusion.setRootPatient((IPatient)fusionPatient.getRootPatient().x());
        return this.patientAccessor.saveFusion(xfusion, askQuestion);
    }

    public void openCourriel(String clientUid) {
        try {
            ServerResponses.sendJsonToClient(new WebSocketFilterById(clientUid), "courriel.openPage", null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error opening courriel in ofys 5.", e);
        }
    }

    public void newCourriel(XPatient patient, String clientUid) {
        try {
            CPatient cpatient = patient == null && Application.get().getPersonPluginController().getCurrentPatient() != null ? new CPatient(Application.get().getPersonPluginController().getCurrentPatient()) : (patient == null ? null : new CPatient(patient));
            ServerResponses.sendJsonToClient(new WebSocketFilterById(clientUid), "courriel.createNew", cpatient);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error opening courreil in ofys 5 with linked patient=" + StringUtils.safeToString((Logger)logger, (Object)patient), e);
        }
    }

    public void openPatientFile(XPatient patient, String clientUid) {
        try {
            CPatient cpatient = patient == null && Application.get().getPersonPluginController().getCurrentPatient() != null ? new CPatient(Application.get().getPersonPluginController().getCurrentPatient()) : (patient == null ? null : new CPatient(patient));
            ServerResponses.sendJsonToClient(new WebSocketFilterById(clientUid), "patient.openFile", cpatient);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error opening patien file in ofys 5. patient=" + StringUtils.safeToString((Logger)logger, (Object)patient), e);
        }
    }

    private void newLocalDataObjectNotificationSafe(XPatient patient) {
        try {
            Application.get().getGlobalInstances().getNotificationSystem().sendDataObjectUpdatedNotification((IDataObject)patient);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to send local notification for patient " + StringUtils.safeToString((Logger)logger, (Object)patient), e);
        }
    }
}

