/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.util;

import ca.infodata.ofys.client.util.SupplierE;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DownloadSupplier
implements SupplierE<byte[]> {
    private static final Logger logger = Logger.getLogger(DownloadSupplier.class.getName());
    private static final int MAX_BUFFER_SIZE = 1024;
    protected final String url;
    protected final URL from;
    private boolean isDownloading;
    private byte[] downloaded;

    public DownloadSupplier(String url) throws MalformedURLException {
        this.url = url;
        this.from = new URL(url);
        this.isDownloading = false;
    }

    public synchronized void download() throws IllegalStateException, Exception {
        if (this.isDownloading) {
            throw new IllegalStateException("actually downloading");
        }
        try {
            this.isDownloading = true;
            this.downloadInternal();
        }
        finally {
            this.isDownloading = false;
        }
    }

    public byte[] dowloaded() throws IllegalStateException {
        if (this.isDownloading) {
            throw new IllegalStateException("actually downloading");
        }
        return this.downloaded;
    }

    @Override
    public synchronized byte[] get() throws Exception {
        if (this.downloaded != null) {
            return this.downloaded;
        }
        try {
            this.download();
            return this.dowloaded();
        }
        catch (Exception e) {
            String message = "Failed to download from url " + this.url;
            logger.log(Level.SEVERE, message, e);
            throw new RuntimeException(message, e);
        }
    }

    public String toString() {
        return "DownloadSupplier [url=" + this.url + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadInternal() throws Exception {
        ByteArrayOutputStream outputStream = null;
        InputStream inputStream = null;
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)this.from.openConnection();
            connection.setDefaultUseCaches(false);
            connection.setUseCaches(false);
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode / 100 != 2) {
                throw new IOException("Error. http response code != 200. responseCode = " + responseCode);
            }
            int size = connection.getContentLength();
            if (size < 1) {
                throw new IOException("Error. size < 1");
            }
            inputStream = connection.getInputStream();
            boolean downloading = true;
            int downloaded = 0;
            outputStream = new ByteArrayOutputStream(size);
            while (downloading) {
                byte[] buffer = size - downloaded > 1024 ? new byte[1024] : new byte[size - downloaded];
                int read = inputStream.read(buffer);
                int readTry = -1;
                while (read == -1) {
                    if (downloaded < size && readTry < 5) {
                        Thread.sleep(200L);
                        ++readTry;
                        read = inputStream.read(buffer);
                        continue;
                    }
                    read = -100;
                    break;
                }
                if (read == -100) {
                    throw new IOException("Error. read == -1 ; buffer.length = " + buffer.length);
                }
                outputStream.write(buffer, 0, read);
                if ((downloaded += read) < size) continue;
                downloading = false;
                break;
            }
            outputStream.flush();
            this.downloaded = outputStream.toByteArray();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            this.closeConnection(connection);
        }
    }

    private void closeConnection(HttpURLConnection connection) {
        if (connection != null) {
            try {
                connection.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

