/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.mqtt.mqtt5.message.connect.connack;

import com.hivemq.client.internal.mqtt.message.MqttCommonReasonCode;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.mqtt.mqtt5.message.Mqtt5ReasonCode;

public enum Mqtt5ConnAckReasonCode implements Mqtt5ReasonCode
{
    SUCCESS(MqttCommonReasonCode.SUCCESS),
    UNSPECIFIED_ERROR(MqttCommonReasonCode.UNSPECIFIED_ERROR),
    MALFORMED_PACKET(MqttCommonReasonCode.MALFORMED_PACKET),
    PROTOCOL_ERROR(MqttCommonReasonCode.PROTOCOL_ERROR),
    IMPLEMENTATION_SPECIFIC_ERROR(MqttCommonReasonCode.IMPLEMENTATION_SPECIFIC_ERROR),
    UNSUPPORTED_PROTOCOL_VERSION(132),
    CLIENT_IDENTIFIER_NOT_VALID(133),
    BAD_USER_NAME_OR_PASSWORD(134),
    NOT_AUTHORIZED(MqttCommonReasonCode.NOT_AUTHORIZED),
    SERVER_UNAVAILABLE(136),
    SERVER_BUSY(MqttCommonReasonCode.SERVER_BUSY),
    BANNED(138),
    BAD_AUTHENTICATION_METHOD(MqttCommonReasonCode.BAD_AUTHENTICATION_METHOD),
    TOPIC_NAME_INVALID(MqttCommonReasonCode.TOPIC_NAME_INVALID),
    PACKET_TOO_LARGE(MqttCommonReasonCode.PACKET_TOO_LARGE),
    QUOTA_EXCEEDED(MqttCommonReasonCode.QUOTA_EXCEEDED),
    PAYLOAD_FORMAT_INVALID(MqttCommonReasonCode.PAYLOAD_FORMAT_INVALID),
    RETAIN_NOT_SUPPORTED(MqttCommonReasonCode.RETAIN_NOT_SUPPORTED),
    QOS_NOT_SUPPORTED(MqttCommonReasonCode.QOS_NOT_SUPPORTED),
    USE_ANOTHER_SERVER(MqttCommonReasonCode.USE_ANOTHER_SERVER),
    SERVER_MOVED(MqttCommonReasonCode.SERVER_MOVED),
    CONNECTION_RATE_EXCEEDED(MqttCommonReasonCode.CONNECTION_RATE_EXCEEDED);

    private final int code;
    private static final int ERROR_CODE_MIN;
    private static final int ERROR_CODE_MAX;
    @NotNull
    private static final @NotNull Mqtt5ConnAckReasonCode @NotNull [] ERROR_CODE_LOOKUP;

    private Mqtt5ConnAckReasonCode(int code) {
        this.code = code;
    }

    private Mqtt5ConnAckReasonCode(MqttCommonReasonCode reasonCode) {
        this(reasonCode.getCode());
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Nullable
    public static Mqtt5ConnAckReasonCode fromCode(int code) {
        if (code == Mqtt5ConnAckReasonCode.SUCCESS.code) {
            return SUCCESS;
        }
        if (code < ERROR_CODE_MIN || code > ERROR_CODE_MAX) {
            return null;
        }
        return ERROR_CODE_LOOKUP[code - ERROR_CODE_MIN];
    }

    static {
        ERROR_CODE_MIN = Mqtt5ConnAckReasonCode.UNSPECIFIED_ERROR.code;
        ERROR_CODE_MAX = Mqtt5ConnAckReasonCode.CONNECTION_RATE_EXCEEDED.code;
        ERROR_CODE_LOOKUP = new Mqtt5ConnAckReasonCode[ERROR_CODE_MAX - ERROR_CODE_MIN + 1];
        for (Mqtt5ConnAckReasonCode reasonCode : Mqtt5ConnAckReasonCode.values()) {
            if (reasonCode == SUCCESS) continue;
            Mqtt5ConnAckReasonCode.ERROR_CODE_LOOKUP[reasonCode.code - Mqtt5ConnAckReasonCode.ERROR_CODE_MIN] = reasonCode;
        }
    }
}

