/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.codec.encoder;

import com.hivemq.client.internal.mqtt.MqttClientConnectionConfig;
import com.hivemq.client.internal.mqtt.codec.encoder.MqttEncoderContext;
import com.hivemq.client.internal.mqtt.codec.encoder.MqttMessageEncoder;
import com.hivemq.client.internal.mqtt.codec.encoder.MqttMessageEncoders;
import com.hivemq.client.internal.mqtt.ioc.ConnectionScope;
import com.hivemq.client.internal.mqtt.message.MqttMessage;
import com.hivemq.client.internal.shaded.io.netty.buffer.ByteBuf;
import com.hivemq.client.internal.shaded.io.netty.buffer.ByteBufAllocator;
import com.hivemq.client.internal.shaded.io.netty.channel.ChannelDuplexHandler;
import com.hivemq.client.internal.shaded.io.netty.channel.ChannelHandlerContext;
import com.hivemq.client.internal.shaded.io.netty.channel.ChannelPromise;
import com.hivemq.client.internal.shaded.javax.inject.Inject;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;

@ConnectionScope
public class MqttEncoder
extends ChannelDuplexHandler {
    @NotNull
    public static final String NAME = "encoder";
    @NotNull
    private final MqttMessageEncoders encoders;
    @NotNull
    private final MqttEncoderContext context;
    private boolean inRead = false;
    private boolean pendingFlush = false;

    @Inject
    MqttEncoder(@NotNull MqttMessageEncoders encoders) {
        this.encoders = encoders;
        this.context = new MqttEncoderContext(ByteBufAllocator.DEFAULT);
    }

    public void onConnected(@NotNull MqttClientConnectionConfig connectionConfig) {
        this.context.setMaximumPacketSize(connectionConfig.getSendMaximumPacketSize());
    }

    @Override
    public void write(@NotNull ChannelHandlerContext ctx, @NotNull Object msg, @NotNull ChannelPromise promise) {
        if (msg instanceof MqttMessage) {
            MqttMessage message = (MqttMessage)msg;
            MqttMessageEncoder<?> messageEncoder = this.encoders.get(message.getType().getCode());
            if (messageEncoder == null) {
                throw new UnsupportedOperationException();
            }
            ByteBuf out = messageEncoder.castAndEncode(message, this.context);
            ctx.write(out, promise);
        } else {
            ctx.write(msg, promise);
        }
    }

    @Override
    public void flush(@NotNull ChannelHandlerContext ctx) {
        if (this.inRead) {
            this.pendingFlush = true;
        } else {
            ctx.flush();
        }
    }

    @Override
    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        this.inRead = true;
        ctx.fireChannelRead(msg);
    }

    @Override
    public void channelReadComplete(@NotNull ChannelHandlerContext ctx) {
        ctx.fireChannelReadComplete();
        this.inRead = false;
        if (this.pendingFlush) {
            this.pendingFlush = false;
            ctx.flush();
        }
    }

    @Override
    public boolean isSharable() {
        return false;
    }
}

