/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt;

import com.hivemq.client.internal.mqtt.MqttAsyncClient;
import com.hivemq.client.internal.mqtt.MqttBlockingClient;
import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.MqttRxClient;
import com.hivemq.client.internal.mqtt.MqttRxClientBuilderBase;
import com.hivemq.client.internal.mqtt.advanced.MqttClientAdvancedConfig;
import com.hivemq.client.internal.mqtt.advanced.MqttClientAdvancedConfigBuilder;
import com.hivemq.client.internal.mqtt.message.auth.MqttSimpleAuth;
import com.hivemq.client.internal.mqtt.message.auth.MqttSimpleAuthBuilder;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublishBuilder;
import com.hivemq.client.internal.mqtt.message.publish.MqttWillPublish;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.MqttVersion;
import com.hivemq.client.mqtt.mqtt5.Mqtt5ClientBuilder;
import com.hivemq.client.mqtt.mqtt5.advanced.Mqtt5ClientAdvancedConfig;
import com.hivemq.client.mqtt.mqtt5.auth.Mqtt5EnhancedAuthMechanism;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5SimpleAuth;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5Publish;

public class MqttRxClientBuilder
extends MqttRxClientBuilderBase<MqttRxClientBuilder>
implements Mqtt5ClientBuilder {
    @NotNull
    private MqttClientAdvancedConfig advancedConfig = MqttClientAdvancedConfig.DEFAULT;
    @Nullable
    private MqttSimpleAuth simpleAuth;
    @Nullable
    private Mqtt5EnhancedAuthMechanism enhancedAuthMechanism;
    @Nullable
    private MqttWillPublish willPublish;

    public MqttRxClientBuilder() {
    }

    MqttRxClientBuilder(@NotNull MqttRxClientBuilderBase<?> clientBuilder) {
        super(clientBuilder);
    }

    @Override
    @NotNull
    protected MqttRxClientBuilder self() {
        return this;
    }

    @Override
    @NotNull
    public MqttRxClientBuilder advancedConfig(@NotNull Mqtt5ClientAdvancedConfig advancedConfig) {
        this.advancedConfig = Checks.notImplemented(advancedConfig, MqttClientAdvancedConfig.class, "Advanced config");
        return this;
    }

    public  @NotNull MqttClientAdvancedConfigBuilder.Nested<MqttRxClientBuilder> advancedConfig() {
        return new MqttClientAdvancedConfigBuilder.Nested<MqttRxClientBuilder>(this.advancedConfig, this::advancedConfig);
    }

    @Override
    @NotNull
    public MqttRxClientBuilder simpleAuth(@Nullable Mqtt5SimpleAuth simpleAuth) {
        this.simpleAuth = Checks.notImplementedOrNull(simpleAuth, MqttSimpleAuth.class, "Simple auth");
        return this;
    }

    public  @NotNull MqttSimpleAuthBuilder.Nested<MqttRxClientBuilder> simpleAuth() {
        return new MqttSimpleAuthBuilder.Nested<MqttRxClientBuilder>(this::simpleAuth);
    }

    @Override
    @NotNull
    public MqttRxClientBuilder enhancedAuth(@Nullable Mqtt5EnhancedAuthMechanism enhancedAuthMechanism) {
        this.enhancedAuthMechanism = enhancedAuthMechanism;
        return this;
    }

    @Override
    @NotNull
    public MqttRxClientBuilder willPublish(@Nullable Mqtt5Publish willPublish) {
        this.willPublish = willPublish == null ? null : Checks.notImplemented(willPublish, MqttPublish.class, "Will publish").asWill();
        return this;
    }

    public  @NotNull MqttPublishBuilder.WillNested<MqttRxClientBuilder> willPublish() {
        return new MqttPublishBuilder.WillNested<MqttRxClientBuilder>(this::willPublish);
    }

    @Override
    @NotNull
    public MqttRxClient build() {
        return this.buildRx();
    }

    @Override
    @NotNull
    public MqttRxClient buildRx() {
        return new MqttRxClient(this.buildClientConfig());
    }

    @Override
    @NotNull
    public MqttAsyncClient buildAsync() {
        return this.buildRx().toAsync();
    }

    @Override
    @NotNull
    public MqttBlockingClient buildBlocking() {
        return this.buildRx().toBlocking();
    }

    @NotNull
    private MqttClientConfig buildClientConfig() {
        return this.buildClientConfig(MqttVersion.MQTT_5_0, this.advancedConfig, MqttClientConfig.ConnectDefaults.of(this.simpleAuth, this.enhancedAuthMechanism, this.willPublish));
    }
}

