/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.encryption;

import ca.infodata.util1.encryption.DecryptionException;
import ca.infodata.util1.encryption.EncryptionException;
import ca.infodata.util1.encryption.StringUtils;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.codec.binary.Base64;

public final class DesEncrypter {
    private static final Logger logger = Logger.getLogger(DesEncrypter.class.getName());
    private static final String pass = "p*se($90st54to!";
    private static final byte[] salt = new byte[]{-88, -101, -56, 50, 85, 53, -29, 3};
    private static final int iterationCount = 19;
    private Cipher ecipher;
    private Cipher dcipher;

    private DesEncrypter(String passPhrase) throws Exception {
        try {
            PBEKeySpec keySpec = new PBEKeySpec(passPhrase.toCharArray(), salt, 19);
            SecretKey key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(keySpec);
            this.ecipher = Cipher.getInstance(key.getAlgorithm());
            this.dcipher = Cipher.getInstance(key.getAlgorithm());
            PBEParameterSpec paramSpec = new PBEParameterSpec(salt, 19);
            this.ecipher.init(1, (Key)key, paramSpec);
            this.dcipher.init(2, (Key)key, paramSpec);
        }
        catch (InvalidAlgorithmParameterException e) {
            logger.log(Level.WARNING, "DesEncrypter(String passPhrase = " + passPhrase + ")", e);
            throw e;
        }
        catch (InvalidKeySpecException e) {
            logger.log(Level.WARNING, "DesEncrypter(String passPhrase = " + passPhrase + ")", e);
            throw e;
        }
        catch (NoSuchPaddingException e) {
            logger.log(Level.WARNING, "DesEncrypter(String passPhrase = " + passPhrase + ")", e);
            throw e;
        }
        catch (NoSuchAlgorithmException e) {
            logger.log(Level.WARNING, "DesEncrypter(String passPhrase = " + passPhrase + ")", e);
            throw e;
        }
        catch (InvalidKeyException e) {
            logger.log(Level.WARNING, "DesEncrypter(String passPhrase = " + passPhrase + ")", e);
            throw e;
        }
    }

    private String encrypt(String str) throws Exception {
        try {
            byte[] utf8 = str.getBytes("UTF8");
            byte[] enc = this.ecipher.doFinal(utf8);
            return DesEncrypter.encodeBase64String(enc);
        }
        catch (BadPaddingException e) {
            logger.log(Level.WARNING, "encrypt(String str = " + str + ")", e);
            throw e;
        }
        catch (IllegalBlockSizeException e) {
            logger.log(Level.WARNING, "encrypt(String str = " + str + ")", e);
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.WARNING, "encrypt(String str = " + str + ")", e);
            throw e;
        }
    }

    private static String encodeBase64String(byte[] binaryData) {
        return StringUtils.newStringUtf8(Base64.encodeBase64((byte[])binaryData, (boolean)true));
    }

    private String decrypt(String str) throws Exception {
        try {
            byte[] dec = DesEncrypter.decodeBase64String(str);
            byte[] utf8 = this.dcipher.doFinal(dec);
            return new String(utf8, "UTF8");
        }
        catch (BadPaddingException e) {
            logger.log(Level.WARNING, "decrypt(String str = " + str + ")", e);
            throw e;
        }
        catch (IllegalBlockSizeException e) {
            logger.log(Level.WARNING, "decrypt(String str = " + str + ")", e);
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.WARNING, "decrypt(String str = " + str + ")", e);
            throw e;
        }
    }

    private static byte[] decodeBase64String(String pArray) {
        return new Base64().decode(StringUtils.getBytesUtf8(pArray));
    }

    public static String encryptMe(String s, String pass) throws EncryptionException {
        return DesEncrypter.encryptMe(s, pass, false);
    }

    public static String encryptMe(String s, String pass, boolean fix1310) throws EncryptionException {
        if (s == null) {
            throw new NullPointerException("s");
        }
        if (pass == null) {
            throw new NullPointerException("pass");
        }
        try {
            String key = new DesEncrypter(pass).encrypt(s);
            if (fix1310) {
                key = DesEncrypter.fix1310(key);
            }
            return key;
        }
        catch (Exception e) {
            throw new EncryptionException("encrypt(" + s + "," + pass + ")", e);
        }
    }

    private static String fix1310(String key) {
        byte[] bytes = key.getBytes();
        if (bytes[bytes.length - 1] == 10 && bytes[bytes.length - 2] == 13) {
            byte[] bytes2 = new byte[bytes.length - 2];
            System.arraycopy(bytes, 0, bytes2, 0, bytes2.length);
            key = new String(bytes2);
        }
        return key;
    }

    public static String decryptMe(String s, String pass) throws DecryptionException {
        return DesEncrypter.decryptMe(s, pass, false);
    }

    public static String decryptMe(String s, String pass, boolean fix1310) throws DecryptionException {
        if (s == null) {
            throw new NullPointerException("s");
        }
        if (pass == null) {
            throw new NullPointerException("pass");
        }
        try {
            String key = new DesEncrypter(pass).decrypt(s);
            if (fix1310) {
                key = DesEncrypter.fix1310(key);
            }
            return key;
        }
        catch (Exception e) {
            throw new DecryptionException("decrypt(" + s + "," + pass + ")", e);
        }
    }

    public static String decryptMe(String s) throws DecryptionException {
        return DesEncrypter.decryptMe(s, pass);
    }

    public static String decryptMe1310(String s) throws DecryptionException {
        return DesEncrypter.decryptMe(s, pass, true);
    }

    public static String encryptMe(String s) throws EncryptionException {
        return DesEncrypter.encryptMe(s, pass);
    }

    public static String encryptMe1310(String s) throws EncryptionException {
        return DesEncrypter.encryptMe(s, pass, true);
    }

    public static String decryptMeOr(String s, String ifFailed) {
        try {
            return DesEncrypter.decryptMe(s, pass);
        }
        catch (DecryptionException e) {
            return ifFailed;
        }
    }

    public static String decryptMeOr1310(String s, String ifFailed) {
        try {
            return DesEncrypter.decryptMe(s, pass, true);
        }
        catch (DecryptionException e) {
            return ifFailed;
        }
    }

    public static String encryptMeOr(String s, String ifFailed) {
        try {
            return DesEncrypter.encryptMe(s, pass);
        }
        catch (EncryptionException e) {
            return ifFailed;
        }
    }

    public static String encryptMeOr1310(String s, String ifFailed) {
        try {
            return DesEncrypter.encryptMe(s, pass, true);
        }
        catch (EncryptionException e) {
            return ifFailed;
        }
    }
}

