/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.date;

import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.IRelativeDate;
import ca.infodata.util1.date.LocalDateFormat;
import ca.infodata.util1.date.LocaleProvider;
import ca.infodata.util1.date.SystemClock;
import ca.infodata.util1.date.TimeSource;
import ca.infodata.util1.date.TimeZoneProvider;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public final class LocalDate
implements IPartialDate,
IRelativeDate {
    private static final ConcurrentHashMap<Integer, LocalDate> cache = new ConcurrentHashMap(200);
    private static final long serialVersionUID = 1L;
    private static final int MILLISECOND_PER_DAY = 86400000;
    private static final Calendar myCalendar = Calendar.getInstance(TimeZoneProvider.getTimeZone(), LocaleProvider.getLocale());
    private static final TimeZone utc = TimeZone.getTimeZone("GMT");
    private static TimeSource timeSource = new SystemClock();
    private static final Object LOCK = new Object();
    private final byte monthEnd;
    public final byte day;
    public final int dayFrom1970;
    public final byte dayOfWeek;
    public final byte month;
    public final int year;
    public final byte weekOfYear;

    public static synchronized void setTimeSource(TimeSource source) {
        if (source == null) {
            throw new IllegalArgumentException("source is null");
        }
        timeSource = source;
    }

    private static LocalDate getInstance(int dayFrom1970) {
        LocalDate putByOtherThreadJustNow;
        Integer Int_dayFrom1970 = dayFrom1970;
        LocalDate localDate = cache.get(Int_dayFrom1970);
        if (localDate == null && (putByOtherThreadJustNow = cache.putIfAbsent(Int_dayFrom1970, localDate = new LocalDate(dayFrom1970))) != null) {
            localDate = putByOtherThreadJustNow;
        }
        return localDate;
    }

    public static LocalDate from(IPartialDate partial) {
        Integer day;
        Integer month;
        if (partial == null) {
            return null;
        }
        if (partial instanceof LocalDate) {
            return (LocalDate)partial;
        }
        LocalDate date = LocalDate.today();
        Integer year = partial.getYear();
        if (year != null) {
            date = date.withYear(year);
        }
        if ((month = partial.getMonth()) != null) {
            if (month < 1) {
                month = 1;
            } else if (month > 12) {
                month = 12;
            }
            date = date.withMonth(month);
        }
        if ((day = partial.getDay()) != null) {
            if (day > date.getMonthEnd()) {
                day = date.getMonthEnd();
            } else if (day < 1) {
                day = 1;
            }
            date = date.withDay(day);
        }
        return date;
    }

    public static LocalDate from(int day, int month, int year) {
        return LocalDate.today().with(day, month, year);
    }

    public static LocalDate fromCalendar(Calendar c) {
        if (c == null) {
            return null;
        }
        Calendar copy = (Calendar)c.clone();
        copy.setTimeZone(utc);
        int cdate = copy.get(5);
        int cmonth = copy.get(2);
        int cyear = copy.get(1);
        copy.clear();
        copy.setTimeZone(utc);
        copy.set(5, cdate);
        copy.set(2, cmonth);
        copy.set(1, cyear);
        return LocalDate.fromTimeInMillisUTC(copy.getTimeInMillis());
    }

    public static LocalDate fromDayFrom1970(short dayFrom1970) {
        return LocalDate.fromDayFrom1970((int)dayFrom1970);
    }

    public static LocalDate fromDayFrom1970(int dayFrom1970) {
        return LocalDate.getInstance(dayFrom1970);
    }

    public static LocalDate nullSafefromDayFrom1970(Short dayFrom1970) {
        if (dayFrom1970 == null) {
            return null;
        }
        return LocalDate.nullSafefromDayFrom1970(dayFrom1970.intValue());
    }

    public static LocalDate nullSafefromDayFrom1970(Integer dayFrom1970) {
        if (dayFrom1970 == null) {
            return null;
        }
        return LocalDate.getInstance(dayFrom1970);
    }

    public static LocalDate fromTimeInMillisLOCAL(Long timeInMillis) {
        if (timeInMillis == null) {
            return null;
        }
        TimeZone tz = TimeZoneProvider.getTimeZoneNoCopy();
        int offset = tz.getOffset(timeInMillis);
        long adjustedTimeInMillis = timeInMillis + (long)offset;
        long modulo = adjustedTimeInMillis % 86400000L;
        int day = (int)(adjustedTimeInMillis / 86400000L);
        if (modulo != 0L && modulo < 0L) {
            --day;
        }
        return LocalDate.fromDayFrom1970(day);
    }

    public static LocalDate fromTimeInMillisUTC(Long timeInMillis) {
        if (timeInMillis == null) {
            return null;
        }
        long modulo = timeInMillis % 86400000L;
        int day = (int)(timeInMillis / 86400000L);
        if (modulo != 0L && modulo < 0L) {
            --day;
        }
        return LocalDate.fromDayFrom1970(day);
    }

    public static List<LocalDate> generateList(LocalDate start, LocalDate end) {
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>();
        for (int i = start.dayFrom1970; i <= end.dayFrom1970; ++i) {
            dates.add(LocalDate.getInstance(i));
        }
        return dates;
    }

    public static LocalDate getFirstDayOfWeek(LocalDate dateInTheWeek) {
        return LocalDate.fromDayFrom1970(dateInTheWeek.dayFrom1970 - dateInTheWeek.dayOfWeek + 1);
    }

    public static LocalDate getLastDayOfWeek(LocalDate dateInTheWeek) {
        return LocalDate.fromDayFrom1970(dateInTheWeek.dayFrom1970 + 7 - dateInTheWeek.dayOfWeek);
    }

    public static LocalDate today() {
        long currentTimeInMillis = timeSource.currentTimeInMillis();
        return LocalDate.fromTimeInMillisLOCAL(currentTimeInMillis);
    }

    private LocalDate(byte day, int dayFrom1970, byte dayOfWeek, byte month, int year, int maxDay, byte weekOfYear) {
        this.day = day;
        this.dayFrom1970 = dayFrom1970;
        this.dayOfWeek = dayOfWeek;
        this.month = month;
        this.year = year;
        this.monthEnd = (byte)maxDay;
        this.weekOfYear = weekOfYear;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalDate(int dayFrom1970) {
        Object object = LOCK;
        synchronized (object) {
            myCalendar.clear();
            myCalendar.setTimeZone(utc);
            myCalendar.add(5, dayFrom1970);
            this.day = (byte)myCalendar.get(5);
            this.dayFrom1970 = dayFrom1970;
            this.month = (byte)(myCalendar.get(2) + 1);
            this.year = myCalendar.get(1);
            this.dayOfWeek = (byte)myCalendar.get(7);
            this.monthEnd = (byte)myCalendar.getActualMaximum(5);
            this.weekOfYear = (byte)myCalendar.get(3);
        }
    }

    private Object readResolve() {
        LocalDate putByOtherThreadJustNow;
        Integer Int_dayFrom1970 = this.dayFrom1970;
        LocalDate localDate = cache.get(Int_dayFrom1970);
        if (localDate == null && (putByOtherThreadJustNow = cache.putIfAbsent(Int_dayFrom1970, localDate = new LocalDate(this.day, this.dayFrom1970, this.dayOfWeek, this.month, this.year, this.monthEnd, this.weekOfYear))) != null) {
            localDate = putByOtherThreadJustNow;
        }
        return localDate;
    }

    @Override
    public boolean after(IPartialDate date) {
        if (date instanceof LocalDate) {
            return this.compareTo(date) > 0;
        }
        if (date.isComplete()) {
            return this.after(LocalDate.from(date));
        }
        if (date.getMonth() != null && date.getYear() != null) {
            return this.year > date.getYear() || this.year == date.getYear() && this.month > date.getMonth();
        }
        if (date.getYear() != null) {
            return this.year > date.getYear();
        }
        return false;
    }

    public boolean afterOrEquals(LocalDate date) {
        return this.compareTo(date) >= 0;
    }

    @Override
    public boolean before(IPartialDate date) {
        if (date instanceof LocalDate) {
            return this.compareTo(date) < 0;
        }
        if (date.isComplete()) {
            return this.before(LocalDate.from(date));
        }
        if (date.getMonth() != null && date.getYear() != null) {
            return this.year < date.getYear() || this.year == date.getYear() && this.month < date.getMonth();
        }
        if (date.getYear() != null) {
            return this.year < date.getYear();
        }
        return false;
    }

    public boolean beforeOrEquals(LocalDate date) {
        return this.compareTo(date) <= 0;
    }

    @Override
    public int compareTo(IPartialDate o) {
        if (this == o) {
            return 0;
        }
        if (o instanceof LocalDate) {
            return this.fastCompare((LocalDate)o);
        }
        if (this.before(o)) {
            return -1;
        }
        if (this.after(o)) {
            return 1;
        }
        return 0;
    }

    private int fastCompare(LocalDate o) {
        if (this.dayFrom1970 == o.dayFrom1970) {
            return 0;
        }
        return this.dayFrom1970 - o.dayFrom1970;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalDate other = (LocalDate)obj;
        return this.dayFrom1970 == other.dayFrom1970;
    }

    public int getMonthEnd() {
        return this.monthEnd;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dayFrom1970;
        return result;
    }

    public Calendar toCalendar() {
        return this.toCalendar(TimeZoneProvider.getTimeZone());
    }

    public Calendar toCalendar(TimeZone timeZone) {
        if (timeZone == null) {
            throw new NullPointerException("timeZone");
        }
        Calendar calendar = Calendar.getInstance(timeZone, LocaleProvider.getLocale());
        calendar.clear();
        calendar.add(5, this.dayFrom1970);
        return calendar;
    }

    public String toString() {
        return this.year + "/" + this.month + "/" + this.day + " " + this.dayFrom1970 + "ed";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalDate plusDay(int day) {
        if (day == 0) {
            return this;
        }
        Object object = LOCK;
        synchronized (object) {
            myCalendar.clear();
            myCalendar.setTimeZone(utc);
            myCalendar.add(5, this.dayFrom1970 + day);
            return LocalDate.fromCalendar(myCalendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalDate plusYear(int year) {
        if (year == 0) {
            return this;
        }
        Object object = LOCK;
        synchronized (object) {
            myCalendar.clear();
            myCalendar.setTimeZone(utc);
            myCalendar.add(5, this.dayFrom1970);
            myCalendar.add(1, year);
            return LocalDate.fromCalendar(myCalendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalDate plusMonth(int month) {
        if (month == 0) {
            return this;
        }
        Object object = LOCK;
        synchronized (object) {
            myCalendar.clear();
            myCalendar.setTimeZone(utc);
            myCalendar.add(5, this.dayFrom1970);
            myCalendar.add(2, month);
            return LocalDate.fromCalendar(myCalendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalDate withDay(int day) {
        if (this.day == day) {
            return this;
        }
        if (day < 1 || day > this.getMonthEnd()) {
            throw new IllegalArgumentException("day must be between 1 and " + this.getMonthEnd());
        }
        Object object = LOCK;
        synchronized (object) {
            myCalendar.clear();
            myCalendar.setTimeZone(utc);
            myCalendar.add(5, this.dayFrom1970);
            myCalendar.add(5, day - this.day);
            return LocalDate.fromCalendar(myCalendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalDate withMonth(int month) {
        if (this.month == month) {
            return this;
        }
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("month must be between 1 and 12");
        }
        Object object = LOCK;
        synchronized (object) {
            myCalendar.clear();
            myCalendar.setTimeZone(utc);
            myCalendar.add(5, this.dayFrom1970);
            myCalendar.add(2, month - this.month);
            return LocalDate.fromCalendar(myCalendar);
        }
    }

    public LocalDate withDayEndOfMonth() {
        return this.withDay(this.getMonthEnd());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalDate withYear(int year) {
        if (this.year == year) {
            return this;
        }
        Object object = LOCK;
        synchronized (object) {
            myCalendar.clear();
            myCalendar.setTimeZone(utc);
            myCalendar.add(5, this.dayFrom1970);
            myCalendar.add(1, year - this.year);
            return LocalDate.fromCalendar(myCalendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalDate withWeekOfYear(int weekOfYear) {
        if (this.weekOfYear == weekOfYear) {
            return this;
        }
        if (weekOfYear < 1 || weekOfYear > 52) {
            throw new IllegalArgumentException("year must be between 1 and 52");
        }
        Object object = LOCK;
        synchronized (object) {
            myCalendar.clear();
            myCalendar.setTimeZone(utc);
            myCalendar.add(5, this.dayFrom1970);
            myCalendar.add(3, weekOfYear - this.weekOfYear);
            return LocalDate.fromCalendar(myCalendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalDate with(int day, int month, int year) {
        if (this.day == day && this.month == month && this.year == year) {
            return this;
        }
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("month must be between 1 and 12");
        }
        if (day < 1) {
            throw new IllegalArgumentException("day must be > 1");
        }
        Object object = LOCK;
        synchronized (object) {
            myCalendar.clear();
            myCalendar.setTimeZone(utc);
            myCalendar.add(5, this.dayFrom1970);
            myCalendar.add(2, month - this.month);
            myCalendar.add(1, year - this.year);
            int monthEnd = myCalendar.getActualMaximum(5);
            if (day > monthEnd) {
                throw new IllegalArgumentException("day must be < " + monthEnd);
            }
            myCalendar.set(5, day);
            return LocalDate.fromCalendar(myCalendar);
        }
    }

    public LocalDate withDayOfWeek(int newDayOfWeek) {
        if (newDayOfWeek < 1 || newDayOfWeek > 7) {
            throw new IllegalArgumentException("invalid dayOfWeek : " + newDayOfWeek);
        }
        if (this.dayOfWeek == newDayOfWeek) {
            return this;
        }
        int diff = newDayOfWeek - this.dayOfWeek;
        return LocalDate.fromDayFrom1970(this.dayFrom1970 + diff);
    }

    public long toTimeInMillisUTC() {
        return this.toCalendar().getTimeInMillis();
    }

    @Override
    public LocalDate clone() {
        return this;
    }

    public static void main(String[] args) {
        System.out.println(LocalDate.today());
    }

    @Override
    public String formatHyphen() {
        return LocalDateFormat.format(this, "yyyy-MM-dd");
    }

    @Override
    public String formatSlash() {
        return LocalDateFormat.format(this, "yyyy/MM/dd");
    }

    public String formatTextual() {
        return LocalDateFormat.format(this, "d MMMM yyyy");
    }

    @Override
    public Integer getDay() {
        return this.day;
    }

    @Override
    public Integer getMonth() {
        return this.month;
    }

    @Override
    public Integer getYear() {
        return this.year;
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public LocalDate toAbsoluteDate() {
        return this;
    }

    @Override
    public String store() {
        return "LocalDate;" + String.valueOf(this.dayFrom1970);
    }

    public static LocalDate restore(String s) {
        if (StringUtils.isNotBlank(s)) {
            try {
                String[] split = s.split(";");
                if (split.length == 2 && split[0].equals("LocalDate")) {
                    LocalDate.fromDayFrom1970(Integer.parseInt(split[1]));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public DateDiff getDiff(LocalDate date) {
        if (date == null) {
            throw new NullPointerException("date");
        }
        int diffYear = this.year - date.year;
        int diffMonth = this.month - date.month;
        if (this.day < date.day) {
            --diffMonth;
        }
        int diffDay = this.day - date.day;
        DateDiff diff = new DateDiff();
        diff.years = diffYear;
        diff.months = diffMonth;
        diff.days = diffDay;
        diff.totalMonths = diff.years * 12 + diff.months;
        diff.totalDays = this.dayFrom1970 - date.dayFrom1970;
        return diff;
    }

    public int getMonthDiff(LocalDate date) {
        if (date == null) {
            throw new NullPointerException("date");
        }
        int diffYear = this.year - date.year;
        int diffMonth = this.month - date.month;
        int diff = diffYear * 12 + diffMonth;
        if (this.day < date.day) {
            --diff;
        }
        return diff;
    }

    public int getYearDiff(LocalDate date) {
        if (date == null) {
            throw new NullPointerException("date");
        }
        int diff = this.year - date.year;
        if (this.before(date.withYear(this.year))) {
            --diff;
        }
        return diff;
    }

    public static class DateDiff {
        public int years;
        public int months;
        public int days;
        public int totalMonths;
        public int totalDays;

        public String toString() {
            return "DateDiff [" + this.years + "y, " + this.months + "m, " + this.days + "d]";
        }
    }
}

