/*
 * Decompiled with CFR 0.152.
 */
package org.ga.log.ro;

import java.text.MessageFormat;
import java.util.Date;
import org.ga.log.ro.DebugLevel;
import org.ga.log.ro.SimpleLog;

public class SimpleLogger {
    private static final char[] BYTE_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private String logText = "";
    private final SimpleLog log;
    private final Class<?> sourceClass;
    private final String className;
    private final String classNameShort;
    private Object instanceId;
    private final boolean isInstanceDebugger;
    private final boolean useLongName;
    private String configName;
    private DebugLevel debugLevel;
    private boolean tracing;

    public String getLogText() {
        return this.logText;
    }

    public void setLogTextEmpty() {
        this.logText = "";
    }

    public void addToLogText(String s) {
        this.logText = this.logText + s;
    }

    public SimpleLogger(Class<?> sourceClass) {
        this(SimpleLog.defaultInstance(), sourceClass);
    }

    public SimpleLogger(Class<?> sourceClass, Object instanceId) {
        this(SimpleLog.defaultInstance(), sourceClass, instanceId);
    }

    public SimpleLogger(Class<?> sourceClass, boolean useLongName) {
        this(SimpleLog.defaultInstance(), sourceClass, useLongName);
    }

    public SimpleLogger(Class<?> sourceClass, Object instanceId, boolean useLongName) {
        this(SimpleLog.defaultInstance(), sourceClass, instanceId, useLongName);
    }

    public SimpleLogger(SimpleLog log, Class<?> sourceClass) {
        this(log, sourceClass, false);
    }

    public SimpleLogger(SimpleLog log, Class<?> sourceClass, Object instanceId) {
        this(log, sourceClass, instanceId, false);
    }

    public SimpleLogger(SimpleLog log, Class<?> sourceClass, boolean useLongName) {
        this(log, sourceClass, null, useLongName);
    }

    public SimpleLogger(SimpleLog log, Class<?> sourceClass, Object instanceId, boolean useLongName) {
        this.log = log;
        this.sourceClass = sourceClass;
        this.instanceId = instanceId;
        this.isInstanceDebugger = instanceId != null;
        this.useLongName = useLongName;
        this.className = sourceClass.getName();
        this.classNameShort = this.createClassNameShort(sourceClass);
        this.generateConfigName();
        log.register(this);
    }

    private void generateConfigName() {
        String loggerName = this.sourceClass.getName();
        if (this.isInstanceDebugger) {
            loggerName = loggerName + '.' + this.instanceId;
        }
        if (loggerName.indexOf(36) != -1) {
            loggerName = loggerName.replace('$', '.');
        }
        this.configName = loggerName;
    }

    private String createClassNameShort(Class<?> sourceClass) {
        if (this.className.indexOf(46) == -1) {
            return this.className;
        }
        if (sourceClass.getPackage() != null && sourceClass.getPackage().getName() != null) {
            return this.className.substring(sourceClass.getPackage().getName().length() + 1);
        }
        String packageName = this.className;
        boolean packageNameIsAClass = true;
        int lastPeriod = packageName.indexOf(46);
        while (packageNameIsAClass && lastPeriod != -1) {
            packageName = packageName.substring(0, lastPeriod);
            try {
                Class.forName(packageName);
                packageNameIsAClass = true;
            }
            catch (Throwable e) {
                packageNameIsAClass = false;
            }
            lastPeriod = packageName.lastIndexOf(46);
        }
        if (packageName.length() == 0) {
            return this.className;
        }
        return this.className.substring(packageName.length() + 1);
    }

    public boolean isInstanceDebugger() {
        return this.isInstanceDebugger;
    }

    public Object getInstanceID() {
        return this.instanceId;
    }

    public void setInstanceID(Object instanceId) {
        if (!this.isInstanceDebugger) {
            throw new IllegalStateException("This is not an instance debugger.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("instanceId cannot be null.");
        }
        this.instanceId = instanceId;
        this.generateConfigName();
    }

    public String getConfigName() {
        return this.configName;
    }

    public DebugLevel getDebugLevel() {
        return this.debugLevel;
    }

    public boolean wouldLog(DebugLevel level) {
        return this.log.isOutputting() && this.getDebugLevel().shouldLog(level);
    }

    public void setDebugLevel(DebugLevel debugLevel) {
        if (debugLevel == null) {
            throw new IllegalArgumentException("debugLevel cannot be null.");
        }
        this.debugLevel = debugLevel;
    }

    public boolean isTracing() {
        return this.tracing;
    }

    public void setTracing(boolean tracing) {
        this.tracing = tracing;
    }

    public Class<?> getSourceClass() {
        return this.sourceClass;
    }

    private Object[] createData(DebugLevel level, int extraArguments) {
        Object[] result = new Object[5 + extraArguments];
        result[0] = new Date();
        result[1] = Thread.currentThread().getName();
        result[2] = this.useLongName ? this.className : this.classNameShort;
        result[3] = this.instanceId;
        result[4] = level;
        return result;
    }

    public void fatal(String message) {
        this.db(DebugLevel.L1_FATAL, message);
    }

    public void error(String message) {
        this.db(DebugLevel.L2_ERROR, message);
    }

    public void warn(String message) {
        this.db(DebugLevel.L3_WARN, message);
    }

    public void info(String message) {
        this.db(DebugLevel.L4_INFO, message);
    }

    public void debug(String message) {
        this.db(DebugLevel.L5_DEBUG, message);
    }

    public void verbose(String message) {
        this.db(DebugLevel.L6_VERBOSE, message);
    }

    public void ludicrous(String message) {
        this.db(DebugLevel.L7_LUDICROUS, message);
    }

    public void db(DebugLevel level, String message) {
        if (!this.log.isOutputting() || !this.debugLevel.shouldLog(level)) {
            return;
        }
        this.addToLogText(message + "\n");
        Object[] data = this.createData(level, 1);
        data[data.length - 1] = message;
        MessageFormat format = this.isInstanceDebugger ? this.log.getDebugInstanceFormat() : this.log.getDebugFormat();
        this.log.println(format.format(data));
    }

    public void dbo(DebugLevel level, String objectName, Object value) {
        if (this.wouldLog(level)) {
            if (value instanceof Object[]) {
                this.dbo(level, objectName, (Object[])value);
            } else if (value instanceof byte[]) {
                this.dbo(level, objectName, (byte[])value);
            } else if (value instanceof char[]) {
                this.dbo(level, objectName, (char[])value);
            } else {
                this.dboNoCheck(level, objectName, value);
            }
        }
    }

    private void dboNoCheck(DebugLevel level, String objectName, Object val) {
        Object[] data = this.createData(level, 2);
        data[data.length - 2] = objectName;
        data[data.length - 1] = val;
        MessageFormat format = this.isInstanceDebugger ? this.log.getDebugObjectInstanceFormat() : this.log.getDebugObjectFormat();
        this.log.println(format.format(data));
    }

    public void dbo(DebugLevel level, String objectName, Object[] val) {
        if (!this.log.isOutputting() || !this.debugLevel.shouldLog(level)) {
            return;
        }
        StringBuffer stringValue = new StringBuffer("[");
        for (int i = 0; i < val.length; ++i) {
            if (i == 0) {
                stringValue.append(val[i]);
                continue;
            }
            stringValue.append(", ").append(val[i]);
        }
        stringValue.append("]");
        this.dboNoCheck(level, objectName, stringValue);
    }

    public void dbo(DebugLevel level, String objectName, short val) {
        if (!this.log.isOutputting() || !this.debugLevel.shouldLog(level)) {
            return;
        }
        this.dboNoCheck(level, objectName, String.valueOf(val));
    }

    public void dbo(DebugLevel level, String objectName, int val) {
        if (!this.log.isOutputting() || !this.debugLevel.shouldLog(level)) {
            return;
        }
        this.dboNoCheck(level, objectName, String.valueOf(val));
    }

    public void dbo(DebugLevel level, String objectName, long val) {
        if (!this.log.isOutputting() || !this.debugLevel.shouldLog(level)) {
            return;
        }
        this.dboNoCheck(level, objectName, String.valueOf(val));
    }

    public void dbo(DebugLevel level, String objectName, boolean val) {
        if (!this.log.isOutputting() || !this.debugLevel.shouldLog(level)) {
            return;
        }
        this.dboNoCheck(level, objectName, String.valueOf(val));
    }

    public void dbo(DebugLevel level, String objectName, float val) {
        if (!this.log.isOutputting() || !this.debugLevel.shouldLog(level)) {
            return;
        }
        this.dboNoCheck(level, objectName, String.valueOf(val));
    }

    public void dbo(DebugLevel level, String objectName, double val) {
        if (!this.log.isOutputting() || !this.debugLevel.shouldLog(level)) {
            return;
        }
        this.dboNoCheck(level, objectName, String.valueOf(val));
    }

    public void dbo(DebugLevel level, String objectName, byte val) {
        if (!this.log.isOutputting() || !this.debugLevel.shouldLog(level)) {
            return;
        }
        this.dboNoCheck(level, objectName, SimpleLogger.toString(val));
    }

    public void dbo(DebugLevel level, String objectName, byte[] val) {
        if (!this.log.isOutputting() || !this.debugLevel.shouldLog(level)) {
            return;
        }
        this.dboNoCheck(level, objectName, SimpleLogger.toString(val));
    }

    public void dbo(DebugLevel level, String objectName, char val) {
        if (!this.log.isOutputting() || !this.debugLevel.shouldLog(level)) {
            return;
        }
        this.dboNoCheck(level, objectName, String.valueOf(val));
    }

    public void dbo(DebugLevel level, String objectName, char[] val) {
        if (!this.log.isOutputting() || !this.debugLevel.shouldLog(level)) {
            return;
        }
        this.dboNoCheck(level, objectName, String.valueOf(val));
    }

    public void infoObject(String objectName, Object val) {
        this.dbo(DebugLevel.L4_INFO, objectName, val);
    }

    public void infoObject(String objectName, boolean val) {
        this.dbo(DebugLevel.L4_INFO, objectName, val);
    }

    public void infoObject(String objectName, int val) {
        this.dbo(DebugLevel.L4_INFO, objectName, val);
    }

    public void debugObject(String objectName, Object val) {
        this.dbo(DebugLevel.L5_DEBUG, objectName, val);
    }

    public void debugObject(String objectName, boolean val) {
        this.dbo(DebugLevel.L5_DEBUG, objectName, val);
    }

    public void debugObject(String objectName, int val) {
        this.dbo(DebugLevel.L5_DEBUG, objectName, val);
    }

    public void verboseObject(String objectName, Object val) {
        this.dbo(DebugLevel.L6_VERBOSE, objectName, val);
    }

    public void verboseObject(String objectName, boolean val) {
        this.dbo(DebugLevel.L6_VERBOSE, objectName, val);
    }

    public void verboseObject(String objectName, int val) {
        this.dbo(DebugLevel.L6_VERBOSE, objectName, val);
    }

    public void ludicrousObject(String objectName, Object val) {
        this.dbo(DebugLevel.L7_LUDICROUS, objectName, val);
    }

    public void ludicrousObject(String objectName, boolean val) {
        this.dbo(DebugLevel.L7_LUDICROUS, objectName, val);
    }

    public void ludicrousObject(String objectName, int val) {
        this.dbo(DebugLevel.L7_LUDICROUS, objectName, val);
    }

    public void dbe(DebugLevel level, Throwable t) {
        if (!this.log.isOutputting() || !this.debugLevel.shouldLog(level)) {
            return;
        }
        Object[] data = this.createData(level, 1);
        data[data.length - 1] = t;
        MessageFormat format = this.isInstanceDebugger ? this.log.getDebugExceptionInstanceFormat() : this.log.getDebugExceptionFormat();
        this.log.println(format.format(data));
        this.addToLogText(format.format(data) + "\n");
    }

    public void fatalException(Throwable t) {
        this.dbe(DebugLevel.L1_FATAL, t);
    }

    public void errorException(Throwable t) {
        this.dbe(DebugLevel.L2_ERROR, t);
    }

    public void warnException(Throwable t) {
        this.dbe(DebugLevel.L3_WARN, t);
    }

    public void entry(String methodName) {
        if (!this.log.isOutputting() || !this.tracing) {
            return;
        }
        Object[] data = this.createData(DebugLevel.FAKE_TRACE, 1);
        data[data.length - 1] = methodName;
        MessageFormat format = this.isInstanceDebugger ? this.log.getEntryInstanceFormat() : this.log.getEntryFormat();
        this.log.println(format.format(data));
    }

    public void exit(String methodName) {
        if (!this.log.isOutputting() || !this.tracing) {
            return;
        }
        Object[] data = this.createData(DebugLevel.FAKE_TRACE, 1);
        data[data.length - 1] = methodName;
        MessageFormat format = this.isInstanceDebugger ? this.log.getExitInstanceFormat() : this.log.getExitFormat();
        this.log.println(format.format(data));
    }

    private static String toString(byte b) {
        return "0x" + SimpleLogger.byteString(b);
    }

    private static String toString(byte[] bytes) {
        if (bytes == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer(bytes.length * 4);
        buf.append("0x[");
        boolean first = true;
        for (byte element : bytes) {
            if (first) {
                first = false;
                if (!false) {
                    buf.append(SimpleLogger.byteString(element));
                    continue;
                }
            }
            buf.append(", ").append(SimpleLogger.byteString(element));
        }
        buf.append(']');
        return buf.toString();
    }

    private static String byteString(byte b) {
        return new String(new char[]{BYTE_CHARS[b >> 4 & 0xF], BYTE_CHARS[b & 0xF]});
    }
}

