/*
 * Decompiled with CFR 0.152.
 */
package org.ga.log.ro;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.ga.log.ro.DebugLevel;
import org.ga.log.ro.RolloverManager;
import org.ga.log.ro.SimpleLogger;

public final class SimpleLog {
    private static final String CONFIG_PROPERTY = "simplelog.configuration";
    private static final String DEV_DEBUG_PROPERTY = "simplelog.dev.debug";
    private static final String DEV_STACKTRACES_PROPERTY = "simplelog.dev.printStackTraces";
    private static final String FILE_CONFIG_PREFIX = "file:";
    private static final String CLASSPATH_CONFIG_PREFIX = "classpath:";
    private static final String DEFAULT_PROPERTIES_FILE_NAME = "log.properties";
    private static final String KEY_PREFIX = "log.";
    private static final String KEY_IMPORT = "log.import";
    private static final String KEY_FORMAT_PREFIX = "log.format.";
    private static final String KEY_FORMAT_INSTANCE_SUFFIX = ".instance";
    private static final String KEY_FORMAT_DB = "log.format.debug";
    private static final String KEY_FORMAT_DBO = "log.format.debugObject";
    private static final String KEY_FORMAT_DBE = "log.format.debugException";
    private static final String KEY_FORMAT_ENTRY = "log.format.entry";
    private static final String KEY_FORMAT_EXIT = "log.format.exit";
    private static final String KEY_RELOADING = "log.reloading";
    private static final String RELOADING_DEFAULT = "false";
    private static final String KEY_LOG_FILE = "log.logFile";
    private static final String KEY_INTERPRET_NAME = "log.logFile.interpretName";
    private static final boolean INTREPRET_NAME_DEFAULT = true;
    private static final String KEY_APPEND = "log.logFile.append";
    private static final boolean APPEND_DEFAULT = true;
    private static final String KEY_PIPE_TO_CONSOLE = "log.logFile.andConsole";
    private static final boolean PIPE_TO_CONSOLE_DEFAULT = false;
    private static final String KEY_DEFAULT_LEVEL = "log.defaultLevel";
    private static final String KEY_DEFAULT_TRACE = "log.defaultTrace";
    private static final String KEY_DATE_FORMAT = "log.dateFormat";
    private static final String DATE_FORMAT_DEFAULT = "yyyy/MM/dd HH:mm:ss";
    private static final String KEY_PRINT_STACK_TRACES = "log.printStackTraces";
    private static final String PRINT_STACK_TRACES_DEFAULT = "true";
    private static final String KEY_ROLLOVER_STRATEGY = "log.rollover";
    private static final int RELOAD_FILE_CHECK_PERIOD = 20000;
    private static final int RELOAD_URL_CHECK_PERIOD = 60000;
    private static final String TRACE_SUFFIX = "#trace";
    protected static final String LINE_SEP = System.getProperty("line.separator");
    private static final String ROLLOVER_WRITER_CLASS = "org.ga.log.ro.RolloverManager";
    private static final String DEFAULT_FORMAT_STRING_DB = "{0}|{5}";
    private static final String DEFAULT_FORMAT_STRING_DBO = "{0}|--|{5}|{6}";
    private static final String DEFAULT_FORMAT_STRING_DBE = "{0}|**|{5}";
    private static final String DEFAULT_FORMAT_STRING_ENTRY = "{0}|>>>|{1}|{2}|{5}";
    private static final String DEFAULT_FORMAT_STRING_EXIT = "{0}|<<<|{1}|{2}|{5}";
    private static final String DEFAULT_FORMAT_STRING_DB_INSTANCE = "{0}|   |{1}|{2}[{3}]|{5}";
    private static final String DEFAULT_FORMAT_STRING_DBO_INSTANCE = "{0}|---|{1}|{2}[{3}]|{5}|{6}";
    private static final String DEFAULT_FORMAT_STRING_DBE_INSTANCE = "{0}|***|{1}|{2}[{3}]|{5}";
    private static final String DEFAULT_FORMAT_STRING_ENTRY_INSTANCE = "{0}|>>>|{1}|{2}[{3}]|{5}";
    private static final String DEFAULT_FORMAT_STRING_EXIT_INSTANCE = "{0}|<<<|{1}|{2}[{3}]|{5}";
    private static final int DEFAULT_FORMAT_EXCEPTION_INDEX = 5;
    private static final int DEFAULT_FORMAT_EXCEPTION_INDEX_INSTANCE = 5;
    private static SimpleLog defaultInstance = null;
    private static final Object defaultInstanceLock = new Object();
    private static boolean devDebug = false;
    final URL configurationSource;
    final Properties properties;
    private PrintWriter out;
    private Writer currentWriter;
    private boolean outputSetProgramatically = false;
    private String logFile;
    private boolean printWriterGoesToConsole = true;
    private boolean pipingOutputToConsole = false;
    private DebugLevel defaultLevel = DebugLevel.L4_INFO;
    private boolean defaultTracing = false;
    private final List<SimpleLogger> loggers = new ArrayList<SimpleLogger>(32);
    final List<WeakReference<SimpleLogger>> instanceLoggerReferences = new ArrayList<WeakReference<SimpleLogger>>(16);
    ReferenceQueue<SimpleLogger> instanceLoggersReferenceQueue = null;
    final Object LOGGERS_LOCK = new Object();
    private DateFormat dateFormat;
    private MessageFormat dbFormat;
    private MessageFormat dboFormat;
    private MessageFormat dbeFormat;
    private MessageFormat entryFormat;
    private MessageFormat exitFormat;
    private MessageFormat dbFormat4Instance;
    private MessageFormat dboFormat4Instance;
    private MessageFormat dbeFormat4Instance;
    private MessageFormat entryFormat4Instance;
    private MessageFormat exitFormat4Instance;

    public SimpleLog(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties cannot be null.");
        }
        this.configurationSource = null;
        this.properties = properties;
        this.out = new PrintWriter(System.err, true);
        this.readSettingsFromProperties();
    }

    public SimpleLog(URL configurationSource) throws IOException {
        this.configurationSource = configurationSource;
        this.properties = new Properties();
        this.out = new PrintWriter(System.err, true);
        this.loadProperties();
        this.readSettingsFromProperties();
        String reloadingString = this.properties.getProperty(KEY_RELOADING, RELOADING_DEFAULT);
        boolean reloading = Boolean.valueOf(reloadingString);
        if (reloading) {
            int reloadPeriod;
            TimerTask reloadTask;
            SimpleLog.printDebugIfEnabled("Configuration reloading enabled");
            Timer timer = new Timer(true);
            if (configurationSource.getProtocol() != null && "file".equals(configurationSource.getProtocol().toLowerCase())) {
                reloadTask = new FileConfigurationReloader();
                reloadPeriod = 20000;
            } else {
                reloadTask = new UrlConfigurationReloader();
                reloadPeriod = 60000;
            }
            timer.schedule(reloadTask, reloadPeriod, (long)reloadPeriod);
        } else {
            SimpleLog.printDebugIfEnabled("Configuration reloading is disabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties() throws IOException {
        String[] filesToImport;
        if (this.properties == null) {
            return;
        }
        SimpleLog.printDebugIfEnabled("Loading properties");
        Properties newProperties = new Properties();
        try (InputStream inputStream = this.configurationSource.openStream();){
            newProperties.load(inputStream);
        }
        String importList = newProperties.getProperty(KEY_IMPORT);
        if (importList != null && (importList = importList.trim()).length() > 0 && (filesToImport = importList.split(",")) != null && filesToImport.length != 0) {
            String configurationContext = this.configurationSource.toExternalForm();
            int lastSlash = configurationContext.lastIndexOf(47);
            configurationContext = configurationContext.substring(0, ++lastSlash);
            for (String filenameToImport : filesToImport) {
                URL urlToImport = new URL(configurationContext + filenameToImport);
                try (InputStream importStream = null;){
                    SimpleLog.printDebugIfEnabled("Importing file", urlToImport);
                    importStream = urlToImport.openStream();
                    newProperties.load(importStream);
                }
            }
        }
        if (devDebug) {
            Set<Map.Entry<Object, Object>> properties = newProperties.entrySet();
            SimpleLog.printDebugIfEnabled("_____ Properties List START _____");
            Iterator<Map.Entry<Object, Object>> iterator = properties.iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> element;
                Map.Entry<Object, Object> entry = element = iterator.next();
                SimpleLog.printDebugIfEnabled((String)entry.getKey(), entry.getValue());
            }
            SimpleLog.printDebugIfEnabled("______ Properties List END ______");
        }
        this.properties.clear();
        this.properties.putAll((Map<?, ?>)newProperties);
    }

    private void readSettingsFromProperties() {
        String defaultTraceStr;
        String defaultLevelStr;
        block17: {
            if (!this.outputSetProgramatically) {
                try {
                    String rolloverStrategyString = this.properties.getProperty(KEY_ROLLOVER_STRATEGY);
                    boolean useRollover = rolloverStrategyString != null && rolloverStrategyString.trim().length() != 0;
                    Writer newWriter = useRollover ? this.configureRolloverWriter() : this.configureFileWriter();
                    if (newWriter == this.currentWriter) break block17;
                    this.out = new PrintWriter(newWriter, true);
                    if (this.currentWriter != null) {
                        try {
                            this.currentWriter.close();
                        }
                        catch (IOException e) {
                            SimpleLog.printError("Error while closing log file", e, true);
                        }
                    }
                    this.currentWriter = newWriter;
                }
                catch (IOException e) {
                    SimpleLog.printError("Error opening log file for writing", e, true);
                }
            }
        }
        String pipeOutputToConsoleString = this.properties.getProperty(KEY_PIPE_TO_CONSOLE);
        this.pipingOutputToConsole = false;
        if (pipeOutputToConsoleString != null) {
            this.pipingOutputToConsole = pipeOutputToConsoleString.trim().equalsIgnoreCase(PRINT_STACK_TRACES_DEFAULT);
        }
        if ((defaultLevelStr = this.properties.getProperty(KEY_DEFAULT_LEVEL)) != null) {
            defaultLevelStr = defaultLevelStr.trim();
            try {
                int level = Integer.parseInt(defaultLevelStr);
                this.defaultLevel = DebugLevel.fromInt(level);
            }
            catch (NumberFormatException e1) {
                try {
                    this.defaultLevel = DebugLevel.fromName(defaultLevelStr);
                }
                catch (IllegalArgumentException e2) {
                    SimpleLog.printError("Error parsing debug level for 'log.defaultLevel'", e1, true);
                    SimpleLog.printError("Error parsing debug level for 'log.defaultLevel'", e2, false);
                }
            }
        }
        if ((defaultTraceStr = this.properties.getProperty(KEY_DEFAULT_TRACE)) != null) {
            this.defaultTracing = Boolean.valueOf(defaultTraceStr);
        }
        String dateFormatString = this.properties.getProperty(KEY_DATE_FORMAT, DATE_FORMAT_DEFAULT);
        try {
            this.dateFormat = new SimpleDateFormat(dateFormatString);
        }
        catch (IllegalArgumentException e) {
            SimpleLog.printError("Error parsing date format", e, false);
        }
        this.dbFormat = this.readFormat(KEY_FORMAT_DB, DEFAULT_FORMAT_STRING_DB);
        this.dboFormat = this.readFormat(KEY_FORMAT_DBO, DEFAULT_FORMAT_STRING_DBO);
        this.dbeFormat = this.readFormat(KEY_FORMAT_DBE, DEFAULT_FORMAT_STRING_DBE);
        this.entryFormat = this.readFormat(KEY_FORMAT_ENTRY, DEFAULT_FORMAT_STRING_ENTRY);
        this.exitFormat = this.readFormat(KEY_FORMAT_EXIT, DEFAULT_FORMAT_STRING_EXIT);
        this.dbFormat4Instance = this.readFormat("log.format.debug.instance", DEFAULT_FORMAT_STRING_DB_INSTANCE);
        this.dboFormat4Instance = this.readFormat("log.format.debugObject.instance", DEFAULT_FORMAT_STRING_DBO_INSTANCE);
        this.dbeFormat4Instance = this.readFormat("log.format.debugException.instance", DEFAULT_FORMAT_STRING_DBE_INSTANCE);
        this.entryFormat4Instance = this.readFormat("log.format.entry.instance", DEFAULT_FORMAT_STRING_ENTRY_INSTANCE);
        this.exitFormat4Instance = this.readFormat("log.format.exit.instance", DEFAULT_FORMAT_STRING_EXIT_INSTANCE);
        this.updateDateFormats();
        String printStackTracesStr = this.properties.getProperty(KEY_PRINT_STACK_TRACES, PRINT_STACK_TRACES_DEFAULT);
        boolean printStackTraces = Boolean.valueOf(printStackTracesStr);
        if (printStackTraces) {
            ExceptionFormat exceptionFormat = new ExceptionFormat();
            this.dbeFormat.setFormatByArgumentIndex(5, exceptionFormat);
            this.dbeFormat4Instance.setFormatByArgumentIndex(5, exceptionFormat);
        }
        Enumeration<?> propertyNames = this.properties.propertyNames();
        Properties newProperties = new Properties();
        while (propertyNames.hasMoreElements()) {
            String key = (String)propertyNames.nextElement();
            if (key.indexOf(36) == -1) continue;
            newProperties.put(key.replace('$', '.'), this.properties.getProperty(key));
        }
        this.properties.putAll((Map<?, ?>)newProperties);
    }

    private Writer configureFileWriter() throws IOException {
        Writer writer;
        boolean rolloverWasInUse;
        boolean nameContainsBraces;
        String newLogFile = this.properties.getProperty(KEY_LOG_FILE);
        boolean interpretName = true;
        String interpretNameStr = this.properties.getProperty(KEY_INTERPRET_NAME);
        if (interpretNameStr != null) {
            interpretName = !interpretNameStr.trim().equalsIgnoreCase(RELOADING_DEFAULT);
        }
        boolean newLogFileNotNull = newLogFile != null;
        boolean bl = nameContainsBraces = newLogFileNotNull && newLogFile.indexOf(123) != -1;
        if (newLogFileNotNull && nameContainsBraces && interpretName) {
            try {
                MessageFormat logFileNameFormat = new MessageFormat(newLogFile);
                newLogFile = logFileNameFormat.format(new Object[]{new Date()});
            }
            catch (Exception e) {
                SimpleLog.printError("Error generating log file name", e, true);
                newLogFile = null;
            }
        }
        boolean logFileChanged = this.logFile == null != (newLogFile == null);
        logFileChanged |= this.logFile != null && newLogFileNotNull && !newLogFile.equals(this.logFile);
        boolean bl2 = rolloverWasInUse = this.currentWriter != null && this.currentWriter.getClass().getName().equals(ROLLOVER_WRITER_CLASS);
        if (logFileChanged |= rolloverWasInUse) {
            if (newLogFile == null) {
                writer = new OutputStreamWriter(System.err);
                this.printWriterGoesToConsole = true;
            } else {
                File file = new File(newLogFile).getAbsoluteFile();
                if (file.isDirectory()) {
                    throw new IOException("The specified log file name already exists as a directory.");
                }
                File parentFile = file.getParentFile();
                if (parentFile != null) {
                    parentFile.mkdirs();
                }
                boolean append = true;
                String appendStr = this.properties.getProperty(KEY_APPEND);
                if (appendStr != null) {
                    append = !appendStr.trim().equalsIgnoreCase(RELOADING_DEFAULT);
                }
                writer = new FileWriter(file, append);
                this.printWriterGoesToConsole = false;
            }
            this.logFile = newLogFile;
        } else {
            writer = this.currentWriter;
        }
        return writer;
    }

    private Writer configureRolloverWriter() throws IOException {
        Writer writer;
        try {
            Class.forName(ROLLOVER_WRITER_CLASS);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("The RolloverManager class is not available: " + e);
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (this.currentWriter != null && this.currentWriter.getClass().getName().equals(ROLLOVER_WRITER_CLASS)) {
            ((RolloverManager)this.currentWriter).configure(this.properties);
            writer = this.currentWriter;
        } else {
            writer = RolloverManager.createRolloverManager(this.properties, ErrorReporter.create());
        }
        this.printWriterGoesToConsole = false;
        return writer;
    }

    public void reloadProperties() {
        try {
            if (this.configurationSource != null) {
                this.loadProperties();
            }
            this.readSettingsFromProperties();
            this.reconfigureAllLoggers();
        }
        catch (Exception e) {
            SimpleLog.printError("Falied to reload properties", e, true);
        }
    }

    private MessageFormat readFormat(String key, String defaultPattern) {
        MessageFormat format;
        String formatString = this.properties.getProperty(key, defaultPattern);
        try {
            format = new MessageFormat(formatString);
        }
        catch (Exception e) {
            SimpleLog.printError("Error reading format string from " + key, e, false);
            format = new MessageFormat(defaultPattern);
        }
        return format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleLog defaultInstance() {
        Object object = defaultInstanceLock;
        synchronized (object) {
            if (defaultInstance == null) {
                SimpleLog.printDebugIfEnabled("Creating default SimpleLog instance");
                URL propertiesUrl = SimpleLog.getPropertiesUrl();
                if (propertiesUrl != null) {
                    SimpleLog.printDebugIfEnabled("Attempting to configure using properties at", propertiesUrl);
                    try {
                        defaultInstance = new SimpleLog(propertiesUrl);
                    }
                    catch (Exception e) {
                        SimpleLog.printError("Error while attempting to load default properties", e, true);
                    }
                }
                if (defaultInstance == null) {
                    SimpleLog.printDebugIfEnabled("");
                    SimpleLog.printDebugIfEnabled("FAILED to load any SimpleLog configuration.");
                    SimpleLog.printDebugIfEnabled("");
                    SimpleLog.printDebugIfEnabled("NO LOG OUTPUT WILL BE GENERATED.");
                    defaultInstance = new SimpleLog(new Properties());
                    defaultInstance.setWriter(null);
                }
            }
        }
        return defaultInstance;
    }

    public static void setDefaultInstanceNull() {
        defaultInstance = null;
    }

    private static URL getPropertiesUrl() {
        String propertiesDefinition = null;
        try {
            propertiesDefinition = System.getProperty(CONFIG_PROPERTY);
        }
        catch (SecurityException e) {
            SimpleLog.printError("SecurityException while trying to read system property", e, true);
        }
        SimpleLog.printDebugIfEnabled("System property 'simplelog.configuration'", propertiesDefinition);
        URL propertiesUrl = null;
        if (propertiesDefinition != null) {
            String propertiesLocation;
            if (propertiesDefinition.startsWith(FILE_CONFIG_PREFIX)) {
                propertiesLocation = propertiesDefinition.substring(FILE_CONFIG_PREFIX.length());
                File propertiesFile = new File(propertiesLocation);
                if (propertiesFile.exists()) {
                    try {
                        propertiesUrl = propertiesFile.toURL();
                    }
                    catch (MalformedURLException e) {
                        SimpleLog.printError("Error creating URL from filename '" + propertiesLocation + "'", e, false);
                    }
                } else {
                    SimpleLog.printError("Properties file not found at '" + propertiesLocation + "'");
                }
            } else if (propertiesDefinition.startsWith(CLASSPATH_CONFIG_PREFIX)) {
                propertiesLocation = propertiesDefinition.substring(CLASSPATH_CONFIG_PREFIX.length());
                propertiesUrl = SimpleLog.class.getClassLoader().getResource(propertiesLocation);
                if (propertiesUrl == null) {
                    SimpleLog.printError("Properties not found in classpath at '" + propertiesLocation + "'");
                }
            } else {
                SimpleLog.printError("simplelog.configuration property must begin with 'file:' or 'classpath:' ('" + propertiesDefinition + "')");
            }
        }
        if (propertiesUrl == null) {
            SimpleLog.printDebugIfEnabled("Attempting to load default properties (simplelog.properties) from classpath");
            propertiesUrl = SimpleLog.class.getClassLoader().getResource(DEFAULT_PROPERTIES_FILE_NAME);
        }
        if (propertiesUrl != null && propertiesUrl.toExternalForm().indexOf(32) != -1) {
            try {
                propertiesUrl = new URL(propertiesUrl.toString().replaceAll(" ", "%20"));
            }
            catch (MalformedURLException e) {
                SimpleLog.printError("Failed to encode spaces in properties URL", e, true);
            }
        }
        return propertiesUrl;
    }

    void println(String s) {
        if (this.out != null) {
            this.out.println(s);
            if (!this.printWriterGoesToConsole && this.pipingOutputToConsole) {
                System.err.println(s);
            }
        }
    }

    void configure(SimpleLogger logger) {
        logger.setDebugLevel(this.getDebugLevel(logger));
        logger.setTracing(this.getTracingFlag(logger));
    }

    private DebugLevel getDebugLevel(SimpleLogger logger) {
        if (this.properties == null) {
            return this.defaultLevel;
        }
        String loggerConfigName = logger.getConfigName();
        int dotIndex = loggerConfigName.length();
        DebugLevel debugLevel = null;
        do {
            String value;
            if ((value = this.properties.getProperty(loggerConfigName = loggerConfigName.substring(0, dotIndex))) != null) {
                value = value.trim();
                try {
                    int level = Integer.parseInt(value);
                    debugLevel = DebugLevel.fromInt(level);
                }
                catch (NumberFormatException e1) {
                    try {
                        debugLevel = DebugLevel.fromName(value);
                    }
                    catch (IllegalArgumentException e2) {
                        SimpleLog.printError("Error parsing debug level for '" + loggerConfigName + "'", e1, true);
                        SimpleLog.printError("Error parsing debug level for '" + loggerConfigName + "'", e2, false);
                    }
                }
            }
            dotIndex = loggerConfigName.lastIndexOf(46);
        } while (debugLevel == null && dotIndex != -1);
        if (debugLevel == null) {
            debugLevel = this.defaultLevel;
        }
        return debugLevel;
    }

    private boolean getTracingFlag(SimpleLogger logger) {
        if (this.properties == null) {
            return this.defaultTracing;
        }
        String loggerConfigName = logger.getConfigName();
        int dotIndex = loggerConfigName.length();
        boolean trace = this.defaultTracing;
        do {
            String value;
            if ((value = this.properties.getProperty((loggerConfigName = loggerConfigName.substring(0, dotIndex)) + TRACE_SUFFIX)) == null) continue;
            trace = Boolean.valueOf(value);
            break;
        } while ((dotIndex = loggerConfigName.lastIndexOf(46)) != -1);
        return trace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(SimpleLogger logger) {
        Object object = this.LOGGERS_LOCK;
        synchronized (object) {
            if (!logger.isInstanceDebugger()) {
                this.loggers.add(logger);
            } else {
                if (this.instanceLoggersReferenceQueue == null) {
                    this.createInstanceLoggersReferenceQueue();
                }
                WeakReference<SimpleLogger> e = new WeakReference<SimpleLogger>(logger, this.instanceLoggersReferenceQueue);
                this.instanceLoggerReferences.add(e);
            }
        }
        this.configure(logger);
    }

    private void createInstanceLoggersReferenceQueue() {
        this.instanceLoggersReferenceQueue = new ReferenceQueue();
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Thread.yield();
                            Reference<SimpleLogger> reference = SimpleLog.this.instanceLoggersReferenceQueue.remove();
                            Object object = SimpleLog.this.LOGGERS_LOCK;
                            synchronized (object) {
                                SimpleLog.this.instanceLoggerReferences.remove(reference);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                    break;
                }
            }
        }, "SimpleLog Instance Logger Cleaner");
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconfigureAllLoggers() {
        Object object = this.LOGGERS_LOCK;
        synchronized (object) {
            SimpleLog.printDebugIfEnabled("Re-configuring all loggers");
            for (SimpleLogger simpleLogger : this.loggers) {
                this.configure(simpleLogger);
            }
            for (Object object2 : this.instanceLoggerReferences) {
                Reference loggerReference = (Reference)object2;
                SimpleLogger logger = (SimpleLogger)loggerReference.get();
                if (logger == null) continue;
                this.configure(logger);
            }
        }
    }

    private static void printDebugIfEnabled(String message) {
        if (devDebug) {
            System.err.println("SimpleLog [dev.debug]: " + message);
        }
    }

    private static void printDebugIfEnabled(String message, Object value) {
        if (devDebug) {
            System.err.println("SimpleLog [dev.debug]: " + message + ": " + value);
        }
    }

    private static void printError(String description) {
        SimpleLog.printError(description, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void printError(String description, Throwable error, boolean printExceptionType) {
        boolean printStackTraces = false;
        try {
            String printStackTracesStr = System.getProperty(DEV_STACKTRACES_PROPERTY);
            printStackTraces = printStackTracesStr != null && printStackTracesStr.trim().equalsIgnoreCase(PRINT_STACK_TRACES_DEFAULT);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        PrintStream printStream = System.err;
        synchronized (printStream) {
            System.err.println();
            System.err.print("   Log ERROR: ");
            System.err.print(description);
            if (error != null) {
                System.err.print(": ");
                if (printExceptionType) {
                    System.err.println(error);
                } else {
                    System.err.println(error.getMessage());
                }
                if (printStackTraces) {
                    try {
                        System.err.println();
                        error.printStackTrace(System.err);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
                System.err.println();
            } else {
                System.err.println();
                System.err.println();
            }
        }
    }

    public DebugLevel getDefaultLevel() {
        return this.defaultLevel;
    }

    public void setDefaultLevel(DebugLevel defaultLevel) {
        if (defaultLevel == null) {
            throw new IllegalArgumentException("defaultLevel cannot be null.");
        }
        this.defaultLevel = defaultLevel;
        this.reconfigureAllLoggers();
    }

    public boolean isDefaultTracing() {
        return this.defaultTracing;
    }

    public void setDefaultTracing(boolean defaultTracing) {
        this.defaultTracing = defaultTracing;
        this.reconfigureAllLoggers();
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat newDateFormat) {
        this.dateFormat = newDateFormat == null ? new SimpleDateFormat(DATE_FORMAT_DEFAULT) : newDateFormat;
        this.updateDateFormats();
    }

    public PrintWriter getWriter() {
        return this.out;
    }

    public void setWriter(PrintWriter out) {
        this.out = out;
        this.outputSetProgramatically = true;
    }

    boolean isOutputting() {
        return this.out != null;
    }

    private void updateDateFormats() {
        this.dbFormat.setFormatByArgumentIndex(0, this.dateFormat);
        this.dboFormat.setFormatByArgumentIndex(0, this.dateFormat);
        this.dbeFormat.setFormatByArgumentIndex(0, this.dateFormat);
        this.entryFormat.setFormatByArgumentIndex(0, this.dateFormat);
        this.exitFormat.setFormatByArgumentIndex(0, this.dateFormat);
        this.dbFormat4Instance.setFormatByArgumentIndex(0, this.dateFormat);
        this.dboFormat4Instance.setFormatByArgumentIndex(0, this.dateFormat);
        this.dbeFormat4Instance.setFormatByArgumentIndex(0, this.dateFormat);
        this.entryFormat4Instance.setFormatByArgumentIndex(0, this.dateFormat);
        this.exitFormat4Instance.setFormatByArgumentIndex(0, this.dateFormat);
    }

    MessageFormat getDebugFormat() {
        return this.dbFormat;
    }

    MessageFormat getDebugInstanceFormat() {
        return this.dbFormat4Instance;
    }

    MessageFormat getDebugObjectFormat() {
        return this.dboFormat;
    }

    MessageFormat getDebugObjectInstanceFormat() {
        return this.dboFormat4Instance;
    }

    MessageFormat getDebugExceptionFormat() {
        return this.dbeFormat;
    }

    MessageFormat getDebugExceptionInstanceFormat() {
        return this.dbeFormat4Instance;
    }

    MessageFormat getEntryFormat() {
        return this.entryFormat;
    }

    MessageFormat getEntryInstanceFormat() {
        return this.entryFormat4Instance;
    }

    MessageFormat getExitFormat() {
        return this.exitFormat;
    }

    MessageFormat getExitInstanceFormat() {
        return this.exitFormat4Instance;
    }

    public boolean isPipingOutputToConsole() {
        return this.pipingOutputToConsole;
    }

    public void setPipingOutputToConsole(boolean pipeOutputToConsole) {
        this.pipingOutputToConsole = pipeOutputToConsole;
    }

    static {
        try {
            String devDebugString = System.getProperty(DEV_DEBUG_PROPERTY);
            if (devDebugString != null && PRINT_STACK_TRACES_DEFAULT.equalsIgnoreCase(devDebugString.trim())) {
                devDebug = true;
                SimpleLog.printDebugIfEnabled("Simple Log DEV Debugging enabled (-Dsimplelog.dev.debug)");
            }
        }
        catch (Exception e) {
            SimpleLog.printError("Exception while reading system property 'simplelog.dev.debug'", e, true);
        }
    }

    private static class ErrorReporter
    implements RolloverManager.ErrorReporter {
        private ErrorReporter() {
        }

        @Override
        public void error(String description, Throwable t, boolean printExceptionType) {
            SimpleLog.printError(description, t, printExceptionType);
        }

        static RolloverManager.ErrorReporter create() {
            return new ErrorReporter();
        }
    }

    private final class UrlConfigurationReloader
    extends TimerTask {
        private long previousLastModified;

        public UrlConfigurationReloader() {
            try {
                URLConnection connection = SimpleLog.this.configurationSource.openConnection();
                this.previousLastModified = connection.getLastModified();
            }
            catch (IOException e) {
                this.previousLastModified = 0L;
            }
        }

        @Override
        public void run() {
            long lastModified;
            try {
                URLConnection connection = SimpleLog.this.configurationSource.openConnection();
                lastModified = connection.getLastModified();
            }
            catch (IOException e) {
                lastModified = 0L;
            }
            if (lastModified == 0L) {
                Properties currentProperties = new Properties();
                try {
                    InputStream inputStream = SimpleLog.this.configurationSource.openStream();
                    currentProperties.load(inputStream);
                    if (!currentProperties.equals(SimpleLog.this.properties)) {
                        SimpleLog.this.reloadProperties();
                    }
                }
                catch (IOException iOException) {}
            } else if (this.previousLastModified != lastModified) {
                SimpleLog.this.reloadProperties();
                this.previousLastModified = lastModified;
            }
        }
    }

    private final class FileConfigurationReloader
    extends TimerTask {
        private final File configurationFile;
        private long previousLastModified;

        public FileConfigurationReloader() {
            try {
                URI uri = new URI(SimpleLog.this.configurationSource.toExternalForm());
                this.configurationFile = new File(uri);
                this.previousLastModified = this.configurationFile.lastModified();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Failed to create URI from URL due to " + e);
            }
        }

        @Override
        public void run() {
            long lastModified = this.configurationFile.lastModified();
            if (this.previousLastModified != lastModified) {
                SimpleLog.this.reloadProperties();
                this.previousLastModified = lastModified;
            }
        }
    }

    protected static final class ExceptionFormat
    extends Format {
        protected ExceptionFormat() {
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer buf, FieldPosition pos) {
            if (!(obj instanceof Throwable)) {
                throw new IllegalArgumentException(this.getClass().getName() + " only formats Throwables.");
            }
            Throwable t = (Throwable)obj;
            buf.append(t);
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            buf.append(LINE_SEP).append(sw.toString());
            return buf;
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            throw new UnsupportedOperationException();
        }
    }
}

