/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v281.datatype.CWE;
import ca.uhn.hl7v2.model.v281.datatype.DTM;
import ca.uhn.hl7v2.model.v281.datatype.HD;
import ca.uhn.hl7v2.model.v281.datatype.ID;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class MFI
extends AbstractSegment {
    public MFI(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Master File Identifier");
            this.add(HD.class, false, 0, 0, new Object[]{this.getMessage()}, "Master File Application Identifier");
            this.add(ID.class, true, 1, 0, new Object[]{this.getMessage(), new Integer(178)}, "File-Level Event Code");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Entered Date/Time");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Effective Date/Time");
            this.add(ID.class, true, 1, 0, new Object[]{this.getMessage(), new Integer(179)}, "Response Level Code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFI - this is probably a bug in the source code generator.", e);
        }
    }

    public CWE getMasterFileIdentifier() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getMfi1_MasterFileIdentifier() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public HD[] getMasterFileApplicationIdentifier() {
        HD[] retVal = (HD[])this.getTypedField(2, new HD[0]);
        return retVal;
    }

    public HD[] getMfi2_MasterFileApplicationIdentifier() {
        HD[] retVal = (HD[])this.getTypedField(2, new HD[0]);
        return retVal;
    }

    public int getMasterFileApplicationIdentifierReps() {
        return this.getReps(2);
    }

    public HD getMasterFileApplicationIdentifier(int rep) {
        HD retVal = (HD)this.getTypedField(2, rep);
        return retVal;
    }

    public HD getMfi2_MasterFileApplicationIdentifier(int rep) {
        HD retVal = (HD)this.getTypedField(2, rep);
        return retVal;
    }

    public int getMfi2_MasterFileApplicationIdentifierReps() {
        return this.getReps(2);
    }

    public HD insertMasterFileApplicationIdentifier(int rep) throws HL7Exception {
        return (HD)super.insertRepetition(2, rep);
    }

    public HD insertMfi2_MasterFileApplicationIdentifier(int rep) throws HL7Exception {
        return (HD)super.insertRepetition(2, rep);
    }

    public HD removeMasterFileApplicationIdentifier(int rep) throws HL7Exception {
        return (HD)super.removeRepetition(2, rep);
    }

    public HD removeMfi2_MasterFileApplicationIdentifier(int rep) throws HL7Exception {
        return (HD)super.removeRepetition(2, rep);
    }

    public ID getFileLevelEventCode() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public ID getMfi3_FileLevelEventCode() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public DTM getEnteredDateTime() {
        DTM retVal = (DTM)this.getTypedField(4, 0);
        return retVal;
    }

    public DTM getMfi4_EnteredDateTime() {
        DTM retVal = (DTM)this.getTypedField(4, 0);
        return retVal;
    }

    public DTM getEffectiveDateTime() {
        DTM retVal = (DTM)this.getTypedField(5, 0);
        return retVal;
    }

    public DTM getMfi5_EffectiveDateTime() {
        DTM retVal = (DTM)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getResponseLevelCode() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getMfi6_ResponseLevelCode() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new HD(this.getMessage());
            }
            case 2: {
                return new ID(this.getMessage(), new Integer(178));
            }
            case 3: {
                return new DTM(this.getMessage());
            }
            case 4: {
                return new DTM(this.getMessage());
            }
            case 5: {
                return new ID(this.getMessage(), new Integer(179));
            }
        }
        return null;
    }
}

