/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v281.datatype.CNE;
import ca.uhn.hl7v2.model.v281.datatype.DTM;
import ca.uhn.hl7v2.model.v281.datatype.EI;
import ca.uhn.hl7v2.model.v281.datatype.ID;
import ca.uhn.hl7v2.model.v281.datatype.NM;
import ca.uhn.hl7v2.model.v281.datatype.ST;
import ca.uhn.hl7v2.model.v281.datatype.XCN;
import ca.uhn.hl7v2.model.v281.datatype.XON;
import ca.uhn.hl7v2.model.v281.datatype.XPN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class DON
extends AbstractSegment {
    public DON(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, false, 1, 0, new Object[]{this.getMessage()}, "Donation Identification Number - DIN");
            this.add(CNE.class, false, 1, 0, new Object[]{this.getMessage()}, "Donation Type");
            this.add(DTM.class, true, 1, 0, new Object[]{this.getMessage()}, "Phlebotomy Start Date/Time");
            this.add(DTM.class, true, 1, 0, new Object[]{this.getMessage()}, "Phlebotomy End Date/Time");
            this.add(NM.class, true, 1, 0, new Object[]{this.getMessage()}, "Donation Duration");
            this.add(CNE.class, true, 1, 0, new Object[]{this.getMessage()}, "Donation Duration Units");
            this.add(CNE.class, true, 0, 0, new Object[]{this.getMessage()}, "Intended Procedure Type");
            this.add(CNE.class, true, 0, 0, new Object[]{this.getMessage()}, "Actual Procedure Type");
            this.add(ID.class, true, 1, 0, new Object[]{this.getMessage(), new Integer(136)}, "Donor Eligibility Flag");
            this.add(CNE.class, true, 0, 0, new Object[]{this.getMessage()}, "Donor Eligibility Procedure Type");
            this.add(DTM.class, true, 1, 0, new Object[]{this.getMessage()}, "Donor Eligibility Date");
            this.add(CNE.class, true, 1, 0, new Object[]{this.getMessage()}, "Process Interruption");
            this.add(CNE.class, true, 1, 0, new Object[]{this.getMessage()}, "Process Interruption Reason");
            this.add(CNE.class, true, 0, 0, new Object[]{this.getMessage()}, "Phlebotomy Issue");
            this.add(ID.class, true, 1, 0, new Object[]{this.getMessage(), new Integer(136)}, "Intended Recipient Blood Relative");
            this.add(XPN.class, true, 1, 0, new Object[]{this.getMessage()}, "Intended Recipient Name");
            this.add(DTM.class, true, 1, 0, new Object[]{this.getMessage()}, "Intended Recipient DOB");
            this.add(XON.class, true, 1, 0, new Object[]{this.getMessage()}, "Intended Recipient Facility");
            this.add(DTM.class, true, 1, 0, new Object[]{this.getMessage()}, "Intended Recipient Procedure Date");
            this.add(XPN.class, true, 1, 0, new Object[]{this.getMessage()}, "Intended Recipient Ordering Provider");
            this.add(CNE.class, true, 1, 0, new Object[]{this.getMessage()}, "Phlebotomy Status");
            this.add(CNE.class, true, 1, 0, new Object[]{this.getMessage()}, "Arm Stick");
            this.add(XPN.class, true, 1, 0, new Object[]{this.getMessage()}, "Bleed Start Phlebotomist");
            this.add(XPN.class, true, 1, 0, new Object[]{this.getMessage()}, "Bleed End Phlebotomist");
            this.add(ST.class, true, 1, 0, new Object[]{this.getMessage()}, "Aphaeresis Type Machine");
            this.add(ST.class, true, 1, 0, new Object[]{this.getMessage()}, "Aphaeresis Machine Serial Number");
            this.add(ID.class, true, 1, 0, new Object[]{this.getMessage(), new Integer(136)}, "Donor Reaction");
            this.add(XPN.class, true, 1, 0, new Object[]{this.getMessage()}, "Final Review Staff ID");
            this.add(DTM.class, true, 1, 0, new Object[]{this.getMessage()}, "Final Review Date/Time");
            this.add(NM.class, true, 1, 0, new Object[]{this.getMessage()}, "Number of Tubes Collected");
            this.add(EI.class, true, 0, 0, new Object[]{this.getMessage()}, "Donation Sample Identifier");
            this.add(XCN.class, true, 1, 0, new Object[]{this.getMessage()}, "Donation Accept Staff");
            this.add(XCN.class, true, 0, 0, new Object[]{this.getMessage()}, "Donation Material Review Staff");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating DON - this is probably a bug in the source code generator.", e);
        }
    }

    public EI getDonationIdentificationNumberDIN() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getDon1_DonationIdentificationNumberDIN() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public CNE getDonationType() {
        CNE retVal = (CNE)this.getTypedField(2, 0);
        return retVal;
    }

    public CNE getDon2_DonationType() {
        CNE retVal = (CNE)this.getTypedField(2, 0);
        return retVal;
    }

    public DTM getPhlebotomyStartDateTime() {
        DTM retVal = (DTM)this.getTypedField(3, 0);
        return retVal;
    }

    public DTM getDon3_PhlebotomyStartDateTime() {
        DTM retVal = (DTM)this.getTypedField(3, 0);
        return retVal;
    }

    public DTM getPhlebotomyEndDateTime() {
        DTM retVal = (DTM)this.getTypedField(4, 0);
        return retVal;
    }

    public DTM getDon4_PhlebotomyEndDateTime() {
        DTM retVal = (DTM)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getDonationDuration() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getDon5_DonationDuration() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public CNE getDonationDurationUnits() {
        CNE retVal = (CNE)this.getTypedField(6, 0);
        return retVal;
    }

    public CNE getDon6_DonationDurationUnits() {
        CNE retVal = (CNE)this.getTypedField(6, 0);
        return retVal;
    }

    public CNE[] getIntendedProcedureType() {
        CNE[] retVal = (CNE[])this.getTypedField(7, new CNE[0]);
        return retVal;
    }

    public CNE[] getDon7_IntendedProcedureType() {
        CNE[] retVal = (CNE[])this.getTypedField(7, new CNE[0]);
        return retVal;
    }

    public int getIntendedProcedureTypeReps() {
        return this.getReps(7);
    }

    public CNE getIntendedProcedureType(int rep) {
        CNE retVal = (CNE)this.getTypedField(7, rep);
        return retVal;
    }

    public CNE getDon7_IntendedProcedureType(int rep) {
        CNE retVal = (CNE)this.getTypedField(7, rep);
        return retVal;
    }

    public int getDon7_IntendedProcedureTypeReps() {
        return this.getReps(7);
    }

    public CNE insertIntendedProcedureType(int rep) throws HL7Exception {
        return (CNE)super.insertRepetition(7, rep);
    }

    public CNE insertDon7_IntendedProcedureType(int rep) throws HL7Exception {
        return (CNE)super.insertRepetition(7, rep);
    }

    public CNE removeIntendedProcedureType(int rep) throws HL7Exception {
        return (CNE)super.removeRepetition(7, rep);
    }

    public CNE removeDon7_IntendedProcedureType(int rep) throws HL7Exception {
        return (CNE)super.removeRepetition(7, rep);
    }

    public CNE[] getActualProcedureType() {
        CNE[] retVal = (CNE[])this.getTypedField(8, new CNE[0]);
        return retVal;
    }

    public CNE[] getDon8_ActualProcedureType() {
        CNE[] retVal = (CNE[])this.getTypedField(8, new CNE[0]);
        return retVal;
    }

    public int getActualProcedureTypeReps() {
        return this.getReps(8);
    }

    public CNE getActualProcedureType(int rep) {
        CNE retVal = (CNE)this.getTypedField(8, rep);
        return retVal;
    }

    public CNE getDon8_ActualProcedureType(int rep) {
        CNE retVal = (CNE)this.getTypedField(8, rep);
        return retVal;
    }

    public int getDon8_ActualProcedureTypeReps() {
        return this.getReps(8);
    }

    public CNE insertActualProcedureType(int rep) throws HL7Exception {
        return (CNE)super.insertRepetition(8, rep);
    }

    public CNE insertDon8_ActualProcedureType(int rep) throws HL7Exception {
        return (CNE)super.insertRepetition(8, rep);
    }

    public CNE removeActualProcedureType(int rep) throws HL7Exception {
        return (CNE)super.removeRepetition(8, rep);
    }

    public CNE removeDon8_ActualProcedureType(int rep) throws HL7Exception {
        return (CNE)super.removeRepetition(8, rep);
    }

    public ID getDonorEligibilityFlag() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getDon9_DonorEligibilityFlag() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public CNE[] getDonorEligibilityProcedureType() {
        CNE[] retVal = (CNE[])this.getTypedField(10, new CNE[0]);
        return retVal;
    }

    public CNE[] getDon10_DonorEligibilityProcedureType() {
        CNE[] retVal = (CNE[])this.getTypedField(10, new CNE[0]);
        return retVal;
    }

    public int getDonorEligibilityProcedureTypeReps() {
        return this.getReps(10);
    }

    public CNE getDonorEligibilityProcedureType(int rep) {
        CNE retVal = (CNE)this.getTypedField(10, rep);
        return retVal;
    }

    public CNE getDon10_DonorEligibilityProcedureType(int rep) {
        CNE retVal = (CNE)this.getTypedField(10, rep);
        return retVal;
    }

    public int getDon10_DonorEligibilityProcedureTypeReps() {
        return this.getReps(10);
    }

    public CNE insertDonorEligibilityProcedureType(int rep) throws HL7Exception {
        return (CNE)super.insertRepetition(10, rep);
    }

    public CNE insertDon10_DonorEligibilityProcedureType(int rep) throws HL7Exception {
        return (CNE)super.insertRepetition(10, rep);
    }

    public CNE removeDonorEligibilityProcedureType(int rep) throws HL7Exception {
        return (CNE)super.removeRepetition(10, rep);
    }

    public CNE removeDon10_DonorEligibilityProcedureType(int rep) throws HL7Exception {
        return (CNE)super.removeRepetition(10, rep);
    }

    public DTM getDonorEligibilityDate() {
        DTM retVal = (DTM)this.getTypedField(11, 0);
        return retVal;
    }

    public DTM getDon11_DonorEligibilityDate() {
        DTM retVal = (DTM)this.getTypedField(11, 0);
        return retVal;
    }

    public CNE getProcessInterruption() {
        CNE retVal = (CNE)this.getTypedField(12, 0);
        return retVal;
    }

    public CNE getDon12_ProcessInterruption() {
        CNE retVal = (CNE)this.getTypedField(12, 0);
        return retVal;
    }

    public CNE getProcessInterruptionReason() {
        CNE retVal = (CNE)this.getTypedField(13, 0);
        return retVal;
    }

    public CNE getDon13_ProcessInterruptionReason() {
        CNE retVal = (CNE)this.getTypedField(13, 0);
        return retVal;
    }

    public CNE[] getPhlebotomyIssue() {
        CNE[] retVal = (CNE[])this.getTypedField(14, new CNE[0]);
        return retVal;
    }

    public CNE[] getDon14_PhlebotomyIssue() {
        CNE[] retVal = (CNE[])this.getTypedField(14, new CNE[0]);
        return retVal;
    }

    public int getPhlebotomyIssueReps() {
        return this.getReps(14);
    }

    public CNE getPhlebotomyIssue(int rep) {
        CNE retVal = (CNE)this.getTypedField(14, rep);
        return retVal;
    }

    public CNE getDon14_PhlebotomyIssue(int rep) {
        CNE retVal = (CNE)this.getTypedField(14, rep);
        return retVal;
    }

    public int getDon14_PhlebotomyIssueReps() {
        return this.getReps(14);
    }

    public CNE insertPhlebotomyIssue(int rep) throws HL7Exception {
        return (CNE)super.insertRepetition(14, rep);
    }

    public CNE insertDon14_PhlebotomyIssue(int rep) throws HL7Exception {
        return (CNE)super.insertRepetition(14, rep);
    }

    public CNE removePhlebotomyIssue(int rep) throws HL7Exception {
        return (CNE)super.removeRepetition(14, rep);
    }

    public CNE removeDon14_PhlebotomyIssue(int rep) throws HL7Exception {
        return (CNE)super.removeRepetition(14, rep);
    }

    public ID getIntendedRecipientBloodRelative() {
        ID retVal = (ID)this.getTypedField(15, 0);
        return retVal;
    }

    public ID getDon15_IntendedRecipientBloodRelative() {
        ID retVal = (ID)this.getTypedField(15, 0);
        return retVal;
    }

    public XPN getIntendedRecipientName() {
        XPN retVal = (XPN)this.getTypedField(16, 0);
        return retVal;
    }

    public XPN getDon16_IntendedRecipientName() {
        XPN retVal = (XPN)this.getTypedField(16, 0);
        return retVal;
    }

    public DTM getIntendedRecipientDOB() {
        DTM retVal = (DTM)this.getTypedField(17, 0);
        return retVal;
    }

    public DTM getDon17_IntendedRecipientDOB() {
        DTM retVal = (DTM)this.getTypedField(17, 0);
        return retVal;
    }

    public XON getIntendedRecipientFacility() {
        XON retVal = (XON)this.getTypedField(18, 0);
        return retVal;
    }

    public XON getDon18_IntendedRecipientFacility() {
        XON retVal = (XON)this.getTypedField(18, 0);
        return retVal;
    }

    public DTM getIntendedRecipientProcedureDate() {
        DTM retVal = (DTM)this.getTypedField(19, 0);
        return retVal;
    }

    public DTM getDon19_IntendedRecipientProcedureDate() {
        DTM retVal = (DTM)this.getTypedField(19, 0);
        return retVal;
    }

    public XPN getIntendedRecipientOrderingProvider() {
        XPN retVal = (XPN)this.getTypedField(20, 0);
        return retVal;
    }

    public XPN getDon20_IntendedRecipientOrderingProvider() {
        XPN retVal = (XPN)this.getTypedField(20, 0);
        return retVal;
    }

    public CNE getPhlebotomyStatus() {
        CNE retVal = (CNE)this.getTypedField(21, 0);
        return retVal;
    }

    public CNE getDon21_PhlebotomyStatus() {
        CNE retVal = (CNE)this.getTypedField(21, 0);
        return retVal;
    }

    public CNE getArmStick() {
        CNE retVal = (CNE)this.getTypedField(22, 0);
        return retVal;
    }

    public CNE getDon22_ArmStick() {
        CNE retVal = (CNE)this.getTypedField(22, 0);
        return retVal;
    }

    public XPN getBleedStartPhlebotomist() {
        XPN retVal = (XPN)this.getTypedField(23, 0);
        return retVal;
    }

    public XPN getDon23_BleedStartPhlebotomist() {
        XPN retVal = (XPN)this.getTypedField(23, 0);
        return retVal;
    }

    public XPN getBleedEndPhlebotomist() {
        XPN retVal = (XPN)this.getTypedField(24, 0);
        return retVal;
    }

    public XPN getDon24_BleedEndPhlebotomist() {
        XPN retVal = (XPN)this.getTypedField(24, 0);
        return retVal;
    }

    public ST getAphaeresisTypeMachine() {
        ST retVal = (ST)this.getTypedField(25, 0);
        return retVal;
    }

    public ST getDon25_AphaeresisTypeMachine() {
        ST retVal = (ST)this.getTypedField(25, 0);
        return retVal;
    }

    public ST getAphaeresisMachineSerialNumber() {
        ST retVal = (ST)this.getTypedField(26, 0);
        return retVal;
    }

    public ST getDon26_AphaeresisMachineSerialNumber() {
        ST retVal = (ST)this.getTypedField(26, 0);
        return retVal;
    }

    public ID getDonorReaction() {
        ID retVal = (ID)this.getTypedField(27, 0);
        return retVal;
    }

    public ID getDon27_DonorReaction() {
        ID retVal = (ID)this.getTypedField(27, 0);
        return retVal;
    }

    public XPN getFinalReviewStaffID() {
        XPN retVal = (XPN)this.getTypedField(28, 0);
        return retVal;
    }

    public XPN getDon28_FinalReviewStaffID() {
        XPN retVal = (XPN)this.getTypedField(28, 0);
        return retVal;
    }

    public DTM getFinalReviewDateTime() {
        DTM retVal = (DTM)this.getTypedField(29, 0);
        return retVal;
    }

    public DTM getDon29_FinalReviewDateTime() {
        DTM retVal = (DTM)this.getTypedField(29, 0);
        return retVal;
    }

    public NM getNumberOfTubesCollected() {
        NM retVal = (NM)this.getTypedField(30, 0);
        return retVal;
    }

    public NM getDon30_NumberOfTubesCollected() {
        NM retVal = (NM)this.getTypedField(30, 0);
        return retVal;
    }

    public EI[] getDonationSampleIdentifier() {
        EI[] retVal = (EI[])this.getTypedField(31, new EI[0]);
        return retVal;
    }

    public EI[] getDon31_DonationSampleIdentifier() {
        EI[] retVal = (EI[])this.getTypedField(31, new EI[0]);
        return retVal;
    }

    public int getDonationSampleIdentifierReps() {
        return this.getReps(31);
    }

    public EI getDonationSampleIdentifier(int rep) {
        EI retVal = (EI)this.getTypedField(31, rep);
        return retVal;
    }

    public EI getDon31_DonationSampleIdentifier(int rep) {
        EI retVal = (EI)this.getTypedField(31, rep);
        return retVal;
    }

    public int getDon31_DonationSampleIdentifierReps() {
        return this.getReps(31);
    }

    public EI insertDonationSampleIdentifier(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(31, rep);
    }

    public EI insertDon31_DonationSampleIdentifier(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(31, rep);
    }

    public EI removeDonationSampleIdentifier(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(31, rep);
    }

    public EI removeDon31_DonationSampleIdentifier(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(31, rep);
    }

    public XCN getDonationAcceptStaff() {
        XCN retVal = (XCN)this.getTypedField(32, 0);
        return retVal;
    }

    public XCN getDon32_DonationAcceptStaff() {
        XCN retVal = (XCN)this.getTypedField(32, 0);
        return retVal;
    }

    public XCN[] getDonationMaterialReviewStaff() {
        XCN[] retVal = (XCN[])this.getTypedField(33, new XCN[0]);
        return retVal;
    }

    public XCN[] getDon33_DonationMaterialReviewStaff() {
        XCN[] retVal = (XCN[])this.getTypedField(33, new XCN[0]);
        return retVal;
    }

    public int getDonationMaterialReviewStaffReps() {
        return this.getReps(33);
    }

    public XCN getDonationMaterialReviewStaff(int rep) {
        XCN retVal = (XCN)this.getTypedField(33, rep);
        return retVal;
    }

    public XCN getDon33_DonationMaterialReviewStaff(int rep) {
        XCN retVal = (XCN)this.getTypedField(33, rep);
        return retVal;
    }

    public int getDon33_DonationMaterialReviewStaffReps() {
        return this.getReps(33);
    }

    public XCN insertDonationMaterialReviewStaff(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(33, rep);
    }

    public XCN insertDon33_DonationMaterialReviewStaff(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(33, rep);
    }

    public XCN removeDonationMaterialReviewStaff(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(33, rep);
    }

    public XCN removeDon33_DonationMaterialReviewStaff(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(33, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new CNE(this.getMessage());
            }
            case 2: {
                return new DTM(this.getMessage());
            }
            case 3: {
                return new DTM(this.getMessage());
            }
            case 4: {
                return new NM(this.getMessage());
            }
            case 5: {
                return new CNE(this.getMessage());
            }
            case 6: {
                return new CNE(this.getMessage());
            }
            case 7: {
                return new CNE(this.getMessage());
            }
            case 8: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 9: {
                return new CNE(this.getMessage());
            }
            case 10: {
                return new DTM(this.getMessage());
            }
            case 11: {
                return new CNE(this.getMessage());
            }
            case 12: {
                return new CNE(this.getMessage());
            }
            case 13: {
                return new CNE(this.getMessage());
            }
            case 14: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 15: {
                return new XPN(this.getMessage());
            }
            case 16: {
                return new DTM(this.getMessage());
            }
            case 17: {
                return new XON(this.getMessage());
            }
            case 18: {
                return new DTM(this.getMessage());
            }
            case 19: {
                return new XPN(this.getMessage());
            }
            case 20: {
                return new CNE(this.getMessage());
            }
            case 21: {
                return new CNE(this.getMessage());
            }
            case 22: {
                return new XPN(this.getMessage());
            }
            case 23: {
                return new XPN(this.getMessage());
            }
            case 24: {
                return new ST(this.getMessage());
            }
            case 25: {
                return new ST(this.getMessage());
            }
            case 26: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 27: {
                return new XPN(this.getMessage());
            }
            case 28: {
                return new DTM(this.getMessage());
            }
            case 29: {
                return new NM(this.getMessage());
            }
            case 30: {
                return new EI(this.getMessage());
            }
            case 31: {
                return new XCN(this.getMessage());
            }
            case 32: {
                return new XCN(this.getMessage());
            }
        }
        return null;
    }
}

