/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v281.group.DRC_O47_DONOR;
import ca.uhn.hl7v2.model.v281.group.DRC_O47_OBRNTE;
import ca.uhn.hl7v2.model.v281.segment.MSH;
import ca.uhn.hl7v2.model.v281.segment.SFT;
import ca.uhn.hl7v2.model.v281.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class DRC_O47
extends AbstractMessage {
    public DRC_O47() {
        this(new DefaultModelClassFactory());
    }

    public DRC_O47(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(DRC_O47_DONOR.class, false, false);
            this.add(DRC_O47_OBRNTE.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating DRC_O47 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.8.1";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public DRC_O47_DONOR getDONOR() {
        return this.getTyped("DONOR", DRC_O47_DONOR.class);
    }

    public DRC_O47_OBRNTE getOBRNTE() {
        return this.getTyped("OBRNTE", DRC_O47_OBRNTE.class);
    }

    public DRC_O47_OBRNTE getOBRNTE(int rep) {
        return this.getTyped("OBRNTE", rep, DRC_O47_OBRNTE.class);
    }

    public int getOBRNTEReps() {
        return this.getReps("OBRNTE");
    }

    public List<DRC_O47_OBRNTE> getOBRNTEAll() throws HL7Exception {
        return this.getAllAsList("OBRNTE", DRC_O47_OBRNTE.class);
    }

    public void insertOBRNTE(DRC_O47_OBRNTE structure, int rep) throws HL7Exception {
        super.insertRepetition("OBRNTE", structure, rep);
    }

    public DRC_O47_OBRNTE insertOBRNTE(int rep) throws HL7Exception {
        return (DRC_O47_OBRNTE)super.insertRepetition("OBRNTE", rep);
    }

    public DRC_O47_OBRNTE removeOBRNTE(int rep) throws HL7Exception {
        return (DRC_O47_OBRNTE)super.removeRepetition("OBRNTE", rep);
    }
}

