/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v28.group.OPU_R25_ACCESSION_DETAIL;
import ca.uhn.hl7v2.model.v28.group.OPU_R25_PATIENT_VISIT_OBSERVATION;
import ca.uhn.hl7v2.model.v28.segment.MSH;
import ca.uhn.hl7v2.model.v28.segment.NTE;
import ca.uhn.hl7v2.model.v28.segment.PRT;
import ca.uhn.hl7v2.model.v28.segment.PV1;
import ca.uhn.hl7v2.model.v28.segment.PV2;
import ca.uhn.hl7v2.model.v28.segment.SFT;
import ca.uhn.hl7v2.model.v28.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OPU_R25
extends AbstractMessage {
    public OPU_R25() {
        this(new DefaultModelClassFactory());
    }

    public OPU_R25(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(NTE.class, false, false);
            this.add(PV1.class, true, false);
            this.add(PV2.class, false, false);
            this.add(PRT.class, false, true);
            this.add(OPU_R25_PATIENT_VISIT_OBSERVATION.class, false, true);
            this.add(OPU_R25_ACCESSION_DETAIL.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OPU_R25 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.8";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public NTE getNTE() {
        return this.getTyped("NTE", NTE.class);
    }

    public PV1 getPV1() {
        return this.getTyped("PV1", PV1.class);
    }

    public PV2 getPV2() {
        return this.getTyped("PV2", PV2.class);
    }

    public PRT getPRT() {
        return this.getTyped("PRT", PRT.class);
    }

    public PRT getPRT(int rep) {
        return this.getTyped("PRT", rep, PRT.class);
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public OPU_R25_PATIENT_VISIT_OBSERVATION getPATIENT_VISIT_OBSERVATION() {
        return this.getTyped("PATIENT_VISIT_OBSERVATION", OPU_R25_PATIENT_VISIT_OBSERVATION.class);
    }

    public OPU_R25_PATIENT_VISIT_OBSERVATION getPATIENT_VISIT_OBSERVATION(int rep) {
        return this.getTyped("PATIENT_VISIT_OBSERVATION", rep, OPU_R25_PATIENT_VISIT_OBSERVATION.class);
    }

    public int getPATIENT_VISIT_OBSERVATIONReps() {
        return this.getReps("PATIENT_VISIT_OBSERVATION");
    }

    public List<OPU_R25_PATIENT_VISIT_OBSERVATION> getPATIENT_VISIT_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("PATIENT_VISIT_OBSERVATION", OPU_R25_PATIENT_VISIT_OBSERVATION.class);
    }

    public void insertPATIENT_VISIT_OBSERVATION(OPU_R25_PATIENT_VISIT_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT_VISIT_OBSERVATION", structure, rep);
    }

    public OPU_R25_PATIENT_VISIT_OBSERVATION insertPATIENT_VISIT_OBSERVATION(int rep) throws HL7Exception {
        return (OPU_R25_PATIENT_VISIT_OBSERVATION)super.insertRepetition("PATIENT_VISIT_OBSERVATION", rep);
    }

    public OPU_R25_PATIENT_VISIT_OBSERVATION removePATIENT_VISIT_OBSERVATION(int rep) throws HL7Exception {
        return (OPU_R25_PATIENT_VISIT_OBSERVATION)super.removeRepetition("PATIENT_VISIT_OBSERVATION", rep);
    }

    public OPU_R25_ACCESSION_DETAIL getACCESSION_DETAIL() {
        return this.getTyped("ACCESSION_DETAIL", OPU_R25_ACCESSION_DETAIL.class);
    }

    public OPU_R25_ACCESSION_DETAIL getACCESSION_DETAIL(int rep) {
        return this.getTyped("ACCESSION_DETAIL", rep, OPU_R25_ACCESSION_DETAIL.class);
    }

    public int getACCESSION_DETAILReps() {
        return this.getReps("ACCESSION_DETAIL");
    }

    public List<OPU_R25_ACCESSION_DETAIL> getACCESSION_DETAILAll() throws HL7Exception {
        return this.getAllAsList("ACCESSION_DETAIL", OPU_R25_ACCESSION_DETAIL.class);
    }

    public void insertACCESSION_DETAIL(OPU_R25_ACCESSION_DETAIL structure, int rep) throws HL7Exception {
        super.insertRepetition("ACCESSION_DETAIL", structure, rep);
    }

    public OPU_R25_ACCESSION_DETAIL insertACCESSION_DETAIL(int rep) throws HL7Exception {
        return (OPU_R25_ACCESSION_DETAIL)super.insertRepetition("ACCESSION_DETAIL", rep);
    }

    public OPU_R25_ACCESSION_DETAIL removeACCESSION_DETAIL(int rep) throws HL7Exception {
        return (OPU_R25_ACCESSION_DETAIL)super.removeRepetition("ACCESSION_DETAIL", rep);
    }
}

