/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v28.group.RAS_O17_ADDITIONAL_DEMOGRAPHICS;
import ca.uhn.hl7v2.model.v28.group.RAS_O17_PATIENT_VISIT;
import ca.uhn.hl7v2.model.v28.segment.AL1;
import ca.uhn.hl7v2.model.v28.segment.ARV;
import ca.uhn.hl7v2.model.v28.segment.NTE;
import ca.uhn.hl7v2.model.v28.segment.PID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RAS_O17_PATIENT
extends AbstractGroup {
    public RAS_O17_PATIENT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false, false);
            this.add(RAS_O17_ADDITIONAL_DEMOGRAPHICS.class, false, false, false);
            this.add(NTE.class, false, true, false);
            this.add(ARV.class, false, true, false);
            this.add(AL1.class, false, true, false);
            this.add(RAS_O17_PATIENT_VISIT.class, false, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RAS_O17_PATIENT - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public PID getPID() {
        PID retVal = this.getTyped("PID", PID.class);
        return retVal;
    }

    public RAS_O17_ADDITIONAL_DEMOGRAPHICS getADDITIONAL_DEMOGRAPHICS() {
        RAS_O17_ADDITIONAL_DEMOGRAPHICS retVal = this.getTyped("ADDITIONAL_DEMOGRAPHICS", RAS_O17_ADDITIONAL_DEMOGRAPHICS.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public ARV getARV() {
        ARV retVal = this.getTyped("ARV", ARV.class);
        return retVal;
    }

    public ARV getARV(int rep) {
        ARV retVal = this.getTyped("ARV", rep, ARV.class);
        return retVal;
    }

    public int getARVReps() {
        return this.getReps("ARV");
    }

    public List<ARV> getARVAll() throws HL7Exception {
        return this.getAllAsList("ARV", ARV.class);
    }

    public void insertARV(ARV structure, int rep) throws HL7Exception {
        super.insertRepetition("ARV", structure, rep);
    }

    public ARV insertARV(int rep) throws HL7Exception {
        return (ARV)super.insertRepetition("ARV", rep);
    }

    public ARV removeARV(int rep) throws HL7Exception {
        return (ARV)super.removeRepetition("ARV", rep);
    }

    public AL1 getAL1() {
        AL1 retVal = this.getTyped("AL1", AL1.class);
        return retVal;
    }

    public AL1 getAL1(int rep) {
        AL1 retVal = this.getTyped("AL1", rep, AL1.class);
        return retVal;
    }

    public int getAL1Reps() {
        return this.getReps("AL1");
    }

    public List<AL1> getAL1All() throws HL7Exception {
        return this.getAllAsList("AL1", AL1.class);
    }

    public void insertAL1(AL1 structure, int rep) throws HL7Exception {
        super.insertRepetition("AL1", structure, rep);
    }

    public AL1 insertAL1(int rep) throws HL7Exception {
        return (AL1)super.insertRepetition("AL1", rep);
    }

    public AL1 removeAL1(int rep) throws HL7Exception {
        return (AL1)super.removeRepetition("AL1", rep);
    }

    public RAS_O17_PATIENT_VISIT getPATIENT_VISIT() {
        RAS_O17_PATIENT_VISIT retVal = this.getTyped("PATIENT_VISIT", RAS_O17_PATIENT_VISIT.class);
        return retVal;
    }
}

