/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CNE;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.EI;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PRB
extends AbstractSegment {
    public PRB(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ID.class, true, 1, 2, new Object[]{this.getMessage(), new Integer(287)}, "Action Code");
            this.add(DTM.class, true, 1, 24, new Object[]{this.getMessage()}, "Action Date/Time");
            this.add(CWE.class, true, 1, 705, new Object[]{this.getMessage()}, "Problem ID");
            this.add(EI.class, true, 1, 60, new Object[]{this.getMessage()}, "Problem Instance ID");
            this.add(EI.class, false, 1, 60, new Object[]{this.getMessage()}, "Episode of Care ID");
            this.add(NM.class, false, 1, 60, new Object[]{this.getMessage()}, "Problem List Priority");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Problem Established Date/Time");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Anticipated Problem Resolution Date/Time");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Actual Problem Resolution Date/Time");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Problem Classification");
            this.add(CWE.class, false, 0, 705, new Object[]{this.getMessage()}, "Problem Management Discipline");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Problem Persistence");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Problem Confirmation Status");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Problem Life Cycle Status");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Problem Life Cycle Status Date/Time");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Problem Date of Onset");
            this.add(ST.class, false, 1, 80, new Object[]{this.getMessage()}, "Problem Onset Text");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Problem Ranking");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Certainty of Problem");
            this.add(NM.class, false, 1, 5, new Object[]{this.getMessage()}, "Probability of Problem (0-1)");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Individual Awareness of Problem");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Problem Prognosis");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Individual Awareness of Prognosis");
            this.add(ST.class, false, 1, 200, new Object[]{this.getMessage()}, "Family/Significant Other Awareness of Problem/Prognosis");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Security/Sensitivity");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Problem Severity");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Problem Perspective");
            this.add(CNE.class, false, 1, 60, new Object[]{this.getMessage()}, "Mood Code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PRB - this is probably a bug in the source code generator.", e);
        }
    }

    public ID getActionCode() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getPrb1_ActionCode() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public DTM getActionDateTime() {
        DTM retVal = (DTM)this.getTypedField(2, 0);
        return retVal;
    }

    public DTM getPrb2_ActionDateTime() {
        DTM retVal = (DTM)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getProblemID() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getPrb3_ProblemID() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getProblemInstanceID() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public EI getPrb4_ProblemInstanceID() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public EI getEpisodeOfCareID() {
        EI retVal = (EI)this.getTypedField(5, 0);
        return retVal;
    }

    public EI getPrb5_EpisodeOfCareID() {
        EI retVal = (EI)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getProblemListPriority() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getPrb6_ProblemListPriority() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public DTM getProblemEstablishedDateTime() {
        DTM retVal = (DTM)this.getTypedField(7, 0);
        return retVal;
    }

    public DTM getPrb7_ProblemEstablishedDateTime() {
        DTM retVal = (DTM)this.getTypedField(7, 0);
        return retVal;
    }

    public DTM getAnticipatedProblemResolutionDateTime() {
        DTM retVal = (DTM)this.getTypedField(8, 0);
        return retVal;
    }

    public DTM getPrb8_AnticipatedProblemResolutionDateTime() {
        DTM retVal = (DTM)this.getTypedField(8, 0);
        return retVal;
    }

    public DTM getActualProblemResolutionDateTime() {
        DTM retVal = (DTM)this.getTypedField(9, 0);
        return retVal;
    }

    public DTM getPrb9_ActualProblemResolutionDateTime() {
        DTM retVal = (DTM)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE getProblemClassification() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getPrb10_ProblemClassification() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE[] getProblemManagementDiscipline() {
        CWE[] retVal = (CWE[])this.getTypedField(11, new CWE[0]);
        return retVal;
    }

    public CWE[] getPrb11_ProblemManagementDiscipline() {
        CWE[] retVal = (CWE[])this.getTypedField(11, new CWE[0]);
        return retVal;
    }

    public int getProblemManagementDisciplineReps() {
        return this.getReps(11);
    }

    public CWE getProblemManagementDiscipline(int rep) {
        CWE retVal = (CWE)this.getTypedField(11, rep);
        return retVal;
    }

    public CWE getPrb11_ProblemManagementDiscipline(int rep) {
        CWE retVal = (CWE)this.getTypedField(11, rep);
        return retVal;
    }

    public int getPrb11_ProblemManagementDisciplineReps() {
        return this.getReps(11);
    }

    public CWE insertProblemManagementDiscipline(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(11, rep);
    }

    public CWE insertPrb11_ProblemManagementDiscipline(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(11, rep);
    }

    public CWE removeProblemManagementDiscipline(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(11, rep);
    }

    public CWE removePrb11_ProblemManagementDiscipline(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(11, rep);
    }

    public CWE getProblemPersistence() {
        CWE retVal = (CWE)this.getTypedField(12, 0);
        return retVal;
    }

    public CWE getPrb12_ProblemPersistence() {
        CWE retVal = (CWE)this.getTypedField(12, 0);
        return retVal;
    }

    public CWE getProblemConfirmationStatus() {
        CWE retVal = (CWE)this.getTypedField(13, 0);
        return retVal;
    }

    public CWE getPrb13_ProblemConfirmationStatus() {
        CWE retVal = (CWE)this.getTypedField(13, 0);
        return retVal;
    }

    public CWE getProblemLifeCycleStatus() {
        CWE retVal = (CWE)this.getTypedField(14, 0);
        return retVal;
    }

    public CWE getPrb14_ProblemLifeCycleStatus() {
        CWE retVal = (CWE)this.getTypedField(14, 0);
        return retVal;
    }

    public DTM getProblemLifeCycleStatusDateTime() {
        DTM retVal = (DTM)this.getTypedField(15, 0);
        return retVal;
    }

    public DTM getPrb15_ProblemLifeCycleStatusDateTime() {
        DTM retVal = (DTM)this.getTypedField(15, 0);
        return retVal;
    }

    public DTM getProblemDateOfOnset() {
        DTM retVal = (DTM)this.getTypedField(16, 0);
        return retVal;
    }

    public DTM getPrb16_ProblemDateOfOnset() {
        DTM retVal = (DTM)this.getTypedField(16, 0);
        return retVal;
    }

    public ST getProblemOnsetText() {
        ST retVal = (ST)this.getTypedField(17, 0);
        return retVal;
    }

    public ST getPrb17_ProblemOnsetText() {
        ST retVal = (ST)this.getTypedField(17, 0);
        return retVal;
    }

    public CWE getProblemRanking() {
        CWE retVal = (CWE)this.getTypedField(18, 0);
        return retVal;
    }

    public CWE getPrb18_ProblemRanking() {
        CWE retVal = (CWE)this.getTypedField(18, 0);
        return retVal;
    }

    public CWE getCertaintyOfProblem() {
        CWE retVal = (CWE)this.getTypedField(19, 0);
        return retVal;
    }

    public CWE getPrb19_CertaintyOfProblem() {
        CWE retVal = (CWE)this.getTypedField(19, 0);
        return retVal;
    }

    public NM getProbabilityOfProblem() {
        NM retVal = (NM)this.getTypedField(20, 0);
        return retVal;
    }

    public NM getPrb20_ProbabilityOfProblem() {
        NM retVal = (NM)this.getTypedField(20, 0);
        return retVal;
    }

    public CWE getIndividualAwarenessOfProblem() {
        CWE retVal = (CWE)this.getTypedField(21, 0);
        return retVal;
    }

    public CWE getPrb21_IndividualAwarenessOfProblem() {
        CWE retVal = (CWE)this.getTypedField(21, 0);
        return retVal;
    }

    public CWE getProblemPrognosis() {
        CWE retVal = (CWE)this.getTypedField(22, 0);
        return retVal;
    }

    public CWE getPrb22_ProblemPrognosis() {
        CWE retVal = (CWE)this.getTypedField(22, 0);
        return retVal;
    }

    public CWE getIndividualAwarenessOfPrognosis() {
        CWE retVal = (CWE)this.getTypedField(23, 0);
        return retVal;
    }

    public CWE getPrb23_IndividualAwarenessOfPrognosis() {
        CWE retVal = (CWE)this.getTypedField(23, 0);
        return retVal;
    }

    public ST getFamilySignificantOtherAwarenessOfProblemPrognosis() {
        ST retVal = (ST)this.getTypedField(24, 0);
        return retVal;
    }

    public ST getPrb24_FamilySignificantOtherAwarenessOfProblemPrognosis() {
        ST retVal = (ST)this.getTypedField(24, 0);
        return retVal;
    }

    public CWE getSecuritySensitivity() {
        CWE retVal = (CWE)this.getTypedField(25, 0);
        return retVal;
    }

    public CWE getPrb25_SecuritySensitivity() {
        CWE retVal = (CWE)this.getTypedField(25, 0);
        return retVal;
    }

    public CWE getProblemSeverity() {
        CWE retVal = (CWE)this.getTypedField(26, 0);
        return retVal;
    }

    public CWE getPrb26_ProblemSeverity() {
        CWE retVal = (CWE)this.getTypedField(26, 0);
        return retVal;
    }

    public CWE getProblemPerspective() {
        CWE retVal = (CWE)this.getTypedField(27, 0);
        return retVal;
    }

    public CWE getPrb27_ProblemPerspective() {
        CWE retVal = (CWE)this.getTypedField(27, 0);
        return retVal;
    }

    public CNE getMoodCode() {
        CNE retVal = (CNE)this.getTypedField(28, 0);
        return retVal;
    }

    public CNE getPrb28_MoodCode() {
        CNE retVal = (CNE)this.getTypedField(28, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ID(this.getMessage(), new Integer(287));
            }
            case 1: {
                return new DTM(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new EI(this.getMessage());
            }
            case 4: {
                return new EI(this.getMessage());
            }
            case 5: {
                return new NM(this.getMessage());
            }
            case 6: {
                return new DTM(this.getMessage());
            }
            case 7: {
                return new DTM(this.getMessage());
            }
            case 8: {
                return new DTM(this.getMessage());
            }
            case 9: {
                return new CWE(this.getMessage());
            }
            case 10: {
                return new CWE(this.getMessage());
            }
            case 11: {
                return new CWE(this.getMessage());
            }
            case 12: {
                return new CWE(this.getMessage());
            }
            case 13: {
                return new CWE(this.getMessage());
            }
            case 14: {
                return new DTM(this.getMessage());
            }
            case 15: {
                return new DTM(this.getMessage());
            }
            case 16: {
                return new ST(this.getMessage());
            }
            case 17: {
                return new CWE(this.getMessage());
            }
            case 18: {
                return new CWE(this.getMessage());
            }
            case 19: {
                return new NM(this.getMessage());
            }
            case 20: {
                return new CWE(this.getMessage());
            }
            case 21: {
                return new CWE(this.getMessage());
            }
            case 22: {
                return new CWE(this.getMessage());
            }
            case 23: {
                return new ST(this.getMessage());
            }
            case 24: {
                return new CWE(this.getMessage());
            }
            case 25: {
                return new CWE(this.getMessage());
            }
            case 26: {
                return new CWE(this.getMessage());
            }
            case 27: {
                return new CNE(this.getMessage());
            }
        }
        return null;
    }
}

