/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.SCD;
import ca.uhn.hl7v2.model.v26.segment.SDD;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class SDR_S32
extends AbstractMessage {
    public SDR_S32() {
        this(new DefaultModelClassFactory());
    }

    public SDR_S32(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(SDD.class, true, false);
            this.add(SCD.class, false, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating SDR_S32 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public SDD getSDD() {
        return this.getTyped("SDD", SDD.class);
    }

    public SCD getSCD() {
        return this.getTyped("SCD", SCD.class);
    }

    public SCD getSCD(int rep) {
        return this.getTyped("SCD", rep, SCD.class);
    }

    public int getSCDReps() {
        return this.getReps("SCD");
    }

    public List<SCD> getSCDAll() throws HL7Exception {
        return this.getAllAsList("SCD", SCD.class);
    }

    public void insertSCD(SCD structure, int rep) throws HL7Exception {
        super.insertRepetition("SCD", structure, rep);
    }

    public SCD insertSCD(int rep) throws HL7Exception {
        return (SCD)super.insertRepetition("SCD", rep);
    }

    public SCD removeSCD(int rep) throws HL7Exception {
        return (SCD)super.removeRepetition("SCD", rep);
    }
}

