/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v26.group.ORN_O08_TIMING;
import ca.uhn.hl7v2.model.v26.segment.NTE;
import ca.uhn.hl7v2.model.v26.segment.ORC;
import ca.uhn.hl7v2.model.v26.segment.RQ1;
import ca.uhn.hl7v2.model.v26.segment.RQD;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ORN_O08_ORDER
extends AbstractGroup {
    public ORN_O08_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(ORN_O08_TIMING.class, false, true, false);
            this.add(RQD.class, true, false, false);
            this.add(RQ1.class, false, false, false);
            this.add(NTE.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ORN_O08_ORDER - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public ORC getORC() {
        ORC retVal = this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public ORN_O08_TIMING getTIMING() {
        ORN_O08_TIMING retVal = this.getTyped("TIMING", ORN_O08_TIMING.class);
        return retVal;
    }

    public ORN_O08_TIMING getTIMING(int rep) {
        ORN_O08_TIMING retVal = this.getTyped("TIMING", rep, ORN_O08_TIMING.class);
        return retVal;
    }

    public int getTIMINGReps() {
        return this.getReps("TIMING");
    }

    public List<ORN_O08_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", ORN_O08_TIMING.class);
    }

    public void insertTIMING(ORN_O08_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", structure, rep);
    }

    public ORN_O08_TIMING insertTIMING(int rep) throws HL7Exception {
        return (ORN_O08_TIMING)super.insertRepetition("TIMING", rep);
    }

    public ORN_O08_TIMING removeTIMING(int rep) throws HL7Exception {
        return (ORN_O08_TIMING)super.removeRepetition("TIMING", rep);
    }

    public RQD getRQD() {
        RQD retVal = this.getTyped("RQD", RQD.class);
        return retVal;
    }

    public RQ1 getRQ1() {
        RQ1 retVal = this.getTyped("RQ1", RQ1.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }
}

