/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v26.group.EHC_E01_INVOICE_PROCESSING;
import ca.uhn.hl7v2.model.v26.group.EHC_E01_PATIENT_INFO;
import ca.uhn.hl7v2.model.v26.group.EHC_E01_PROCEDURE;
import ca.uhn.hl7v2.model.v26.group.EHC_E01_PRODUCT_SERVICE_LINE_ITEM;
import ca.uhn.hl7v2.model.v26.segment.LOC;
import ca.uhn.hl7v2.model.v26.segment.PSG;
import ca.uhn.hl7v2.model.v26.segment.ROL;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class EHC_E01_PRODUCT_SERVICE_GROUP
extends AbstractGroup {
    public EHC_E01_PRODUCT_SERVICE_GROUP(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PSG.class, true, false, true);
            this.add(LOC.class, false, true, true);
            this.add(ROL.class, false, true, true);
            this.add(EHC_E01_PATIENT_INFO.class, false, true, false);
            this.add(EHC_E01_PRODUCT_SERVICE_LINE_ITEM.class, true, true, false);
            this.add(EHC_E01_PROCEDURE.class, false, true, false);
            this.add(EHC_E01_INVOICE_PROCESSING.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating EHC_E01_PRODUCT_SERVICE_GROUP - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public PSG getPSG() {
        PSG retVal = this.getTyped("PSG", PSG.class);
        return retVal;
    }

    public LOC getLOC() {
        LOC retVal = this.getTyped("LOC", LOC.class);
        return retVal;
    }

    public LOC getLOC(int rep) {
        LOC retVal = this.getTyped("LOC", rep, LOC.class);
        return retVal;
    }

    public int getLOCReps() {
        return this.getReps("LOC");
    }

    public List<LOC> getLOCAll() throws HL7Exception {
        return this.getAllAsList("LOC", LOC.class);
    }

    public void insertLOC(LOC structure, int rep) throws HL7Exception {
        super.insertRepetition("LOC", structure, rep);
    }

    public LOC insertLOC(int rep) throws HL7Exception {
        return (LOC)super.insertRepetition("LOC", rep);
    }

    public LOC removeLOC(int rep) throws HL7Exception {
        return (LOC)super.removeRepetition("LOC", rep);
    }

    public ROL getROL() {
        ROL retVal = this.getTyped("ROL", ROL.class);
        return retVal;
    }

    public ROL getROL(int rep) {
        ROL retVal = this.getTyped("ROL", rep, ROL.class);
        return retVal;
    }

    public int getROLReps() {
        return this.getReps("ROL");
    }

    public List<ROL> getROLAll() throws HL7Exception {
        return this.getAllAsList("ROL", ROL.class);
    }

    public void insertROL(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL", structure, rep);
    }

    public ROL insertROL(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL", rep);
    }

    public ROL removeROL(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL", rep);
    }

    public EHC_E01_PATIENT_INFO getPATIENT_INFO() {
        EHC_E01_PATIENT_INFO retVal = this.getTyped("PATIENT_INFO", EHC_E01_PATIENT_INFO.class);
        return retVal;
    }

    public EHC_E01_PATIENT_INFO getPATIENT_INFO(int rep) {
        EHC_E01_PATIENT_INFO retVal = this.getTyped("PATIENT_INFO", rep, EHC_E01_PATIENT_INFO.class);
        return retVal;
    }

    public int getPATIENT_INFOReps() {
        return this.getReps("PATIENT_INFO");
    }

    public List<EHC_E01_PATIENT_INFO> getPATIENT_INFOAll() throws HL7Exception {
        return this.getAllAsList("PATIENT_INFO", EHC_E01_PATIENT_INFO.class);
    }

    public void insertPATIENT_INFO(EHC_E01_PATIENT_INFO structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT_INFO", structure, rep);
    }

    public EHC_E01_PATIENT_INFO insertPATIENT_INFO(int rep) throws HL7Exception {
        return (EHC_E01_PATIENT_INFO)super.insertRepetition("PATIENT_INFO", rep);
    }

    public EHC_E01_PATIENT_INFO removePATIENT_INFO(int rep) throws HL7Exception {
        return (EHC_E01_PATIENT_INFO)super.removeRepetition("PATIENT_INFO", rep);
    }

    public EHC_E01_PRODUCT_SERVICE_LINE_ITEM getPRODUCT_SERVICE_LINE_ITEM() {
        EHC_E01_PRODUCT_SERVICE_LINE_ITEM retVal = this.getTyped("PRODUCT_SERVICE_LINE_ITEM", EHC_E01_PRODUCT_SERVICE_LINE_ITEM.class);
        return retVal;
    }

    public EHC_E01_PRODUCT_SERVICE_LINE_ITEM getPRODUCT_SERVICE_LINE_ITEM(int rep) {
        EHC_E01_PRODUCT_SERVICE_LINE_ITEM retVal = this.getTyped("PRODUCT_SERVICE_LINE_ITEM", rep, EHC_E01_PRODUCT_SERVICE_LINE_ITEM.class);
        return retVal;
    }

    public int getPRODUCT_SERVICE_LINE_ITEMReps() {
        return this.getReps("PRODUCT_SERVICE_LINE_ITEM");
    }

    public List<EHC_E01_PRODUCT_SERVICE_LINE_ITEM> getPRODUCT_SERVICE_LINE_ITEMAll() throws HL7Exception {
        return this.getAllAsList("PRODUCT_SERVICE_LINE_ITEM", EHC_E01_PRODUCT_SERVICE_LINE_ITEM.class);
    }

    public void insertPRODUCT_SERVICE_LINE_ITEM(EHC_E01_PRODUCT_SERVICE_LINE_ITEM structure, int rep) throws HL7Exception {
        super.insertRepetition("PRODUCT_SERVICE_LINE_ITEM", structure, rep);
    }

    public EHC_E01_PRODUCT_SERVICE_LINE_ITEM insertPRODUCT_SERVICE_LINE_ITEM(int rep) throws HL7Exception {
        return (EHC_E01_PRODUCT_SERVICE_LINE_ITEM)super.insertRepetition("PRODUCT_SERVICE_LINE_ITEM", rep);
    }

    public EHC_E01_PRODUCT_SERVICE_LINE_ITEM removePRODUCT_SERVICE_LINE_ITEM(int rep) throws HL7Exception {
        return (EHC_E01_PRODUCT_SERVICE_LINE_ITEM)super.removeRepetition("PRODUCT_SERVICE_LINE_ITEM", rep);
    }

    public EHC_E01_PROCEDURE getPROCEDURE() {
        EHC_E01_PROCEDURE retVal = this.getTyped("PROCEDURE", EHC_E01_PROCEDURE.class);
        return retVal;
    }

    public EHC_E01_PROCEDURE getPROCEDURE(int rep) {
        EHC_E01_PROCEDURE retVal = this.getTyped("PROCEDURE", rep, EHC_E01_PROCEDURE.class);
        return retVal;
    }

    public int getPROCEDUREReps() {
        return this.getReps("PROCEDURE");
    }

    public List<EHC_E01_PROCEDURE> getPROCEDUREAll() throws HL7Exception {
        return this.getAllAsList("PROCEDURE", EHC_E01_PROCEDURE.class);
    }

    public void insertPROCEDURE(EHC_E01_PROCEDURE structure, int rep) throws HL7Exception {
        super.insertRepetition("PROCEDURE", structure, rep);
    }

    public EHC_E01_PROCEDURE insertPROCEDURE(int rep) throws HL7Exception {
        return (EHC_E01_PROCEDURE)super.insertRepetition("PROCEDURE", rep);
    }

    public EHC_E01_PROCEDURE removePROCEDURE(int rep) throws HL7Exception {
        return (EHC_E01_PROCEDURE)super.removeRepetition("PROCEDURE", rep);
    }

    public EHC_E01_INVOICE_PROCESSING getINVOICE_PROCESSING() {
        EHC_E01_INVOICE_PROCESSING retVal = this.getTyped("INVOICE_PROCESSING", EHC_E01_INVOICE_PROCESSING.class);
        return retVal;
    }

    public EHC_E01_INVOICE_PROCESSING getINVOICE_PROCESSING(int rep) {
        EHC_E01_INVOICE_PROCESSING retVal = this.getTyped("INVOICE_PROCESSING", rep, EHC_E01_INVOICE_PROCESSING.class);
        return retVal;
    }

    public int getINVOICE_PROCESSINGReps() {
        return this.getReps("INVOICE_PROCESSING");
    }

    public List<EHC_E01_INVOICE_PROCESSING> getINVOICE_PROCESSINGAll() throws HL7Exception {
        return this.getAllAsList("INVOICE_PROCESSING", EHC_E01_INVOICE_PROCESSING.class);
    }

    public void insertINVOICE_PROCESSING(EHC_E01_INVOICE_PROCESSING structure, int rep) throws HL7Exception {
        super.insertRepetition("INVOICE_PROCESSING", structure, rep);
    }

    public EHC_E01_INVOICE_PROCESSING insertINVOICE_PROCESSING(int rep) throws HL7Exception {
        return (EHC_E01_INVOICE_PROCESSING)super.insertRepetition("INVOICE_PROCESSING", rep);
    }

    public EHC_E01_INVOICE_PROCESSING removeINVOICE_PROCESSING(int rep) throws HL7Exception {
        return (EHC_E01_INVOICE_PROCESSING)super.removeRepetition("INVOICE_PROCESSING", rep);
    }
}

