/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.CX;
import ca.uhn.hl7v2.model.v25.datatype.DR;
import ca.uhn.hl7v2.model.v25.datatype.ID;
import ca.uhn.hl7v2.model.v25.datatype.SI;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ORG
extends AbstractSegment {
    public ORG(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 60, new Object[]{this.getMessage()}, "Set ID _ ORG");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Organization Unit Code");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Organization Unit Type Code");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Primary Org Unit Indicator");
            this.add(CX.class, false, 1, 60, new Object[]{this.getMessage()}, "Practitioner Org Unit Identifier");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Health Care Provider Type Code");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Health Care Provider Classification Code");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Health Care Provider Area of Specialization Code");
            this.add(DR.class, false, 1, 52, new Object[]{this.getMessage()}, "Effective Date Range");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Employment Status Code");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Board Approval Indicator");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Primary Care Physician Indicator");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ORG - this is probably a bug in the source code generator.", e);
        }
    }

    public SI getSetIDORG() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getOrg1_SetIDORG() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getOrganizationUnitCode() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getOrg2_OrganizationUnitCode() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getOrganizationUnitTypeCode() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getOrg3_OrganizationUnitTypeCode() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public ID getPrimaryOrgUnitIndicator() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getOrg4_PrimaryOrgUnitIndicator() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public CX getPractitionerOrgUnitIdentifier() {
        CX retVal = (CX)this.getTypedField(5, 0);
        return retVal;
    }

    public CX getOrg5_PractitionerOrgUnitIdentifier() {
        CX retVal = (CX)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getHealthCareProviderTypeCode() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getOrg6_HealthCareProviderTypeCode() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getHealthCareProviderClassificationCode() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getOrg7_HealthCareProviderClassificationCode() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getHealthCareProviderAreaOfSpecializationCode() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public CE getOrg8_HealthCareProviderAreaOfSpecializationCode() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public DR getEffectiveDateRange() {
        DR retVal = (DR)this.getTypedField(9, 0);
        return retVal;
    }

    public DR getOrg9_EffectiveDateRange() {
        DR retVal = (DR)this.getTypedField(9, 0);
        return retVal;
    }

    public CE getEmploymentStatusCode() {
        CE retVal = (CE)this.getTypedField(10, 0);
        return retVal;
    }

    public CE getOrg10_EmploymentStatusCode() {
        CE retVal = (CE)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getBoardApprovalIndicator() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getOrg11_BoardApprovalIndicator() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getPrimaryCarePhysicianIndicator() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getOrg12_PrimaryCarePhysicianIndicator() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 4: {
                return new CX(this.getMessage());
            }
            case 5: {
                return new CE(this.getMessage());
            }
            case 6: {
                return new CE(this.getMessage());
            }
            case 7: {
                return new CE(this.getMessage());
            }
            case 8: {
                return new DR(this.getMessage());
            }
            case 9: {
                return new CE(this.getMessage());
            }
            case 10: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 11: {
                return new ID(this.getMessage(), new Integer(136));
            }
        }
        return null;
    }
}

