/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v25.group.TCU_U10_TEST_CONFIGURATION;
import ca.uhn.hl7v2.model.v25.segment.EQU;
import ca.uhn.hl7v2.model.v25.segment.MSH;
import ca.uhn.hl7v2.model.v25.segment.ROL;
import ca.uhn.hl7v2.model.v25.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class TCU_U10
extends AbstractMessage {
    public TCU_U10() {
        this(new DefaultModelClassFactory());
    }

    public TCU_U10(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(EQU.class, true, false);
            this.add(TCU_U10_TEST_CONFIGURATION.class, true, true);
            this.add(ROL.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating TCU_U10 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.5";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public EQU getEQU() {
        return this.getTyped("EQU", EQU.class);
    }

    public TCU_U10_TEST_CONFIGURATION getTEST_CONFIGURATION() {
        return this.getTyped("TEST_CONFIGURATION", TCU_U10_TEST_CONFIGURATION.class);
    }

    public TCU_U10_TEST_CONFIGURATION getTEST_CONFIGURATION(int rep) {
        return this.getTyped("TEST_CONFIGURATION", rep, TCU_U10_TEST_CONFIGURATION.class);
    }

    public int getTEST_CONFIGURATIONReps() {
        return this.getReps("TEST_CONFIGURATION");
    }

    public List<TCU_U10_TEST_CONFIGURATION> getTEST_CONFIGURATIONAll() throws HL7Exception {
        return this.getAllAsList("TEST_CONFIGURATION", TCU_U10_TEST_CONFIGURATION.class);
    }

    public void insertTEST_CONFIGURATION(TCU_U10_TEST_CONFIGURATION structure, int rep) throws HL7Exception {
        super.insertRepetition("TEST_CONFIGURATION", structure, rep);
    }

    public TCU_U10_TEST_CONFIGURATION insertTEST_CONFIGURATION(int rep) throws HL7Exception {
        return (TCU_U10_TEST_CONFIGURATION)super.insertRepetition("TEST_CONFIGURATION", rep);
    }

    public TCU_U10_TEST_CONFIGURATION removeTEST_CONFIGURATION(int rep) throws HL7Exception {
        return (TCU_U10_TEST_CONFIGURATION)super.removeRepetition("TEST_CONFIGURATION", rep);
    }

    public ROL getROL() {
        return this.getTyped("ROL", ROL.class);
    }
}

