/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v25.group.RSP_Q11_MF_LOC_DEPT;
import ca.uhn.hl7v2.model.v25.segment.LCH;
import ca.uhn.hl7v2.model.v25.segment.LOC;
import ca.uhn.hl7v2.model.v25.segment.LRL;
import ca.uhn.hl7v2.model.v25.segment.MFE;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RSP_Q11_QUERY_RESULT_CLUSTER
extends AbstractGroup {
    public RSP_Q11_QUERY_RESULT_CLUSTER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MFE.class, true, false, false);
            this.add(LOC.class, true, false, false);
            this.add(LCH.class, false, true, false);
            this.add(LRL.class, false, true, false);
            this.add(RSP_Q11_MF_LOC_DEPT.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RSP_Q11_QUERY_RESULT_CLUSTER - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public MFE getMFE() {
        MFE retVal = this.getTyped("MFE", MFE.class);
        return retVal;
    }

    public LOC getLOC() {
        LOC retVal = this.getTyped("LOC", LOC.class);
        return retVal;
    }

    public LCH getLCH() {
        LCH retVal = this.getTyped("LCH", LCH.class);
        return retVal;
    }

    public LCH getLCH(int rep) {
        LCH retVal = this.getTyped("LCH", rep, LCH.class);
        return retVal;
    }

    public int getLCHReps() {
        return this.getReps("LCH");
    }

    public List<LCH> getLCHAll() throws HL7Exception {
        return this.getAllAsList("LCH", LCH.class);
    }

    public void insertLCH(LCH structure, int rep) throws HL7Exception {
        super.insertRepetition("LCH", structure, rep);
    }

    public LCH insertLCH(int rep) throws HL7Exception {
        return (LCH)super.insertRepetition("LCH", rep);
    }

    public LCH removeLCH(int rep) throws HL7Exception {
        return (LCH)super.removeRepetition("LCH", rep);
    }

    public LRL getLRL() {
        LRL retVal = this.getTyped("LRL", LRL.class);
        return retVal;
    }

    public LRL getLRL(int rep) {
        LRL retVal = this.getTyped("LRL", rep, LRL.class);
        return retVal;
    }

    public int getLRLReps() {
        return this.getReps("LRL");
    }

    public List<LRL> getLRLAll() throws HL7Exception {
        return this.getAllAsList("LRL", LRL.class);
    }

    public void insertLRL(LRL structure, int rep) throws HL7Exception {
        super.insertRepetition("LRL", structure, rep);
    }

    public LRL insertLRL(int rep) throws HL7Exception {
        return (LRL)super.insertRepetition("LRL", rep);
    }

    public LRL removeLRL(int rep) throws HL7Exception {
        return (LRL)super.removeRepetition("LRL", rep);
    }

    public RSP_Q11_MF_LOC_DEPT getMF_LOC_DEPT() {
        RSP_Q11_MF_LOC_DEPT retVal = this.getTyped("MF_LOC_DEPT", RSP_Q11_MF_LOC_DEPT.class);
        return retVal;
    }

    public RSP_Q11_MF_LOC_DEPT getMF_LOC_DEPT(int rep) {
        RSP_Q11_MF_LOC_DEPT retVal = this.getTyped("MF_LOC_DEPT", rep, RSP_Q11_MF_LOC_DEPT.class);
        return retVal;
    }

    public int getMF_LOC_DEPTReps() {
        return this.getReps("MF_LOC_DEPT");
    }

    public List<RSP_Q11_MF_LOC_DEPT> getMF_LOC_DEPTAll() throws HL7Exception {
        return this.getAllAsList("MF_LOC_DEPT", RSP_Q11_MF_LOC_DEPT.class);
    }

    public void insertMF_LOC_DEPT(RSP_Q11_MF_LOC_DEPT structure, int rep) throws HL7Exception {
        super.insertRepetition("MF_LOC_DEPT", structure, rep);
    }

    public RSP_Q11_MF_LOC_DEPT insertMF_LOC_DEPT(int rep) throws HL7Exception {
        return (RSP_Q11_MF_LOC_DEPT)super.insertRepetition("MF_LOC_DEPT", rep);
    }

    public RSP_Q11_MF_LOC_DEPT removeMF_LOC_DEPT(int rep) throws HL7Exception {
        return (RSP_Q11_MF_LOC_DEPT)super.removeRepetition("MF_LOC_DEPT", rep);
    }
}

