/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v25.group.RER_RER_ORDER;
import ca.uhn.hl7v2.model.v25.group.RER_RER_PATIENT;
import ca.uhn.hl7v2.model.v25.segment.QRD;
import ca.uhn.hl7v2.model.v25.segment.QRF;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RER_RER_DEFINITION
extends AbstractGroup {
    public RER_RER_DEFINITION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(QRD.class, true, false, false);
            this.add(QRF.class, false, false, false);
            this.add(RER_RER_PATIENT.class, false, false, false);
            this.add(RER_RER_ORDER.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RER_RER_DEFINITION - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public QRD getQRD() {
        QRD retVal = this.getTyped("QRD", QRD.class);
        return retVal;
    }

    public QRF getQRF() {
        QRF retVal = this.getTyped("QRF", QRF.class);
        return retVal;
    }

    public RER_RER_PATIENT getPATIENT() {
        RER_RER_PATIENT retVal = this.getTyped("PATIENT", RER_RER_PATIENT.class);
        return retVal;
    }

    public RER_RER_ORDER getORDER() {
        RER_RER_ORDER retVal = this.getTyped("ORDER", RER_RER_ORDER.class);
        return retVal;
    }

    public RER_RER_ORDER getORDER(int rep) {
        RER_RER_ORDER retVal = this.getTyped("ORDER", rep, RER_RER_ORDER.class);
        return retVal;
    }

    public int getORDERReps() {
        return this.getReps("ORDER");
    }

    public List<RER_RER_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", RER_RER_ORDER.class);
    }

    public void insertORDER(RER_RER_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", structure, rep);
    }

    public RER_RER_ORDER insertORDER(int rep) throws HL7Exception {
        return (RER_RER_ORDER)super.insertRepetition("ORDER", rep);
    }

    public RER_RER_ORDER removeORDER(int rep) throws HL7Exception {
        return (RER_RER_ORDER)super.removeRepetition("ORDER", rep);
    }
}

