/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v231.group.ORF_R04_PIDNTEORCOBRNTEOBXNTECTI;
import ca.uhn.hl7v2.model.v231.segment.DSC;
import ca.uhn.hl7v2.model.v231.segment.ERR;
import ca.uhn.hl7v2.model.v231.segment.MSA;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.model.v231.segment.QAK;
import ca.uhn.hl7v2.model.v231.segment.QRD;
import ca.uhn.hl7v2.model.v231.segment.QRF;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ORF_R04
extends AbstractMessage {
    public ORF_R04() {
        this(new DefaultModelClassFactory());
    }

    public ORF_R04(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(QRD.class, true, false);
            this.add(QRF.class, false, false);
            this.add(ORF_R04_PIDNTEORCOBRNTEOBXNTECTI.class, true, true);
            this.add(ERR.class, false, false);
            this.add(QAK.class, false, false);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ORF_R04 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return this.getTyped("MSA", MSA.class);
    }

    public QRD getQRD() {
        return this.getTyped("QRD", QRD.class);
    }

    public QRF getQRF() {
        return this.getTyped("QRF", QRF.class);
    }

    public ORF_R04_PIDNTEORCOBRNTEOBXNTECTI getPIDNTEORCOBRNTEOBXNTECTI() {
        return this.getTyped("PIDNTEORCOBRNTEOBXNTECTI", ORF_R04_PIDNTEORCOBRNTEOBXNTECTI.class);
    }

    public ORF_R04_PIDNTEORCOBRNTEOBXNTECTI getPIDNTEORCOBRNTEOBXNTECTI(int rep) {
        return this.getTyped("PIDNTEORCOBRNTEOBXNTECTI", rep, ORF_R04_PIDNTEORCOBRNTEOBXNTECTI.class);
    }

    public int getPIDNTEORCOBRNTEOBXNTECTIReps() {
        return this.getReps("PIDNTEORCOBRNTEOBXNTECTI");
    }

    public List<ORF_R04_PIDNTEORCOBRNTEOBXNTECTI> getPIDNTEORCOBRNTEOBXNTECTIAll() throws HL7Exception {
        return this.getAllAsList("PIDNTEORCOBRNTEOBXNTECTI", ORF_R04_PIDNTEORCOBRNTEOBXNTECTI.class);
    }

    public void insertPIDNTEORCOBRNTEOBXNTECTI(ORF_R04_PIDNTEORCOBRNTEOBXNTECTI structure, int rep) throws HL7Exception {
        super.insertRepetition("PIDNTEORCOBRNTEOBXNTECTI", structure, rep);
    }

    public ORF_R04_PIDNTEORCOBRNTEOBXNTECTI insertPIDNTEORCOBRNTEOBXNTECTI(int rep) throws HL7Exception {
        return (ORF_R04_PIDNTEORCOBRNTEOBXNTECTI)super.insertRepetition("PIDNTEORCOBRNTEOBXNTECTI", rep);
    }

    public ORF_R04_PIDNTEORCOBRNTEOBXNTECTI removePIDNTEORCOBRNTEOBXNTECTI(int rep) throws HL7Exception {
        return (ORF_R04_PIDNTEORCOBRNTEOBXNTECTI)super.removeRepetition("PIDNTEORCOBRNTEOBXNTECTI", rep);
    }

    public ERR getERR() {
        return this.getTyped("ERR", ERR.class);
    }

    public QAK getQAK() {
        return this.getTyped("QAK", QAK.class);
    }

    public DSC getDSC() {
        return this.getTyped("DSC", DSC.class);
    }
}

