/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.AD;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.CM_DIN;
import ca.uhn.hl7v2.model.v23.datatype.DLN;
import ca.uhn.hl7v2.model.v23.datatype.DT;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.IS;
import ca.uhn.hl7v2.model.v23.datatype.JCC;
import ca.uhn.hl7v2.model.v23.datatype.ST;
import ca.uhn.hl7v2.model.v23.datatype.TS;
import ca.uhn.hl7v2.model.v23.datatype.XPN;
import ca.uhn.hl7v2.model.v23.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class STF
extends AbstractSegment {
    public STF(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, true, 1, 60, new Object[]{this.getMessage()}, "STF - Primary Key Value");
            this.add(CE.class, false, 0, 60, new Object[]{this.getMessage()}, "Staff ID Code");
            this.add(XPN.class, false, 1, 48, new Object[]{this.getMessage()}, "Staff Name");
            this.add(ID.class, false, 0, 2, new Object[]{this.getMessage(), new Integer(182)}, "Staff Type");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(1)}, "Sex");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Date of Birth");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(183)}, "Active/Inactive Flag");
            this.add(CE.class, false, 0, 200, new Object[]{this.getMessage()}, "Department");
            this.add(CE.class, false, 0, 200, new Object[]{this.getMessage()}, "Service");
            this.add(XTN.class, false, 0, 40, new Object[]{this.getMessage()}, "Phone");
            this.add(AD.class, false, 2, 106, new Object[]{this.getMessage()}, "Office/Home Address");
            this.add(CM_DIN.class, false, 0, 26, new Object[]{this.getMessage()}, "Activation Date");
            this.add(CM_DIN.class, false, 0, 26, new Object[]{this.getMessage()}, "Inactivation Date");
            this.add(CE.class, false, 0, 60, new Object[]{this.getMessage()}, "Backup Person ID");
            this.add(ST.class, false, 0, 40, new Object[]{this.getMessage()}, "E-mail Address");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "Preferred Method of Contact");
            this.add(IS.class, false, 0, 1, new Object[]{this.getMessage(), new Integer(2)}, "Marital Status");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "Job Title");
            this.add(JCC.class, false, 1, 20, new Object[]{this.getMessage()}, "Job Code/Class");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(66)}, "Employment Status");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Additional Insured on Auto");
            this.add(DLN.class, false, 1, 25, new Object[]{this.getMessage()}, "Driver's License Number");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Copy Auto Ins");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Auto Ins. Expires");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Date Last DMV Review");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Date Next DMV Review");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating STF - this is probably a bug in the source code generator.", e);
        }
    }

    public CE getSTFPrimaryKeyValue() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getStf1_STFPrimaryKeyValue() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE[] getStaffIDCode() {
        CE[] retVal = (CE[])this.getTypedField(2, new CE[0]);
        return retVal;
    }

    public CE[] getStf2_StaffIDCode() {
        CE[] retVal = (CE[])this.getTypedField(2, new CE[0]);
        return retVal;
    }

    public int getStaffIDCodeReps() {
        return this.getReps(2);
    }

    public CE getStaffIDCode(int rep) {
        CE retVal = (CE)this.getTypedField(2, rep);
        return retVal;
    }

    public CE getStf2_StaffIDCode(int rep) {
        CE retVal = (CE)this.getTypedField(2, rep);
        return retVal;
    }

    public int getStf2_StaffIDCodeReps() {
        return this.getReps(2);
    }

    public CE insertStaffIDCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(2, rep);
    }

    public CE insertStf2_StaffIDCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(2, rep);
    }

    public CE removeStaffIDCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(2, rep);
    }

    public CE removeStf2_StaffIDCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(2, rep);
    }

    public XPN getStaffName() {
        XPN retVal = (XPN)this.getTypedField(3, 0);
        return retVal;
    }

    public XPN getStf3_StaffName() {
        XPN retVal = (XPN)this.getTypedField(3, 0);
        return retVal;
    }

    public ID[] getStaffType() {
        ID[] retVal = (ID[])this.getTypedField(4, new ID[0]);
        return retVal;
    }

    public ID[] getStf4_StaffType() {
        ID[] retVal = (ID[])this.getTypedField(4, new ID[0]);
        return retVal;
    }

    public int getStaffTypeReps() {
        return this.getReps(4);
    }

    public ID getStaffType(int rep) {
        ID retVal = (ID)this.getTypedField(4, rep);
        return retVal;
    }

    public ID getStf4_StaffType(int rep) {
        ID retVal = (ID)this.getTypedField(4, rep);
        return retVal;
    }

    public int getStf4_StaffTypeReps() {
        return this.getReps(4);
    }

    public ID insertStaffType(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(4, rep);
    }

    public ID insertStf4_StaffType(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(4, rep);
    }

    public ID removeStaffType(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(4, rep);
    }

    public ID removeStf4_StaffType(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(4, rep);
    }

    public IS getSex() {
        IS retVal = (IS)this.getTypedField(5, 0);
        return retVal;
    }

    public IS getStf5_Sex() {
        IS retVal = (IS)this.getTypedField(5, 0);
        return retVal;
    }

    public TS getDateOfBirth() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getStf6_DateOfBirth() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getActiveInactiveFlag() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    public ID getStf7_ActiveInactiveFlag() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    public CE[] getDepartment() {
        CE[] retVal = (CE[])this.getTypedField(8, new CE[0]);
        return retVal;
    }

    public CE[] getStf8_Department() {
        CE[] retVal = (CE[])this.getTypedField(8, new CE[0]);
        return retVal;
    }

    public int getDepartmentReps() {
        return this.getReps(8);
    }

    public CE getDepartment(int rep) {
        CE retVal = (CE)this.getTypedField(8, rep);
        return retVal;
    }

    public CE getStf8_Department(int rep) {
        CE retVal = (CE)this.getTypedField(8, rep);
        return retVal;
    }

    public int getStf8_DepartmentReps() {
        return this.getReps(8);
    }

    public CE insertDepartment(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(8, rep);
    }

    public CE insertStf8_Department(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(8, rep);
    }

    public CE removeDepartment(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(8, rep);
    }

    public CE removeStf8_Department(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(8, rep);
    }

    public CE[] getService() {
        CE[] retVal = (CE[])this.getTypedField(9, new CE[0]);
        return retVal;
    }

    public CE[] getStf9_Service() {
        CE[] retVal = (CE[])this.getTypedField(9, new CE[0]);
        return retVal;
    }

    public int getServiceReps() {
        return this.getReps(9);
    }

    public CE getService(int rep) {
        CE retVal = (CE)this.getTypedField(9, rep);
        return retVal;
    }

    public CE getStf9_Service(int rep) {
        CE retVal = (CE)this.getTypedField(9, rep);
        return retVal;
    }

    public int getStf9_ServiceReps() {
        return this.getReps(9);
    }

    public CE insertService(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(9, rep);
    }

    public CE insertStf9_Service(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(9, rep);
    }

    public CE removeService(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(9, rep);
    }

    public CE removeStf9_Service(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(9, rep);
    }

    public XTN[] getPhone() {
        XTN[] retVal = (XTN[])this.getTypedField(10, new XTN[0]);
        return retVal;
    }

    public XTN[] getStf10_Phone() {
        XTN[] retVal = (XTN[])this.getTypedField(10, new XTN[0]);
        return retVal;
    }

    public int getPhoneReps() {
        return this.getReps(10);
    }

    public XTN getPhone(int rep) {
        XTN retVal = (XTN)this.getTypedField(10, rep);
        return retVal;
    }

    public XTN getStf10_Phone(int rep) {
        XTN retVal = (XTN)this.getTypedField(10, rep);
        return retVal;
    }

    public int getStf10_PhoneReps() {
        return this.getReps(10);
    }

    public XTN insertPhone(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(10, rep);
    }

    public XTN insertStf10_Phone(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(10, rep);
    }

    public XTN removePhone(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(10, rep);
    }

    public XTN removeStf10_Phone(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(10, rep);
    }

    public AD[] getOfficeHomeAddress() {
        AD[] retVal = (AD[])this.getTypedField(11, new AD[0]);
        return retVal;
    }

    public AD[] getStf11_OfficeHomeAddress() {
        AD[] retVal = (AD[])this.getTypedField(11, new AD[0]);
        return retVal;
    }

    public int getOfficeHomeAddressReps() {
        return this.getReps(11);
    }

    public AD getOfficeHomeAddress(int rep) {
        AD retVal = (AD)this.getTypedField(11, rep);
        return retVal;
    }

    public AD getStf11_OfficeHomeAddress(int rep) {
        AD retVal = (AD)this.getTypedField(11, rep);
        return retVal;
    }

    public int getStf11_OfficeHomeAddressReps() {
        return this.getReps(11);
    }

    public AD insertOfficeHomeAddress(int rep) throws HL7Exception {
        return (AD)super.insertRepetition(11, rep);
    }

    public AD insertStf11_OfficeHomeAddress(int rep) throws HL7Exception {
        return (AD)super.insertRepetition(11, rep);
    }

    public AD removeOfficeHomeAddress(int rep) throws HL7Exception {
        return (AD)super.removeRepetition(11, rep);
    }

    public AD removeStf11_OfficeHomeAddress(int rep) throws HL7Exception {
        return (AD)super.removeRepetition(11, rep);
    }

    public CM_DIN[] getActivationDate() {
        CM_DIN[] retVal = (CM_DIN[])this.getTypedField(12, new CM_DIN[0]);
        return retVal;
    }

    public CM_DIN[] getStf12_ActivationDate() {
        CM_DIN[] retVal = (CM_DIN[])this.getTypedField(12, new CM_DIN[0]);
        return retVal;
    }

    public int getActivationDateReps() {
        return this.getReps(12);
    }

    public CM_DIN getActivationDate(int rep) {
        CM_DIN retVal = (CM_DIN)this.getTypedField(12, rep);
        return retVal;
    }

    public CM_DIN getStf12_ActivationDate(int rep) {
        CM_DIN retVal = (CM_DIN)this.getTypedField(12, rep);
        return retVal;
    }

    public int getStf12_ActivationDateReps() {
        return this.getReps(12);
    }

    public CM_DIN insertActivationDate(int rep) throws HL7Exception {
        return (CM_DIN)super.insertRepetition(12, rep);
    }

    public CM_DIN insertStf12_ActivationDate(int rep) throws HL7Exception {
        return (CM_DIN)super.insertRepetition(12, rep);
    }

    public CM_DIN removeActivationDate(int rep) throws HL7Exception {
        return (CM_DIN)super.removeRepetition(12, rep);
    }

    public CM_DIN removeStf12_ActivationDate(int rep) throws HL7Exception {
        return (CM_DIN)super.removeRepetition(12, rep);
    }

    public CM_DIN[] getInactivationDate() {
        CM_DIN[] retVal = (CM_DIN[])this.getTypedField(13, new CM_DIN[0]);
        return retVal;
    }

    public CM_DIN[] getStf13_InactivationDate() {
        CM_DIN[] retVal = (CM_DIN[])this.getTypedField(13, new CM_DIN[0]);
        return retVal;
    }

    public int getInactivationDateReps() {
        return this.getReps(13);
    }

    public CM_DIN getInactivationDate(int rep) {
        CM_DIN retVal = (CM_DIN)this.getTypedField(13, rep);
        return retVal;
    }

    public CM_DIN getStf13_InactivationDate(int rep) {
        CM_DIN retVal = (CM_DIN)this.getTypedField(13, rep);
        return retVal;
    }

    public int getStf13_InactivationDateReps() {
        return this.getReps(13);
    }

    public CM_DIN insertInactivationDate(int rep) throws HL7Exception {
        return (CM_DIN)super.insertRepetition(13, rep);
    }

    public CM_DIN insertStf13_InactivationDate(int rep) throws HL7Exception {
        return (CM_DIN)super.insertRepetition(13, rep);
    }

    public CM_DIN removeInactivationDate(int rep) throws HL7Exception {
        return (CM_DIN)super.removeRepetition(13, rep);
    }

    public CM_DIN removeStf13_InactivationDate(int rep) throws HL7Exception {
        return (CM_DIN)super.removeRepetition(13, rep);
    }

    public CE[] getBackupPersonID() {
        CE[] retVal = (CE[])this.getTypedField(14, new CE[0]);
        return retVal;
    }

    public CE[] getStf14_BackupPersonID() {
        CE[] retVal = (CE[])this.getTypedField(14, new CE[0]);
        return retVal;
    }

    public int getBackupPersonIDReps() {
        return this.getReps(14);
    }

    public CE getBackupPersonID(int rep) {
        CE retVal = (CE)this.getTypedField(14, rep);
        return retVal;
    }

    public CE getStf14_BackupPersonID(int rep) {
        CE retVal = (CE)this.getTypedField(14, rep);
        return retVal;
    }

    public int getStf14_BackupPersonIDReps() {
        return this.getReps(14);
    }

    public CE insertBackupPersonID(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(14, rep);
    }

    public CE insertStf14_BackupPersonID(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(14, rep);
    }

    public CE removeBackupPersonID(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(14, rep);
    }

    public CE removeStf14_BackupPersonID(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(14, rep);
    }

    public ST[] getEMailAddress() {
        ST[] retVal = (ST[])this.getTypedField(15, new ST[0]);
        return retVal;
    }

    public ST[] getStf15_EMailAddress() {
        ST[] retVal = (ST[])this.getTypedField(15, new ST[0]);
        return retVal;
    }

    public int getEMailAddressReps() {
        return this.getReps(15);
    }

    public ST getEMailAddress(int rep) {
        ST retVal = (ST)this.getTypedField(15, rep);
        return retVal;
    }

    public ST getStf15_EMailAddress(int rep) {
        ST retVal = (ST)this.getTypedField(15, rep);
        return retVal;
    }

    public int getStf15_EMailAddressReps() {
        return this.getReps(15);
    }

    public ST insertEMailAddress(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(15, rep);
    }

    public ST insertStf15_EMailAddress(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(15, rep);
    }

    public ST removeEMailAddress(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(15, rep);
    }

    public ST removeStf15_EMailAddress(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(15, rep);
    }

    public CE getPreferredMethodOfContact() {
        CE retVal = (CE)this.getTypedField(16, 0);
        return retVal;
    }

    public CE getStf16_PreferredMethodOfContact() {
        CE retVal = (CE)this.getTypedField(16, 0);
        return retVal;
    }

    public IS[] getMaritalStatus() {
        IS[] retVal = (IS[])this.getTypedField(17, new IS[0]);
        return retVal;
    }

    public IS[] getStf17_MaritalStatus() {
        IS[] retVal = (IS[])this.getTypedField(17, new IS[0]);
        return retVal;
    }

    public int getMaritalStatusReps() {
        return this.getReps(17);
    }

    public IS getMaritalStatus(int rep) {
        IS retVal = (IS)this.getTypedField(17, rep);
        return retVal;
    }

    public IS getStf17_MaritalStatus(int rep) {
        IS retVal = (IS)this.getTypedField(17, rep);
        return retVal;
    }

    public int getStf17_MaritalStatusReps() {
        return this.getReps(17);
    }

    public IS insertMaritalStatus(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(17, rep);
    }

    public IS insertStf17_MaritalStatus(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(17, rep);
    }

    public IS removeMaritalStatus(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(17, rep);
    }

    public IS removeStf17_MaritalStatus(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(17, rep);
    }

    public ST getJobTitle() {
        ST retVal = (ST)this.getTypedField(18, 0);
        return retVal;
    }

    public ST getStf18_JobTitle() {
        ST retVal = (ST)this.getTypedField(18, 0);
        return retVal;
    }

    public JCC getJobCodeClass() {
        JCC retVal = (JCC)this.getTypedField(19, 0);
        return retVal;
    }

    public JCC getStf19_JobCodeClass() {
        JCC retVal = (JCC)this.getTypedField(19, 0);
        return retVal;
    }

    public IS getEmploymentStatus() {
        IS retVal = (IS)this.getTypedField(20, 0);
        return retVal;
    }

    public IS getStf20_EmploymentStatus() {
        IS retVal = (IS)this.getTypedField(20, 0);
        return retVal;
    }

    public ID getAdditionalInsuredOnAuto() {
        ID retVal = (ID)this.getTypedField(21, 0);
        return retVal;
    }

    public ID getStf21_AdditionalInsuredOnAuto() {
        ID retVal = (ID)this.getTypedField(21, 0);
        return retVal;
    }

    public DLN getDriverSLicenseNumber() {
        DLN retVal = (DLN)this.getTypedField(22, 0);
        return retVal;
    }

    public DLN getStf22_DriverSLicenseNumber() {
        DLN retVal = (DLN)this.getTypedField(22, 0);
        return retVal;
    }

    public ID getCopyAutoIns() {
        ID retVal = (ID)this.getTypedField(23, 0);
        return retVal;
    }

    public ID getStf23_CopyAutoIns() {
        ID retVal = (ID)this.getTypedField(23, 0);
        return retVal;
    }

    public DT getAutoInsExpires() {
        DT retVal = (DT)this.getTypedField(24, 0);
        return retVal;
    }

    public DT getStf24_AutoInsExpires() {
        DT retVal = (DT)this.getTypedField(24, 0);
        return retVal;
    }

    public DT getDateLastDMVReview() {
        DT retVal = (DT)this.getTypedField(25, 0);
        return retVal;
    }

    public DT getStf25_DateLastDMVReview() {
        DT retVal = (DT)this.getTypedField(25, 0);
        return retVal;
    }

    public DT getDateNextDMVReview() {
        DT retVal = (DT)this.getTypedField(26, 0);
        return retVal;
    }

    public DT getStf26_DateNextDMVReview() {
        DT retVal = (DT)this.getTypedField(26, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new XPN(this.getMessage());
            }
            case 3: {
                return new ID(this.getMessage(), new Integer(182));
            }
            case 4: {
                return new IS(this.getMessage(), new Integer(1));
            }
            case 5: {
                return new TS(this.getMessage());
            }
            case 6: {
                return new ID(this.getMessage(), new Integer(183));
            }
            case 7: {
                return new CE(this.getMessage());
            }
            case 8: {
                return new CE(this.getMessage());
            }
            case 9: {
                return new XTN(this.getMessage());
            }
            case 10: {
                return new AD(this.getMessage());
            }
            case 11: {
                return new CM_DIN(this.getMessage());
            }
            case 12: {
                return new CM_DIN(this.getMessage());
            }
            case 13: {
                return new CE(this.getMessage());
            }
            case 14: {
                return new ST(this.getMessage());
            }
            case 15: {
                return new CE(this.getMessage());
            }
            case 16: {
                return new IS(this.getMessage(), new Integer(2));
            }
            case 17: {
                return new ST(this.getMessage());
            }
            case 18: {
                return new JCC(this.getMessage());
            }
            case 19: {
                return new IS(this.getMessage(), new Integer(66));
            }
            case 20: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 21: {
                return new DLN(this.getMessage());
            }
            case 22: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 23: {
                return new DT(this.getMessage());
            }
            case 24: {
                return new DT(this.getMessage());
            }
            case 25: {
                return new DT(this.getMessage());
            }
        }
        return null;
    }
}

