/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.EI;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.TS;
import ca.uhn.hl7v2.model.v23.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ROL
extends AbstractSegment {
    public ROL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, true, 1, 60, new Object[]{this.getMessage()}, "Role Instance ID");
            this.add(ID.class, true, 1, 2, new Object[]{this.getMessage(), new Integer(287)}, "Action Code");
            this.add(CE.class, false, 1, 0, new Object[]{this.getMessage()}, "Role");
            this.add(XCN.class, true, 1, 80, new Object[]{this.getMessage()}, "Role Person");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Role Begin Date/Time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Role End Date/Time");
            this.add(CE.class, false, 1, 80, new Object[]{this.getMessage()}, "Role Duration");
            this.add(CE.class, false, 1, 80, new Object[]{this.getMessage()}, "Role Action (Assumption) Reason");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ROL - this is probably a bug in the source code generator.", e);
        }
    }

    public EI getRoleInstanceID() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getRol1_RoleInstanceID() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getRol2_ActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getRole() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getRol3_Role() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public XCN getRolePerson() {
        XCN retVal = (XCN)this.getTypedField(4, 0);
        return retVal;
    }

    public XCN getRol4_RolePerson() {
        XCN retVal = (XCN)this.getTypedField(4, 0);
        return retVal;
    }

    public TS getRoleBeginDateTime() {
        TS retVal = (TS)this.getTypedField(5, 0);
        return retVal;
    }

    public TS getRol5_RoleBeginDateTime() {
        TS retVal = (TS)this.getTypedField(5, 0);
        return retVal;
    }

    public TS getRoleEndDateTime() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getRol6_RoleEndDateTime() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getRoleDuration() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getRol7_RoleDuration() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getRoleActionAssumptionReason() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public CE getRol8_RoleActionAssumptionReason() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(287));
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new XCN(this.getMessage());
            }
            case 4: {
                return new TS(this.getMessage());
            }
            case 5: {
                return new TS(this.getMessage());
            }
            case 6: {
                return new CE(this.getMessage());
            }
            case 7: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

