/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.app.AcceptorThread;
import ca.uhn.hl7v2.app.ActiveConnection;
import ca.uhn.hl7v2.app.HL7Service;
import ca.uhn.hl7v2.concurrent.DefaultExecutorService;
import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import ca.uhn.hl7v2.llp.MinLowerLayerProtocol;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.util.SocketFactory;
import java.io.File;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleServer
extends HL7Service {
    public static final int SO_TIMEOUT = 500;
    private static final Logger log = LoggerFactory.getLogger(SimpleServer.class);
    private int port;
    private boolean tls;
    private final BlockingQueue<AcceptorThread.AcceptedSocket> queue;
    private AcceptorThread acceptor;
    private HapiContext hapiContext;

    public SimpleServer(int port) {
        this(port, new MinLowerLayerProtocol(), new PipeParser(), false);
    }

    public SimpleServer(int port, boolean tls) {
        this(port, new MinLowerLayerProtocol(), new PipeParser(), tls);
    }

    public SimpleServer(int port, LowerLayerProtocol llp, Parser parser) {
        this(port, llp, parser, false);
    }

    public SimpleServer(int port, LowerLayerProtocol llp, Parser parser, boolean tls) {
        this(port, llp, parser, tls, DefaultExecutorService.getDefaultService());
    }

    public SimpleServer(int port, LowerLayerProtocol llp, Parser parser, boolean tls, ExecutorService executorService) {
        super(parser, llp, executorService);
        this.port = port;
        this.tls = tls;
        this.hapiContext = new DefaultHapiContext();
        this.queue = new LinkedBlockingQueue<AcceptorThread.AcceptedSocket>(100);
    }

    public SimpleServer(HapiContext hapiContext, int port, boolean tls) {
        super(hapiContext);
        this.hapiContext = hapiContext;
        this.port = port;
        this.tls = tls;
        this.queue = new LinkedBlockingQueue<AcceptorThread.AcceptedSocket>(100);
    }

    @Override
    protected void afterStartup() {
        try {
            super.afterStartup();
            log.info("Starting SimpleServer running on port {}", (Object)this.port);
            SocketFactory ss = this.hapiContext.getSocketFactory();
            this.acceptor = new AcceptorThread(this.port, this.tls, this.getExecutorService(), this.queue, ss);
            this.acceptor.start();
        }
        catch (Exception e) {
            log.error("Failed starting SimpleServer on port", (Object)this.port);
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void handle() {
        if (this.acceptor.getServiceExitedWithException() != null) {
            this.setServiceExitedWithException(this.acceptor.getServiceExitedWithException());
        }
        try {
            AcceptorThread.AcceptedSocket newSocket = this.queue.poll(500L, TimeUnit.MILLISECONDS);
            if (newSocket != null) {
                log.info("Accepted connection from {}:{} on local port {}", newSocket.socket.getInetAddress().getHostAddress(), newSocket.socket.getPort(), this.port);
                ActiveConnection c = new ActiveConnection(this.getParser(), this.getLlp(), newSocket.socket, this.getExecutorService());
                this.newConnection(c);
            }
        }
        catch (InterruptedException newSocket) {
        }
        catch (Exception e) {
            log.error("Error while accepting connections: ", e);
        }
    }

    @Override
    protected void afterTermination() {
        super.afterTermination();
        this.acceptor.stop();
    }

    public static void main(String[] args) {
        if (args.length < 1 || args.length > 2) {
            System.out.println("Usage: ca.uhn.hl7v2.app.SimpleServer port_num [application_spec_file_name]");
            System.exit(1);
        }
        int port = 0;
        try {
            port = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            System.err.println("The given port (" + args[0] + ") is not an integer.");
            System.exit(1);
        }
        File appFile = null;
        if (args.length == 2) {
            appFile = new File(args[1]);
        }
        try {
            SimpleServer server = new SimpleServer(port);
            if (appFile != null) {
                server.loadApplicationsFromFile(appFile);
            }
            server.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

