/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.date;

import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.LocaleSource;
import ca.infodata.util1.date.PerThreadLocaleStrategy;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LocaleProvider {
    private static final Logger logger = Logger.getLogger(LocaleProvider.class.getName());
    public static final Locale FRENCH = Locale.FRENCH;
    public static final Locale ENGLISH = Locale.ENGLISH;
    public static final Locale SPANISH = new Locale("es");
    private static LocaleSource localeSource = new PerThreadLocaleStrategy();

    private LocaleProvider() {
        throw new UnsupportedOperationException();
    }

    public static synchronized void setLocaleSource(LocaleSource source) {
        if (source == null) {
            throw new IllegalArgumentException("source is null");
        }
        localeSource = source;
    }

    public static Locale getLocale() {
        return localeSource.get();
    }

    public static void setLocale(Locale locale) {
        if (!LocaleProvider.isSupported(locale)) {
            logger.log(Level.WARNING, "locale " + locale + " is not supported. Use default french locale");
            locale = Locale.FRENCH;
        }
        localeSource.set(locale);
    }

    public static void setLocale(String nl) {
        Locale locale = DateUtil.parseLocale(nl);
        if (locale == null) {
            logger.log(Level.WARNING, nl + " is not a valid locale");
        }
        LocaleProvider.setLocale(locale);
    }

    public static boolean isSupported(Locale locale) {
        return locale != null && (LocaleProvider.isFrench(locale) || LocaleProvider.isEnglish(locale) || LocaleProvider.isSpanish(locale));
    }

    public static boolean isSpanish(Locale locale) {
        return locale != null && locale.getLanguage().equalsIgnoreCase("es");
    }

    public static boolean isEnglish(Locale locale) {
        return locale != null && locale.getLanguage().equalsIgnoreCase(Locale.ENGLISH.getLanguage());
    }

    public static boolean isFrench(Locale locale) {
        return locale != null && locale.getLanguage().equalsIgnoreCase(Locale.FRENCH.getLanguage());
    }

    public static boolean isEnglish() {
        return LocaleProvider.isEnglish(LocaleProvider.getLocale());
    }

    public static boolean isSpanish() {
        return LocaleProvider.isSpanish(LocaleProvider.getLocale());
    }

    public static boolean isFrench() {
        return LocaleProvider.isFrench(LocaleProvider.getLocale());
    }

    public static void reset() {
        localeSource.reset();
    }
}

