/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.date;

import ca.infodata.util1.date.LocaleProvider;
import ca.infodata.util1.date.TimeSource;
import java.util.Calendar;
import java.util.TimeZone;

public final class BrokenClock
implements TimeSource {
    private final long timeInMillis;
    private final TimeZone utc = TimeZone.getTimeZone("GMT");

    public BrokenClock(int dayFrom1970) {
        Calendar c = Calendar.getInstance(this.utc, LocaleProvider.getLocale());
        c.clear();
        c.setTimeZone(this.utc);
        c.add(5, dayFrom1970);
        this.timeInMillis = c.getTimeInMillis();
    }

    public BrokenClock(int day, int month, int year, int hour, int minute) {
        Calendar c = Calendar.getInstance(this.utc, LocaleProvider.getLocale());
        c.clear();
        c.setTimeZone(this.utc);
        c.set(5, day);
        c.set(2, month - 1);
        c.set(1, year);
        c.set(11, hour);
        c.set(12, minute);
        this.timeInMillis = c.getTimeInMillis();
    }

    public BrokenClock(long timeInMillis) {
        this.timeInMillis = timeInMillis;
    }

    @Override
    public long currentTimeInMillis() {
        return this.timeInMillis;
    }
}

