/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ByteSerialiser {
    private static final Logger logger = Logger.getLogger(ByteSerialiser.class.getName());

    public static <T> T clone(T t) {
        if (t == null) {
            return null;
        }
        Object t2 = null;
        try {
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(fos);
            out.writeObject(t);
            byte[] bytes = fos.toByteArray();
            out.close();
            fos.close();
            ByteArrayInputStream fis = new ByteArrayInputStream(bytes);
            ObjectInputStream in = new ObjectInputStream(fis);
            in.readObject();
            t2 = in.readObject();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Failed to serialize-clone object " + t, ex);
        }
        return (T)t2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(Object object, OutputStream fos) {
        ObjectOutputStream out = null;
        ZipOutputStream zip = null;
        try {
            zip = new ZipOutputStream(fos);
            zip.putNextEntry(new ZipEntry("default"));
            out = new ObjectOutputStream(zip);
            out.writeObject(object);
            zip.closeEntry();
            out.close();
            zip.close();
            fos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (zip != null) {
                    zip.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserialize(InputStream fis) {
        Object ret = null;
        if (fis != null) {
            ZipInputStream zip = null;
            ObjectInputStream in = null;
            try {
                zip = new ZipInputStream(fis);
                zip.getNextEntry();
                in = new ObjectInputStream(zip);
                ret = in.readObject();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (zip != null) {
                        zip.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    public static byte[] serialize(Object object) {
        return ByteSerialiser.serialize(object, true);
    }

    public static byte[] serialize(Object object, boolean compress) {
        if (compress) {
            return ByteSerialiser.serializeNZip(object);
        }
        return ByteSerialiser.serializePlain(object);
    }

    private static byte[] serializePlain(Object object) {
        byte[] bytes = new byte[]{};
        try {
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            ByteSerialiser.serializePlain(object, fos);
            bytes = fos.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void serializePlain(Object object, OutputStream fos) {
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(fos);
            out.writeObject(object);
            out.close();
            fos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static byte[] serializeNZip(Object object) {
        byte[] bytes = new byte[]{};
        try {
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            ByteSerialiser.serializeNZip(object, fos);
            bytes = fos.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void serializeNZip(Object object, OutputStream fos) {
        ObjectOutputStream out = null;
        ZipOutputStream zip = null;
        try {
            zip = new ZipOutputStream(fos);
            zip.putNextEntry(new ZipEntry("default"));
            out = new ObjectOutputStream(zip);
            out.writeObject(object);
            zip.closeEntry();
            out.close();
            zip.close();
            fos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (zip != null) {
                    zip.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Object deserialize(byte[] object) {
        return ByteSerialiser.deserialize(object, true);
    }

    public static Object deserialize(byte[] object, boolean wasCompressed) {
        if (wasCompressed) {
            return ByteSerialiser.deserializeZipped(object);
        }
        return ByteSerialiser.deserializePlain(object);
    }

    public static Object deserializePlain(byte[] object) {
        if (object == null) {
            return null;
        }
        try {
            return ByteSerialiser.deserializePlain(new ByteArrayInputStream(object));
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object deserializePlain(InputStream fis) {
        Object ret = null;
        if (fis != null) {
            ObjectInputStream in = null;
            try {
                in = new ObjectInputStream(fis);
                ret = in.readObject();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object deserializeZipped(byte[] object) {
        Object ret = null;
        if (object != null) {
            ByteArrayInputStream fis = null;
            ZipInputStream zip = null;
            ObjectInputStream in = null;
            try {
                fis = new ByteArrayInputStream(object);
                zip = new ZipInputStream(fis);
                zip.getNextEntry();
                in = new ObjectInputStream(zip);
                ret = in.readObject();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (zip != null) {
                        zip.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }
}

