/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.preferences;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.PreferencesAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.EventLockCallback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XRight;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.ui.controls.BaseMultiEditor;
import ca.infodata.ofys.ui.controls.BaseSubEditor;
import ca.infodata.ofys.ui.controls.FontAwareGroup;
import ca.infodata.ofys.ui.controls.MyMessageDialogBuilder;
import ca.infodata.ofys.ui.controls.MySubProgressMonitor;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.util.MyDialogSettings;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.file.ReadExcelFile;
import ca.infodata.ofys.ui.preferences.ExportPatientCallback;
import ca.infodata.ofys.ui.preferences.ExportPatientClinicDataCallback;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.ClosureAR;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.Section;

public class ImportExportPreferencesEditor
extends BaseSubEditor {
    private static final String EXPORTATION_DE_LISTES_DE_PATIENTS = Messages.getString((String)"BaseGmfPreferencesEditor.EXPORTATION_DE_LISTES_DE_PATIENTS", (String[])new String[0]);
    private static final String EMPLACEMENT_DE_LEXPORTATION = Messages.getString((String)"BaseGmfPreferencesEditor.EMPLACEMENT_DE_LEXPORTATION", (String[])new String[0]);
    private static final String EXPORTATION = Messages.getString((String)"BaseGmfPreferencesEditor.EXPORTATION", (String[])new String[0]);
    private static final String LANCER_LEXPORTATION = Messages.getString((String)"BaseGmfPreferencesEditor.LANCER_LEXPORTATION", (String[])new String[0]);
    private static final String LANCER_LIMPORTATION = Messages.getString((String)"BaseGmfPreferencesEditor.LANCER_LIMPORTATION", (String[])new String[0]);
    private static final String CHOSE = Messages.getString((String)"BackupControl.CHOISIR", (String[])new String[0]);
    private static final String AUTO_OPEN_FILE = Messages.getString((String)"BaseGMFPreferencesControl.AUTO_OPEN_FILE", (String[])new String[0]);
    private static final char pointVirgule = ';';
    private static final char virgule = ',';
    private static final char tab = '\t';
    private static final String LANCER_LEXPORTATION_DES_DONNEES_CLINIQUES = Messages.getString((String)"BaseGmfPreferencesEditor.LANCER_LEXPORTATION_DES_DONNEES_CLINIQUES", (String[])new String[0]);
    private MyButton chkAutoOpenExportFile;
    private FontAwareGroup grpSeparator;
    private MyButton btnPointVirgule;
    private MyButton btnTab;
    private MyButton btnVirgule;
    private MyLabel lblPathLabel;
    private MyLabel lblPathForExport;
    private MyButton btnChoosePath;
    private MyLabel lblexportPatient;
    private MyButton cmdExporterPatient;
    private MyButton cmdExporterPatientClinicData;
    private MyButton cmdImporterPatient;
    private boolean autoOpenExportFile = false;
    private char columnDelimiter = (char)44;
    private String filePath;

    public ImportExportPreferencesEditor() {
    }

    public ImportExportPreferencesEditor(BaseMultiEditor parentEditor) {
        super(parentEditor);
    }

    public void createMyControl(Composite parent) {
        this.toolkit.adapt(parent);
        this.setTitleImage(ResourceGetter.getImage((String)"images/Heart-icon32.png"));
        Section sectionExportPatient = this.toolkit.createSection(parent, 0);
        sectionExportPatient.setText(EXPORTATION_DE_LISTES_DE_PATIENTS);
        this.toolkit.createCompositeSeparator((Composite)sectionExportPatient);
        this.lblPathLabel = new MyLabel(parent, EMPLACEMENT_DE_LEXPORTATION, 0, this.toolkit);
        this.lblPathForExport = new MyLabel(parent, ExportPatientCallback.DEFAULT_PATH, 0, this.toolkit);
        this.btnChoosePath = new MyButton(parent, CHOSE, 8, this.toolkit);
        this.chkAutoOpenExportFile = new MyButton(parent, AUTO_OPEN_FILE, 32, this.toolkit);
        this.grpSeparator = new FontAwareGroup(parent, 0, this.toolkit);
        this.grpSeparator.setText("Separateur de champs");
        this.grpSeparator.setLayout((Layout)new FormLayout());
        this.btnVirgule = new MyButton((Composite)this.grpSeparator, "Virgule", 16, this.toolkit);
        this.btnPointVirgule = new MyButton((Composite)this.grpSeparator, "Point-virgule", 16, this.toolkit);
        this.btnTab = new MyButton((Composite)this.grpSeparator, "Tab", 16, this.toolkit);
        this.btnVirgule.setSelection(true);
        this.lblexportPatient = new MyLabel(parent, EXPORTATION, 0, this.toolkit);
        this.cmdExporterPatient = new MyButton(parent, LANCER_LEXPORTATION, 8, this.toolkit);
        this.cmdExporterPatient.setVisible(Application.get().getGlobalInstances().hasRight(XRight.EXPORT_PATIENT));
        this.cmdExporterPatientClinicData = new MyButton(parent, LANCER_LEXPORTATION_DES_DONNEES_CLINIQUES, 8, this.toolkit);
        this.cmdExporterPatientClinicData.setVisible(Application.get().getGlobalInstances().hasRight(XRight.EXPORT_PATIENT));
        this.cmdImporterPatient = new MyButton(parent, LANCER_LIMPORTATION, 8, this.toolkit);
        this.cmdImporterPatient.setVisible(Application.get().getGlobalInstances().hasRight(XRight.IMPORT_PATIENT));
        FormLayout layout = new FormLayout();
        layout.marginWidth = 10;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(2);
        data.left = new FormAttachment(0);
        sectionExportPatient.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)sectionExportPatient);
        data.left = new FormAttachment(0);
        data.width = 250;
        this.lblPathLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblPathLabel.getControl(), 5);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.lblPathForExport.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblPathForExport.getControl());
        data.left = new FormAttachment(0);
        data.width = MyButton.getStandardButtonWidth() + 40;
        this.btnChoosePath.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.btnChoosePath.getControl());
        data.left = new FormAttachment(0);
        this.chkAutoOpenExportFile.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.chkAutoOpenExportFile.getControl(), 10);
        data.left = new FormAttachment(0);
        data.width = 200;
        this.grpSeparator.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        this.btnVirgule.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.btnVirgule.getControl());
        data.left = new FormAttachment(0);
        this.btnPointVirgule.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.btnPointVirgule.getControl());
        data.left = new FormAttachment(0);
        this.btnTab.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.grpSeparator, 20);
        data.left = new FormAttachment(0);
        this.lblexportPatient.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblexportPatient.getControl());
        data.left = new FormAttachment(0);
        data.width = MyButton.getStandardButtonWidth() + 40;
        this.cmdExporterPatient.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.cmdExporterPatient.getControl());
        data.left = new FormAttachment(0);
        this.cmdExporterPatientClinicData.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblexportPatient.getControl());
        data.left = new FormAttachment(this.cmdExporterPatient.getControl(), 10);
        this.cmdImporterPatient.setLayoutData((Object)data);
        this.bindValues();
    }

    private void bindValues() {
        this.cmdExporterPatient.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExportPreferencesEditor.this.exportPatient();
            }
        });
        this.cmdExporterPatientClinicData.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExportPreferencesEditor.this.exportPatientClinicData();
            }
        });
        this.cmdImporterPatient.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExportPreferencesEditor.this.importPatientFromXLS();
            }
        });
        this.btnChoosePath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ImportExportPreferencesEditor.this.filePath = ImportExportPreferencesEditor.this.choosePath();
                ImportExportPreferencesEditor.this.lblPathForExport.setText(ImportExportPreferencesEditor.this.filePath);
            }
        });
        this.btnPointVirgule.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ImportExportPreferencesEditor.this.columnDelimiter = ';';
            }
        });
        this.btnTab.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ImportExportPreferencesEditor.this.columnDelimiter = '\t';
            }
        });
        this.btnVirgule.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ImportExportPreferencesEditor.this.columnDelimiter = ',';
            }
        });
        this.chkAutoOpenExportFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ImportExportPreferencesEditor.this.autoOpenExportFile = ImportExportPreferencesEditor.this.chkAutoOpenExportFile.getSelection();
            }
        });
    }

    protected void importPatientFromXLS() {
        PreferencesAccessorClient instance;
        MyDialogSettings ds = new MyDialogSettings(".import", "patientsFromXLS");
        try {
            instance = PreferencesAccessorClient.getInstance();
        }
        catch (CannotConnectToServerException cannotConnectToServerException) {
            MessageUtil.cannotConnectToServerExceptionMsg((Shell)this.getSite().getShell());
            return;
        }
        MessageUtil.infoMsg((Shell)this.getSite().getShell(), (String)"Le fichier .xsl doit preciser le nom des colonnes, le nom des colonnes doivent etre les suivants : \nfullname,firstname,lastname,hin,hinexp,recordnumber,birthdate,sexe,note,addstreet,addcity,addcountry,addprovince,addpostalcode,addnote,phone1,phone2\nL'ordre des colonnes n'est pas important. ");
        FileDialog fileDialog = new FileDialog(this.getSite().getShell());
        fileDialog.setFilterExtensions(new String[]{"*.xls"});
        String fileName = fileDialog.open();
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return;
        }
        try {
            List temp = ReadExcelFile.readFileAsString((String)fileName);
            final ArrayList<Item> items = new ArrayList<Item>(temp.size());
            int i = 0;
            while (i < temp.size()) {
                Item item = new Item();
                item.data = (Map)temp.get(i);
                item.index = String.valueOf(i);
                item.data.put("index", item.index);
                items.add(item);
                ++i;
            }
            if (ds.get(fileName) != null) {
                if (ds.get(fileName).equals("done")) {
                    MessageUtil.askQuestion((Shell)this.getSite().getShell(), (String)"Already imported, do you want to reimport");
                } else {
                    MyMessageDialogBuilder builder = new MyMessageDialogBuilder();
                    builder.useQuestionBundle();
                    builder.setMessage("Already imported, but some record failed.\nWhat do you want to do ?");
                    builder.setButtonLabels(new String[]{"Reimport all", "Reimport only failed"});
                    if (builder.buildAndOpen() == 1) {
                        String value = ds.get(fileName);
                        List indexes = MiscUtil.asList((Object[])value.split(","));
                        Iterator iterator = items.iterator();
                        while (iterator.hasNext()) {
                            if (indexes.contains(((Item)iterator.next()).index)) continue;
                            iterator.remove();
                        }
                    }
                }
            }
            final HashMap failedItems = new HashMap();
            final List items2 = MiscUtil.split((int)100, items);
            if (MessageUtil.askAreYouSure((Shell)this.getSite().getShell())) {
                MyMessageDialogBuilder builder = new MyMessageDialogBuilder();
                builder.useQuestionBundle();
                builder.setMessage("Que faire si le patient existe deja (base sur le nam) ?");
                builder.setButtonLabels(new String[]{"Mettre a jour", "Passer outre"});
                final String update = builder.buildAndOpen() == 0 ? "true" : "false";
                ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getSite().getShell());
                progressMonitorDialog.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        int size = items.size();
                        monitor.beginTask("Importation de " + size + " patients", size);
                        int count = 0;
                        for (List list : items2) {
                            ++count;
                            if (monitor.isCanceled()) continue;
                            final MySubProgressMonitor monitor2 = new MySubProgressMonitor(monitor, list.size());
                            monitor2.beginTask("Importation du lot " + count + " de " + items2.size(), 1);
                            HashMap<String, Object> taskParameters = new HashMap<String, Object>();
                            ArrayList list2 = MiscUtil.map((Collection)list, (ClosureAR)new ClosureAR<Item, Map<String, String>>(){

                                public Map<String, String> execute(Item input) {
                                    return input.data;
                                }
                            });
                            taskParameters.put("data", list2);
                            taskParameters.put("update", update);
                            EventLockCallback callback = new EventLockCallback((IStatusHandler)DefaultStatusHandler.getInstance()){

                                public void responseOverride(ReturnObject response) {
                                    monitor2.done();
                                    IStatus status = (IStatus)response.getObj();
                                    Map data = (Map)((Object)status.getData());
                                    if (data != null) {
                                        System.out.println(String.valueOf(data.size()) + " failed items");
                                        failedItems.putAll(data);
                                    }
                                    System.out.println("finished batch");
                                }
                            };
                            instance.executeTask("import", taskParameters, Application.get().getGlobalInstances().getSession(), (ICallback)callback);
                            callback.getLock().waitUntilEvent();
                        }
                    }
                });
                if (failedItems.isEmpty()) {
                    ds.put(fileName, "done");
                    ds.save();
                    MessageUtil.infoMsg((Shell)this.getSite().getShell(), (String)"Importation r\u00e9ussie !");
                } else if (failedItems.size() > 0) {
                    String value = new JoinList(",", failedItems.keySet()).toString();
                    ds.put(fileName, value);
                    ds.save();
                    String msg = new JoinList("\n", new Object[]{failedItems}).toString();
                    MessageUtil.warningMsg((Shell)this.getSite().getShell(), (String)msg);
                }
            }
        }
        catch (Exception e) {
            MessageUtil.show((Shell)this.getSite().getShell(), (Exception)e);
            return;
        }
    }

    public static String parse(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        return s;
    }

    public static String toAlphanumeric(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder b = new StringBuilder(text.length());
        char[] charArray = text.toCharArray();
        int i = 0;
        while (i < charArray.length) {
            if (StringUtils.isAlphanumeric((char)charArray[i])) {
                b.append(charArray[i]);
            }
            ++i;
        }
        return b.toString();
    }

    public static String toNumeric(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder b = new StringBuilder(text.length());
        char[] charArray = text.toCharArray();
        int i = 0;
        while (i < charArray.length) {
            if (StringUtils.isAlphanumeric((char)charArray[i])) {
                b.append(charArray[i]);
            }
            ++i;
        }
        return b.toString();
    }

    private String choosePath() {
        DirectoryDialog win = new DirectoryDialog(this.getSite().getShell());
        String path = win.open();
        if (path == null) {
            path = this.filePath;
        }
        return path;
    }

    public void showDataObjectOverride() {
    }

    public void load() {
    }

    private void exportPatient() {
        try {
            ExportPatientCallback callback = new ExportPatientCallback();
            callback.setOpenGeneratedFile(this.autoOpenExportFile);
            callback.setFilePath(this.filePath);
            PreferencesAccessorClient.getInstance().exportPatients(this.columnDelimiter, Application.get().getGlobalInstances().getSession(), (ICallback)callback);
        }
        catch (CannotConnectToServerException cannotConnectToServerException) {
            MessageUtil.cannotConnectToServerExceptionMsg();
        }
    }

    private void exportPatientClinicData() {
        try {
            ExportPatientClinicDataCallback callback = new ExportPatientClinicDataCallback();
            callback.setOpenGeneratedFile(this.autoOpenExportFile);
            callback.setFilePath(this.filePath);
            PreferencesAccessorClient.getInstance().exportPatientsClinicDatas(this.columnDelimiter, Application.get().getGlobalInstances().getSession(), (ICallback)callback);
        }
        catch (CannotConnectToServerException cannotConnectToServerException) {
            MessageUtil.cannotConnectToServerExceptionMsg();
        }
    }

    private static class Item {
        Map<String, String> data;
        String index;

        private Item() {
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Item other = (Item)obj;
            return !(this.index == null ? other.index != null : !this.index.equals(other.index));
        }
    }
}

