/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.encounter.medication;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.EncounterAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XPrescriptionReportData;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescription;
import ca.infodata.ofys.data.middle.dataobjects.patient.XConsentement;
import ca.infodata.ofys.ui.controls.BaseMultiEditor;
import ca.infodata.ofys.ui.controls.BaseSubEditor;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.IPrintable;
import ca.infodata.ofys.ui.controls.calendarcombo.MyCalendarText;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.report2.PrintDialog2;
import ca.infodata.ofys.ui.encounter.medication.editor.ActivePrescriptionByGroupLabelProvider;
import ca.infodata.ofys.ui.encounter.medication.editor.InactivePrescriptionByGroupLabelProvider;
import ca.infodata.ofys.ui.encounter.medication.editor.PrescriptionByGroupContentProvider;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.ofys.ui.person.patient.PatientMultiEditor;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class OrdonnanceBrowserPatientSubEditor
extends BaseSubEditor
implements IPrintable {
    private static final String AFFICHER = Messages.getString((String)"OrdonnanceWebBrowserEditor.AFFICHER", (String[])new String[0]);
    private static final String DATE_FIN = Messages.getString((String)"OrdonnanceWebBrowserEditor.DATE_FIN", (String[])new String[0]);
    private static final String DATE_DEBUT = Messages.getString((String)"OrdonnanceWebBrowserEditor.DATE_DEBUT", (String[])new String[0]);
    private static final String MEDICATIONS_ACTIVES = Messages.getString((String)"MEDICATIONS_ACTIVES", (String[])new String[0]);
    private static final String MEDICATIONS_CESSEES = Messages.getString((String)"MEDICATIONS_CESSEES", (String[])new String[0]);
    private MyCalendarText txtDebut;
    private MyCalendarText txtFin;
    private MyButton btnShow;
    private MyLabel lblActiveMedication;
    private MyLabel lblInactiveMedication;
    private TreeViewer inactiveMedicationTree;
    private TreeViewer activeMedicationTree;
    private XPatient oldPatient;
    private ActivePrescriptionByGroupLabelProvider activePrescriptionByGroupLabelProvider;
    private InactivePrescriptionByGroupLabelProvider inactivePrescriptionByGroupLabelProvider;

    public OrdonnanceBrowserPatientSubEditor() {
    }

    public OrdonnanceBrowserPatientSubEditor(PatientMultiEditor parentEditor) {
        super((BaseMultiEditor)parentEditor);
    }

    public void createMyControl(Composite parent) {
        Composite upperSection = this.toolkit.createComposite(parent);
        MyLabel lblDebut = new MyLabel(upperSection, DATE_DEBUT, 0, this.toolkit);
        MyLabel lblFin = new MyLabel(upperSection, DATE_FIN, 0, this.toolkit);
        this.txtDebut = new MyCalendarText(upperSection, this.toolkit);
        this.txtDebut.setDate((IPartialDate)LocalDate.from((int)1, (int)1, (int)2000));
        this.txtFin = new MyCalendarText(upperSection, this.toolkit);
        this.txtFin.setDate((IPartialDate)LocalDate.today());
        this.btnShow = new MyButton(upperSection, AFFICHER, 8, this.toolkit);
        this.btnShow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OrdonnanceBrowserPatientSubEditor.this.search();
            }
        });
        Composite lowerSection = this.toolkit.createComposite(parent, 0);
        this.lblActiveMedication = new MyLabel(lowerSection, MEDICATIONS_ACTIVES, 0, this.toolkit);
        this.activeMedicationTree = new CheckboxTreeViewer(this.toolkit.createTree(lowerSection, 0));
        this.activeMedicationTree.getTree().setLinesVisible(false);
        this.activeMedicationTree.getTree().setHeaderVisible(false);
        this.activeMedicationTree.setContentProvider((IContentProvider)new PrescriptionByGroupContentProvider());
        this.activeMedicationTree.getTree().setFont(ResourceGetter.getFontNormal());
        UI.decorateTreeWithAutoAdjustColumnWidthToContent((Tree)this.activeMedicationTree.getTree());
        TreeViewerColumn c4 = new TreeViewerColumn(this.activeMedicationTree, 0);
        c4.getColumn().setMoveable(false);
        c4.getColumn().setWidth(1000);
        this.activePrescriptionByGroupLabelProvider = new ActivePrescriptionByGroupLabelProvider();
        c4.setLabelProvider((CellLabelProvider)this.activePrescriptionByGroupLabelProvider);
        this.lblInactiveMedication = new MyLabel(lowerSection, MEDICATIONS_CESSEES, 0, this.toolkit);
        this.inactiveMedicationTree = new CheckboxTreeViewer(this.toolkit.createTree(lowerSection, 0));
        this.inactiveMedicationTree.getTree().setLinesVisible(false);
        this.inactiveMedicationTree.getTree().setHeaderVisible(false);
        this.inactiveMedicationTree.setContentProvider((IContentProvider)new PrescriptionByGroupContentProvider());
        this.inactiveMedicationTree.getTree().setFont(ResourceGetter.getFontNormal());
        UI.decorateTreeWithAutoAdjustColumnWidthToContent((Tree)this.inactiveMedicationTree.getTree());
        TreeViewerColumn c5 = new TreeViewerColumn(this.inactiveMedicationTree, 0);
        c5.getColumn().setMoveable(false);
        c5.getColumn().setWidth(1000);
        this.inactivePrescriptionByGroupLabelProvider = new InactivePrescriptionByGroupLabelProvider();
        c5.setLabelProvider((CellLabelProvider)this.inactivePrescriptionByGroupLabelProvider);
        FormLayout layout2 = new FormLayout();
        layout2.spacing = 5;
        layout2.marginLeft = 10;
        layout2.marginRight = 10;
        layout2.marginTop = 10;
        layout2.marginBottom = 10;
        lowerSection.setLayout((Layout)layout2);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.lblActiveMedication.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblActiveMedication.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(49);
        this.activeMedicationTree.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.activeMedicationTree.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.lblInactiveMedication.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblInactiveMedication.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.inactiveMedicationTree.getControl().setLayoutData((Object)data);
        parent.setLayout((Layout)new FormLayout());
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        upperSection.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)upperSection);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100, -1);
        lowerSection.setLayoutData((Object)data);
        FormLayout layout1 = new FormLayout();
        layout1.spacing = 5;
        layout1.marginLeft = 10;
        layout1.marginRight = 10;
        layout1.marginTop = 10;
        layout1.marginBottom = 10;
        upperSection.setLayout((Layout)layout1);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        lblDebut.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(20);
        lblFin.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblDebut.getControl());
        data.left = new FormAttachment(0);
        this.txtDebut.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblDebut.getControl());
        data.left = new FormAttachment(20);
        this.txtFin.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblDebut.getControl());
        data.left = new FormAttachment(40);
        data.width = MyButton.getStandardButtonWidth();
        this.btnShow.setLayoutData((Object)data);
    }

    protected void search() {
        block5: {
            Integer patientId = this.getPatient().getId();
            if (patientId != null) {
                JobCallback callback = null;
                try {
                    callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                        public void responseReceived(final ReturnObject response) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!OrdonnanceBrowserPatientSubEditor.this.isDisposed()) {
                                        OrdonnanceBrowserPatientSubEditor.this.fill((List)response.getObj());
                                    }
                                }
                            });
                        }
                    };
                    EncounterAccessorClient.getInstance().findPrescriptionsByPatient(Application.get().getGlobalInstances().getSession(), (ICallback)callback, this.txtDebut.getDate(), this.txtFin.getDate(), patientId.intValue());
                }
                catch (CannotConnectToServerException cannotConnectToServerException) {
                    MessageUtil.cannotConnectToServerExceptionMsg();
                    this.fill(null);
                    if (callback != null && !callback.killed()) {
                        callback.kill();
                    }
                }
                catch (Exception e) {
                    this.fill(null);
                    Log.severe((Throwable)e);
                    if (callback == null || callback.killed()) break block5;
                    callback.kill();
                }
            }
        }
    }

    protected void fill(List<XPrescription> prescriptions) {
        ArrayList<XPrescription> actives = new ArrayList<XPrescription>();
        ArrayList<XPrescription> inactives = new ArrayList<XPrescription>();
        if (prescriptions != null) {
            for (XPrescription p : prescriptions) {
                if (Boolean.TRUE.equals(p.isActiveNow())) {
                    actives.add(p);
                    continue;
                }
                inactives.add(p);
            }
        }
        this.inactiveMedicationTree.setInput(inactives);
        this.activeMedicationTree.setInput(actives);
        UI.autoAdjustColumnWidthToContent((Tree)this.activeMedicationTree.getTree());
        UI.autoAdjustColumnWidthToContent((Tree)this.inactiveMedicationTree.getTree());
    }

    public void showDataObjectOverride() {
        XPatient patient = this.getPatient();
        if (this.oldPatient != patient) {
            this.oldPatient = patient;
            this.clear();
        }
        boolean enable = patient != null;
        boolean showDossierClinique = true;
        this.txtDebut.setEnabled(enable);
        this.txtFin.setEnabled(enable);
        this.btnShow.setEnabled(enable);
        if (enable) {
            if (patient != null) {
                boolean showToAll = true;
                XConsentement consent = null;
                Integer idUser = Application.get().getGlobalInstances().getSession().getUser().getId();
                if (patient.getConsentement() != null && patient.getConsentement().size() > 0) {
                    showToAll = false;
                    for (XConsentement consentement : patient.getConsentement()) {
                        if (!consentement.getIdUserAnchor().equals(idUser)) continue;
                        consent = consentement;
                        break;
                    }
                }
                boolean checkDroit = false;
                if (!showToAll && consent != null) {
                    checkDroit = true;
                }
                showDossierClinique = showToAll || checkDroit && consent.hasRightDossier();
            }
            this.btnShow.setVisible(showDossierClinique);
            this.activeMedicationTree.getTree().setVisible(showDossierClinique);
            this.inactiveMedicationTree.getTree().setVisible(showDossierClinique);
        }
    }

    private void clear() {
        this.txtDebut.setDate((IPartialDate)LocalDate.from((int)1, (int)1, (int)2000));
        this.txtFin.setDate((IPartialDate)LocalDate.today());
        this.activeMedicationTree.setInput(Collections.emptyList());
        this.inactiveMedicationTree.setInput(Collections.emptyList());
    }

    protected XPatient getPatient() {
        return (XPatient)((EditorInput)this.getEditorInput()).getCompleteDataObject();
    }

    public void load() {
    }

    public void print() {
        XPatient patient = this.getPatient();
        if (patient != null && patient.getId() != null) {
            XPrescriptionReportData data = new XPrescriptionReportData();
            data.setDateStart(this.txtDebut.getDate());
            data.setDateEnd(this.txtFin.getDate());
            data.setPatientId(patient.getId().intValue());
            PrintDialog2 dialog = new PrintDialog2(this.getSite().getShell(), (Serializable)data);
            dialog.open();
        }
    }

    public boolean isPrintAllowed() {
        XPatient patient = this.getPatient();
        return patient != null && patient.getId() != null;
    }
}

