/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.user;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.CompletionComboAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.UserAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseUser;
import ca.infodata.ofys.data.middle.dataobjects.XUserForSelection;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ICompletionComboItem;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.ui.controls.ControlDecorator;
import ca.infodata.ofys.ui.controls.IControl;
import ca.infodata.ofys.ui.controls.MyTableCombo;
import ca.infodata.ofys.ui.controls.MyTableComboDataAdapter;
import ca.infodata.ofys.ui.controls.ProviderAAR;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.user.NullXUserForSelection;
import ca.infodata.ofys.ui.site.SitePlugin;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class UserComboForSelection
implements IControl {
    private static final Logger logger = Logger.getLogger(UserComboForSelection.class.getName());
    private static final List<UserComboForSelection> instances = new CopyOnWriteArrayList<UserComboForSelection>();
    private static final CompletionComboAccessorClient.CompletionComboListener listener = new CompletionComboAccessorClient.CompletionComboListener(){
        private final Runnable refresh = new Runnable(){

            @Override
            public void run() {
                ArrayList<UserComboForSelection> toRemoveList = new ArrayList<UserComboForSelection>();
                for (UserComboForSelection combo : instances) {
                    if (combo == null || combo.getControl().isDisposed()) {
                        toRemoveList.add(combo);
                        continue;
                    }
                    combo.fill(true);
                }
                instances.removeAll(toRemoveList);
            }
        };

        public void shouldRefresh(ICompletionComboItem item) {
            Display.getDefault().asyncExec(this.refresh);
        }
    };
    private static final int STANDARD_TEXT_LIMIT = 100;
    private final NullXUserForSelection nullItem = new NullXUserForSelection();
    private MyTableComboDataAdapter<XUserForSelection> adapter;
    private MyTableCombo myTableCombo;
    private final Color green;
    private volatile boolean filling;
    private XUserForSelection fillSelection;

    static {
        CompletionComboAccessorClient.addListener((String)"user", (CompletionComboAccessorClient.CompletionComboListener)listener);
    }

    public UserComboForSelection(Composite parent, int style) {
        this.myTableCombo = new MyTableCombo(parent, style | 0x800);
        this.myTableCombo.setDisplayColumnIndex(0);
        this.myTableCombo.setVisibleItemCount(10);
        this.myTableCombo.setShowTableLines(true);
        this.myTableCombo.setShowTableHeader(true);
        this.myTableCombo.setShowColorWithinSelection(false);
        this.myTableCombo.setShowFontWithinSelection(false);
        this.myTableCombo.setShowImageWithinSelection(false);
        this.myTableCombo.setTextLimit(100);
        String helpText = "\u2193 et \u2191\t Naviguer dans la table (m\u00eame si la table est ferm\u00e9e) \nALT + \u2193\t Afficher ou fermer la table \nUne lettre\t S\u00e9lectionner le prochain utilisateur dont le nom commence par";
        ControlDecorator.decorateWithHelp((Control)this.myTableCombo, (String)helpText);
        this.green = ResourceGetter.getColor((int)204, (int)255, (int)204);
        ResourceGetter.linkResourceWithWidgetLife((Object)this.green, (Widget)this.myTableCombo);
        this.adapter = new MyTableComboDataAdapter(this.myTableCombo);
        this.adapter.addColumn(Messages.getString((String)"NOM", (String[])new String[0]));
        this.adapter.addColumn(Messages.getString((String)"TYPE", (String[])new String[0]));
        this.adapter.addColumn(Messages.getString((String)"SITE", (String[])new String[0]));
        this.adapter.addColumn(String.valueOf(Messages.getString((String)"ONLINE", (String[])new String[0])) + " ?", 0x1000000);
        this.adapter.setItemProvider((ProviderAAR)new ProviderAAR<XUserForSelection, Table, TableItem>(){

            public TableItem get(XUserForSelection user, Table table) {
                TableItem item = new TableItem(table, -1);
                if (user != null) {
                    item.setText(0, StringUtils.isBlank((CharSequence)user.personName) ? user.userName.toUpperCase() : user.personName);
                    item.setText(1, StringUtils.defaultString((String)user.personType));
                    XSite site = SitePlugin.getDefault().getSite(user.sessionSiteId);
                    if (site != null) {
                        item.setText(2, StringUtils.isBlank((CharSequence)site.getNameCommon()) ? site.getNameOfficial() : site.getNameCommon());
                    }
                    if (user.sessionIsActive) {
                        item.setText(3, "\u221a");
                        item.setBackground(UserComboForSelection.this.green);
                    }
                }
                return item;
            }
        });
        this.adapter.add((Object)this.nullItem);
        instances.add(this);
        this.myTableCombo.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                instances.remove(UserComboForSelection.this);
            }
        });
    }

    public void fill(boolean async) {
        if (async) {
            this.fillAsync();
        } else {
            this.fillSync();
        }
    }

    private void fillSync() {
        block4: {
            Callback callback = new Callback(){

                public void responseReceived(ReturnObject response) {
                    if (!UserComboForSelection.this.getControl().isDisposed()) {
                        UserComboForSelection.this.fill((List)response.getObj());
                    }
                }

                public void exception(Exception e) {
                    UserComboForSelection.this.filling = false;
                    super.exception(e);
                }
            };
            try {
                this.filling = true;
                UserAccessorClient.getInstance().listUsersForSelectionSync((ICallback)callback, Application.get().getGlobalInstances().getSession());
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                this.filling = false;
                MessageUtil.cannotConnectToServerExceptionMsg();
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
            }
            catch (Exception e) {
                this.filling = false;
                logger.log(Level.SEVERE, "failed to fill usercombo", e);
                if (callback == null || callback.killed()) break block4;
                callback.kill();
            }
        }
    }

    private void fillAsync() {
        block4: {
            System.out.println("UserComboForSelection.fillAsync()");
            JobCallback callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0])){

                public void responseReceived(final ReturnObject response) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!UserComboForSelection.this.getControl().isDisposed()) {
                                UserComboForSelection.this.fill((List)response.getObj());
                            }
                        }
                    });
                }

                public void exception(Exception e) {
                    UserComboForSelection.this.filling = false;
                    super.exception(e);
                }
            };
            try {
                this.filling = true;
                UserAccessorClient.getInstance().listUsersForSelection((ICallback)callback, Application.get().getGlobalInstances().getSession());
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                this.filling = false;
                MessageUtil.cannotConnectToServerExceptionMsg();
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
            }
            catch (Exception e) {
                this.filling = false;
                logger.log(Level.SEVERE, "failed to fill usercombo", e);
                if (callback == null || callback.killed()) break block4;
                callback.kill();
            }
        }
    }

    protected void fill(List<XUserForSelection> items) {
        System.out.println("UserComboForSelection.fill()");
        if (items != null) {
            Iterator<XUserForSelection> iterator = items.iterator();
            while (iterator.hasNext()) {
                XUserForSelection e = iterator.next();
                if (e.personId != null) continue;
                iterator.remove();
            }
            Collections.sort(items, new Comparator<XUserForSelection>(){

                @Override
                public int compare(XUserForSelection o1, XUserForSelection o2) {
                    if ("infodata".equalsIgnoreCase(o1.userName)) {
                        return 1;
                    }
                    if ("infodata".equalsIgnoreCase(o2.userName)) {
                        return -1;
                    }
                    if (o1.personName == null) {
                        return 1;
                    }
                    if (o2.personName == null) {
                        return -1;
                    }
                    return StringUtils.compareAscii((String)o1.personName, (String)o2.personName);
                }
            });
            items.add(0, this.nullItem);
            this.adapter.setItems(items);
            if (this.fillSelection != null && this.fillSelection != this.nullItem) {
                this.adapter.select((Object)this.fillSelection);
            }
        }
    }

    public MyTableCombo getControl() {
        return this.myTableCombo;
    }

    public void addSelectionListener(Listener listener) {
        this.getControl().addListener(13, listener);
    }

    public XBaseUser getSelection() {
        XUserForSelection selection = (XUserForSelection)this.adapter.getSelection3();
        if (selection == null || selection.userId == null) {
            return null;
        }
        XBaseUser user = PersonUiPlugin.getDefault().getUser(selection.userId);
        return user;
    }

    public XBaseUser getUserById(Integer userId) {
        if (userId == null) {
            return null;
        }
        for (XUserForSelection u : this.adapter.getItems()) {
            if (!userId.equals(u.userId)) continue;
            XBaseUser user = PersonUiPlugin.getDefault().getUser(u.userId);
            return user;
        }
        return null;
    }

    public void selectByUserId(Integer userId) {
        if (userId == null) {
            this.select(null);
            return;
        }
        for (XUserForSelection u : this.adapter.getItems()) {
            if (!userId.equals(u.userId)) continue;
            this.adapter.select((Object)u);
            return;
        }
        XBaseUser user = this.getUserById(userId);
        this.select(user);
    }

    public void select(XBaseUser user) {
        XUserForSelection item = this.getItem(user);
        if (user == null) {
            this.adapter.add((Object)item);
            this.adapter.select((Object)item);
        } else if (item != null) {
            this.adapter.select((Object)item);
        } else {
            item = this.newItem(user);
            this.adapter.add((Object)item);
            this.adapter.select((Object)item);
            if (this.filling) {
                this.fillSelection = item;
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.myTableCombo.setEnabled(enabled);
    }

    private XUserForSelection getItem(XBaseUser user) {
        if (user != null) {
            for (XUserForSelection u : this.adapter.getItems()) {
                if (u.userId == null || !u.userId.equals(user.getId())) continue;
                return u;
            }
        }
        return null;
    }

    private XUserForSelection newItem(XBaseUser user) {
        XUserForSelection item = new XUserForSelection();
        item.userId = user.getId();
        item.personId = user.getIdPerson();
        item.personName = user.getPersonNameOrTextOrEmpty();
        item.personType = "";
        item.sessionIsActive = false;
        item.sessionSiteId = null;
        return item;
    }
}

