/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient.simpleview;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.PatientAccessorClient;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XContactInformation;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XPatientFlags;
import ca.infodata.ofys.data.middle.dataobjects.XPerson;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.patient.XConsentement;
import ca.infodata.ofys.data.middle.dataobjects.patient.XPatientInactiveRaison;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.ui.controls.MyMask;
import ca.infodata.ofys.ui.controls.MyMasks;
import ca.infodata.ofys.ui.person.patient.simpleview.BaseVerySimplePatientControl;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class VerySimplePatientControl
extends BaseVerySimplePatientControl {
    private static final String MOIS = " " + Messages.getString((String)"MOIS", (String[])new String[0]).toLowerCase();
    private static final String ANS = " " + Messages.getString((String)"Client.AGE_ANS", (String[])new String[0]).toLowerCase();
    private static final String AN = " " + Messages.getString((String)"Client.AGE_ANS", (String[])new String[0]).replace("s", "").toLowerCase();
    private static final Logger logger = Logger.getLogger(VerySimplePatientControl.class.getName());

    public VerySimplePatientControl(Composite parent, FormToolkit toolkit) {
        super(parent, toolkit);
    }

    @Override
    public void showDataObject() {
        if (this.isDisposed()) {
            return;
        }
        IPatient patient = this.getPatient();
        if (!(patient instanceof XPatient) && patient != null) {
            new Exception("patient pas instance of XPatient").printStackTrace();
        }
        if (patient == null) {
            this.txtFirstName.clear();
            this.txtLastName.clear();
            this.cmbGender.setText(null);
            this.txtBirthDate.setText(null);
            this.lblAge.setText(null);
            this.lblAge.setToolTipText(AGE);
            this.txtNote.setText(null);
            this.txtPostalCode.setText(null);
            this.txtStreet.clear();
            this.cmbCity.clear();
            this.cmbCountry.clear();
            this.cmbProvince.clear();
            this.txtPatientRecordNumber.clear();
            this.txtHealthInsuranceNumber.clear();
            this.txtExpirationCAM.clear();
            this.txtPhone.clear();
            this.txtPhone2.clear();
            this.lblcourriel.setText("");
            this.lblMessagerie.setVisible(false);
            this.btnPrint.setEnabled(false);
        } else {
            this.txtFirstName.setText(patient.getFirstName());
            this.txtLastName.setText(patient.getLastName());
            this.cmbGender.setText(this.getGender(patient).toString());
            this.txtBirthDate.setText(patient.getBirthDate() == null ? null : LocalDateFormat.format((LocalDate)patient.getBirthDate(), (String)FormatDateProvider.getFormatDate().toString()));
            String age = this.getAge(patient);
            this.lblAge.setText(age);
            if (XPatientInactiveRaison.DCD.equals((Object)patient.getInactiveRaison())) {
                String dateDeces = "";
                if (patient.getInactiveDate() != null) {
                    dateDeces = " " + LocalDateFormat.format((LocalDate)LocalDate.from((IPartialDate)patient.getInactiveDate()), (String)FormatDateProvider.getFormatDate().toString());
                }
                this.lblAge.setToolTipText(String.valueOf(XPatientInactiveRaison.DCD.toString()) + dateDeces);
            } else {
                this.lblAge.setToolTipText(AGE);
            }
            this.txtNote.setText(patient.getNote());
            boolean showPatient = true;
            boolean showPatientOther = true;
            boolean showAddress = true;
            boolean showComm = true;
            boolean showToAll = true;
            XConsentement consent = null;
            if (patient instanceof XPatient) {
                Integer idUser = Application.get().getGlobalInstances().getSession().getUser().getId();
                XPatient xsp = (XPatient)patient;
                if (!xsp.getConsentement().isEmpty()) {
                    showToAll = false;
                    for (XConsentement consentement : xsp.getConsentement()) {
                        if (!consentement.getIdUserAnchor().equals(idUser)) continue;
                        consent = consentement;
                        break;
                    }
                }
            }
            boolean checkDroit = false;
            if (!showToAll && consent != null) {
                checkDroit = true;
            }
            showPatient = showToAll || checkDroit && consent.hasRightPatient();
            showPatientOther = showToAll || checkDroit && consent.hasRightPatientOther();
            showAddress = showToAll || checkDroit && consent.hasRightAddres();
            showComm = showToAll || checkDroit && consent.hasRightComm();
            this.txtPostalCode.setText(patient.getPostalCode());
            this.txtPostalCode.setVisible(showAddress);
            this.txtStreet.setText(patient.getStreet());
            this.txtStreet.setVisible(showAddress);
            this.cmbCity.setText(patient.getCity() == null ? null : patient.getCity().getName());
            this.cmbCity.setVisible(showAddress);
            this.cmbCountry.setText(patient.getCountry() == null ? null : patient.getCountry().getName());
            this.cmbCountry.setVisible(showAddress);
            this.cmbProvince.setText(patient.getProvince() == null ? null : patient.getProvince().getName());
            this.cmbProvince.setVisible(showAddress);
            this.txtPatientRecordNumber.setText(patient.getPatientRecordNumber());
            this.txtPatientRecordNumber.setVisible(showPatient);
            this.txtHealthInsuranceNumber.setText(patient.getFormatedHealthInsuranceNumber());
            this.txtHealthInsuranceNumber.setVisible(showPatient);
            this.txtExpirationCAM.setText(patient.getExpirationCAM());
            this.txtExpirationCAM.setVisible(showPatient);
            this.txtPhone.setText(new JoinList(", ", new Object[]{this.getMaskByContactType(patient.getFirstContactInformation() == null ? XContactInformation.CONTACT_TYPE_PHONE : patient.getFirstContactInformation().getTypeContact()).apply(patient.getFirstContactInformationContact()), patient.getFirstContactInformationNote()}).toString());
            this.txtPhone.setVisible(showComm);
            this.txtPhone2.setText(new JoinList(", ", new Object[]{this.getMaskByContactType(patient.getSecondContactInformation() == null ? XContactInformation.CONTACT_TYPE_PHONE : patient.getSecondContactInformation().getTypeContact()).apply(patient.getSecondContactInformationContact()), patient.getSecondContactInformationNote()}).toString());
            this.txtPhone2.setVisible(showComm);
            this.lblcourriel.setText(StringUtils.isEmpty((String)patient.getEmailPrincContact()) ? Messages.getString((String)"COURRIEL_PRINC_ABSENT", (String[])new String[0]) : patient.getEmailPrincContact());
            this.lblcourriel.setVisible(showComm);
            this.lblMessagerie.setVisible(StringUtils.isNotEmpty((String)patient.getCell()));
            this.lblMessagerie.setVisible(showComm);
            this.btnPrint.setEnabled(true);
            this.btnPrint.setVisible(showToAll || checkDroit && showComm && showAddress && showPatient && showPatientOther);
        }
        this.refreshFlags(patient);
        this.lblPatientRecordNumber.setPatient(patient);
    }

    private XPerson.Gender getGender(IPatient patient) {
        XPerson.Gender gender = StringUtils.isEmpty((String)patient.getGender()) ? XPerson.Gender.INCONNU : XPerson.Gender.from((String)patient.getGender());
        if (gender == null) {
            gender = XPerson.Gender.INCONNU;
        }
        return gender;
    }

    private String getAge(IPatient patient) {
        boolean isDcd;
        Object dateDecesOrToday;
        if (patient != null && patient.getBirthDate() != null && (dateDecesOrToday = (isDcd = XPatientInactiveRaison.DCD.equals((Object)patient.getInactiveRaison()) && patient.getInactiveDate() != null) ? patient.getInactiveDate() : LocalDate.today()) != null) {
            String text;
            int yearDiff = LocalDate.from((IPartialDate)dateDecesOrToday).getYearDiff(patient.getBirthDate());
            if (yearDiff > 0) {
                text = String.valueOf(yearDiff) + (yearDiff > 1 ? ANS : AN);
            } else {
                int monthDiff = LocalDate.from((IPartialDate)dateDecesOrToday).getMonthDiff(patient.getBirthDate());
                text = String.valueOf(monthDiff) + MOIS;
            }
            if (isDcd) {
                text = String.valueOf(text) + " (DCD)";
            }
            return text;
        }
        return null;
    }

    private void refreshFlags(final IPatient patient) {
        if (patient != null && patient.getId() != null) {
            Display.getDefault().timerExec(50, new Runnable(){

                @Override
                public void run() {
                    if (patient != null && patient.equals(VerySimplePatientControl.this.getPatient()) && patient.getId() != null) {
                        VerySimplePatientControl.this.flagsCallbackComposite.showLoadingComposite();
                        try {
                            PatientAccessorClient.getInstance().getPatientFlag(Application.get().getGlobalInstances().getSession(), patient.getId(), (ICallback)VerySimplePatientControl.this.flagsCallbackComposite.getCallback());
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Erreur", e);
                            VerySimplePatientControl.this.flagsCallbackComposite.showErrorComposite(Messages.getString((String)"ERREUR", (String[])new String[0]), (Throwable)e);
                        }
                    }
                }
            });
        } else {
            this.flagsCallbackComposite.showLoadedCompositeInSwtThread(new ReturnObject((Serializable)new XPatientFlags()));
        }
    }

    private MyMask getMaskByContactType(Integer type) {
        if (type == null) {
            return MyMasks.standardText;
        }
        if (XContactInformation.CONTACT_EMAILS_TYPES.contains(type)) {
            return MyMasks.standardTextLower;
        }
        if (XContactInformation.CONTACT_PHONE_TYPES.contains(type)) {
            return MyMasks.phoneNumber;
        }
        return MyMasks.standardText;
    }
}

