/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient.search;

import apple.finder.search.ui.ICriteriaOperator;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.CompletionComboAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ICompletionComboItem;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.search.CID;
import ca.infodata.ofys.ui.controls.EasyLabelProvider;
import ca.infodata.ofys.ui.person.patient.search.AbstractChoiceCriteria;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractCompletionComboCriteria
extends AbstractChoiceCriteria {
    private static final Logger logger = Logger.getLogger("ca.infodata.ofys.ui.person.patient.search.CompletionComboCriteria");
    private String competionType;

    public AbstractCompletionComboCriteria(CID cid, String competionType) {
        super(cid);
        this.competionType = competionType;
        this.fill(competionType);
    }

    protected void fill(String completionType) {
        try {
            Callback callback = new Callback(){

                public void responseReceived(ReturnObject response) {
                    if (response != null && response.getObj() instanceof Collection) {
                        AbstractCompletionComboCriteria.this.fill((Collection)response.getObj());
                    }
                }
            };
            CompletionComboAccessorClient.getInstance().findAll(Application.get().getGlobalInstances().getSession(), (ICallback)callback, completionType);
        }
        catch (CannotConnectToServerException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to load completion type for type " + completionType, e);
        }
    }

    protected final void fill(Collection<? extends ICompletionComboItem> list) {
        ArrayList<ICompletionComboItem> list2 = new ArrayList<ICompletionComboItem>(list.size());
        for (ICompletionComboItem iCompletionComboItem : list) {
            if (!iCompletionComboItem.isActive()) continue;
            list2.add(iCompletionComboItem);
        }
        Collections.sort(list2, new Comparator<ICompletionComboItem>(){

            @Override
            public int compare(ICompletionComboItem o1, ICompletionComboItem o2) {
                return StringUtils.compareAscii((String)o1.getText(), (String)o2.getText());
            }
        });
        EasyLabelProvider easyLabelProvider = new EasyLabelProvider();
        for (ICompletionComboItem e : list2) {
            easyLabelProvider.add((Object)e, e.getText());
        }
        this.setProvider((EasyLabelProvider<Object>)easyLabelProvider);
    }

    @Override
    public Map<String, String> valueToXml(ICriteriaOperator operator, Object valueReference) {
        Map<String, String> map = super.valueToXml(operator, valueReference);
        map.put("type", this.competionType);
        return map;
    }

    @Override
    public Collection<Object> xmlToValue(Map<String, String> map) {
        String stype = map.remove("type");
        if (!this.competionType.equals(stype)) {
            throw new IllegalArgumentException("xml type is != criteria type. " + stype + " != " + this.competionType);
        }
        return super.xmlToValue((Map)map);
    }

    @Override
    protected String xmlValueOf(Object e) {
        return ((ICompletionComboItem)e).getId().toString();
    }

    @Override
    protected Object objectValueOf(String xmlValue) {
        int id = Integer.parseInt(xmlValue);
        List list = this.getProvider().getKeys();
        for (Object e : list) {
            if (!((ICompletionComboItem)e).getId().equals(id)) continue;
            return e;
        }
        return null;
    }

    @Override
    protected Object criteriaValueOf(Object e) {
        return ((ICompletionComboItem)e).getId();
    }
}

