/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.site.SiteAddedAs;
import ca.infodata.ofys.data.middle.dataobjects.site.XPersonSite;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.ui.controls.BaseMultiEditor;
import ca.infodata.ofys.ui.controls.FontAwareSection;
import ca.infodata.ofys.ui.controls.IBaseEditor;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.BasePersonEditor;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.consent.PatientConsentsControl;
import ca.infodata.ofys.ui.person.identifiers.PatientIdentifiersControl;
import ca.infodata.ofys.ui.person.patient.PatientControl;
import ca.infodata.ofys.ui.person.patient.PatientMultiEditor;
import ca.infodata.ofys.ui.person.patientAlerts.PatientAlertsControl;
import ca.infodata.ofys.ui.person.professionnal.PatientProfessionnalControl;
import ca.infodata.ofys.ui.person.site.DrugStoreSitesControl;
import ca.infodata.ofys.ui.site.SitePlugin;
import ca.infodata.util1.PredicateA;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class BasePatientEditor
extends BasePersonEditor {
    private static final String PATIENT = Messages.getString((String)"PATIENT", (String[])new String[0]);
    protected PatientControl patient;
    protected FontAwareSection sectionPatient;
    protected PatientConsentsControl patientConsentsControl;
    protected PatientIdentifiersControl patientIdentifiersControl;
    protected PatientAlertsControl patientAlertsControl;
    protected DrugStoreSitesControl drugStoreSiteControl;
    protected PatientProfessionnalControl patientProfessionnalControl;
    protected final boolean isAdmin = Application.get().getGlobalInstances().getSession().getUser().isAdmin();
    protected final boolean isOnlyAdmin = Application.get().getGlobalInstances().getSession().getUser().isOnlyAdmin();
    private FontAwareSection sectionDsq;
    private MyButton btnSearchDSQ;

    public BasePatientEditor(BaseMultiEditor parentEditor) {
        super(parentEditor);
        this.contactControlShowValidationStatus = true;
        this.addressControlShowValidationStatus = true;
    }

    @Override
    public void createMyControl(Composite parent) {
        super.createMyControl(parent);
        this.userControl.setVisible(false);
        this.sectionUser.setVisible(false);
        this.userControl.setEnabled(false);
        this.sectionUser.setEnabled(false);
    }

    @Override
    public void createSubControl(Composite parent) {
        FormData data;
        parent.setLayout((Layout)new FormLayout());
        if (Boolean.TRUE.equals(UI.genericExecuteCommandSafe((AbstractUIPlugin)PersonUiPlugin.getDefault(), (String)"ca.infodata.ofys.ui.dsq.IsDSQEnabled", (Object)Boolean.TRUE))) {
            this.sectionDsq = new FontAwareSection(parent, 66, this.toolkit);
            this.sectionDsq.setText(Messages.getString((String)"DOSSIER_SANTE_QUEBEC", (String[])new String[0]));
            this.toolkit.createCompositeSeparator((Composite)this.sectionDsq);
            Composite sectionDsqControl = this.toolkit.createComposite((Composite)this.sectionDsq);
            sectionDsqControl.setLayout((Layout)UI.newFormLayout((int)5, (int)5));
            this.sectionDsq.setClient((Control)sectionDsqControl);
            this.btnSearchDSQ = new MyButton(sectionDsqControl, Messages.getString((String)"RECHERCHER_LE_PATIENT_AU_DSQ", (String[])new String[0]), 8, this.toolkit);
            this.btnSearchDSQ.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        UI.genericExecuteCommand((AbstractUIPlugin)PersonUiPlugin.getDefault(), (String)"ca.infodata.ofys.ui.dsq.FindCandidateAction");
                    }
                    catch (Exception ex) {
                        MessageUtil.show((Shell)BasePatientEditor.this.getSite().getShell(), (Exception)ex);
                    }
                }
            });
        }
        this.sectionPatient = new FontAwareSection(this.getSubComposite(), 66, this.toolkit);
        this.toolkit.createCompositeSeparator((Composite)this.sectionPatient);
        this.sectionPatient.setText(PATIENT);
        this.patient = new PatientControl((Composite)this.sectionPatient, this.toolkit, (PatientMultiEditor)this.getParentEditor());
        this.sectionPatient.setClient((Control)this.patient);
        this.sectionPatient.setVisible(!this.isOnlyAdmin);
        if (this.sectionDsq != null) {
            this.sectionDsq.setVisible(!this.isOnlyAdmin);
            data = new FormData();
            data.top = new FormAttachment(0);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            if (this.isOnlyAdmin) {
                data.height = 0;
            }
            this.sectionDsq.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(0);
            data.left = new FormAttachment(0);
            this.btnSearchDSQ.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment((Control)this.sectionDsq, 0);
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            if (this.isOnlyAdmin) {
                data.height = 0;
            }
            this.sectionPatient.setLayoutData((Object)data);
        } else {
            data = new FormData();
            data.top = new FormAttachment(0, 0);
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            if (this.isOnlyAdmin) {
                data.height = 0;
            }
            this.sectionPatient.setLayoutData((Object)data);
        }
    }

    @Override
    public void createSubControlEx(Composite parent) {
        parent.setLayout((Layout)new FormLayout());
        this.patientConsentsControl = new PatientConsentsControl(parent, this.toolkit, (PatientMultiEditor)this.getParentEditor());
        this.patientProfessionnalControl = new PatientProfessionnalControl(parent, (PatientMultiEditor)this.getParentEditor(), this.toolkit);
        this.drugStoreSiteControl = new DrugStoreSitesControl(parent, (IBaseEditor)this.getParentEditor(), this.toolkit);
        final PredicateA original = this.siteControl.getCmbSite().getDisplayPredicate();
        this.siteControl.getCmbSite().setDisplayPredicate((PredicateA)new PredicateA<XSite>(){

            public boolean evaluate(XSite e) {
                return (original != null && original.evaluate((Object)e) || original == null) && e != null && Boolean.TRUE.equals(e.getIsWorkSite());
            }
        });
        this.siteControl.getCmbSite().setItems(new ArrayList(this.siteControl.getCmbSite().getItems()));
        this.siteControl.setDisplayPredicate((PredicateA)new PredicateA<XPersonSite>(){

            public boolean evaluate(XPersonSite s) {
                if (s == null) {
                    return false;
                }
                XSite site = SitePlugin.getDefault().getSite(s.getIdSite());
                if (site == null) {
                    return false;
                }
                return s.getAddedAs() == SiteAddedAs.WORK_SITE;
            }
        });
        this.patientIdentifiersControl = new PatientIdentifiersControl(parent, this.toolkit, (PatientMultiEditor)this.getParentEditor());
        this.patientAlertsControl = new PatientAlertsControl(parent, this.toolkit, (PatientMultiEditor)this.getParentEditor());
        this.contactControl.getSection().getChildren()[0].addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent arg0) {
                if (Calendar.getInstance().getTimeInMillis() - BasePatientEditor.this.lastTimeAutoFocus > 1000L) {
                    TimerTask task = new TimerTask(){

                        @Override
                        public void run() {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!((this).this).BasePatientEditor.this.sectionPatient.isDisposed()) {
                                        BasePatientEditor.this.lastTimeAutoFocus = Calendar.getInstance().getTimeInMillis();
                                        ((this).this).BasePatientEditor.this.sectionPatient.setFocus();
                                    }
                                }
                            });
                        }
                    };
                    Timer t = new Timer();
                    t.schedule(task, 20L);
                    TimerTask task2 = new TimerTask(){

                        @Override
                        public void run() {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!BasePatientEditor.this.contactControl.getSection().isDisposed()) {
                                        BasePatientEditor.this.contactControl.getSection().setFocus();
                                    }
                                }
                            });
                        }
                    };
                    Timer t2 = new Timer();
                    t2.schedule(task2, 40L);
                }
            }
        });
        this.patientConsentsControl.setVisible(this.isAdmin);
        this.patientIdentifiersControl.setVisible(!this.isOnlyAdmin);
        this.patientAlertsControl.setVisible(!this.isOnlyAdmin);
        this.drugStoreSiteControl.setVisible(!this.isOnlyAdmin);
        this.patientProfessionnalControl.setVisible(!this.isOnlyAdmin);
        int top = 0;
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        if (this.isOnlyAdmin) {
            data.height = 0;
        }
        this.patientProfessionnalControl.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.patientProfessionnalControl, top);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        if (this.isOnlyAdmin) {
            data.height = 0;
        }
        this.drugStoreSiteControl.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.drugStoreSiteControl, top);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        if (this.isOnlyAdmin) {
            data.height = 0;
        }
        this.patientIdentifiersControl.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.patientIdentifiersControl, top);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        if (this.isOnlyAdmin) {
            data.height = 0;
        }
        this.patientAlertsControl.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.patientAlertsControl, top);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        if (!this.isAdmin) {
            data.height = 0;
        }
        this.patientConsentsControl.setLayoutData(data);
    }

    protected abstract XPatient getPatient();
}

