/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.group;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XPersonGroup;
import ca.infodata.ofys.ui.controls.ControlDecorator;
import ca.infodata.ofys.ui.controls.IControl;
import ca.infodata.ofys.ui.controls.MyTableCombo;
import ca.infodata.ofys.ui.controls.MyTableComboDataAdapter;
import ca.infodata.ofys.ui.controls.ProviderAAR;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.util1.StringUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class PersonGroupComboForSelection
implements IControl {
    private static final int STANDARD_TEXT_LIMIT = 100;
    private MyTableComboDataAdapter<XPersonGroup> adapter;
    private MyTableCombo myTableCombo;
    private final Color green;

    public PersonGroupComboForSelection(Composite parent, int style) {
        this.myTableCombo = new MyTableCombo(parent, style | 0x800);
        this.myTableCombo.setDisplayColumnIndex(0);
        this.myTableCombo.setVisibleItemCount(10);
        this.myTableCombo.setShowTableLines(true);
        this.myTableCombo.setShowTableHeader(true);
        this.myTableCombo.setShowColorWithinSelection(false);
        this.myTableCombo.setShowFontWithinSelection(false);
        this.myTableCombo.setShowImageWithinSelection(false);
        this.myTableCombo.setTextLimit(100);
        String helpText = "\u2193 et \u2191\t Naviguer dans la table (m\u00eame si la table est ferm\u00e9e) \nALT + \u2193\t Afficher ou fermer la table \nUne lettre\t S\u00e9lectionner le prochain groupe dont le nom commence par";
        ControlDecorator.decorateWithHelp((Control)this.myTableCombo, (String)helpText);
        this.green = ResourceGetter.getColor((int)204, (int)255, (int)204);
        ResourceGetter.linkResourceWithWidgetLife((Object)this.green, (Widget)this.myTableCombo);
        this.adapter = new MyTableComboDataAdapter(this.myTableCombo);
        this.adapter.addColumn(Messages.getString((String)"NOM", (String[])new String[0]));
        this.adapter.setItemProvider((ProviderAAR)new ProviderAAR<XPersonGroup, Table, TableItem>(){

            public TableItem get(XPersonGroup group, Table table) {
                TableItem item = new TableItem(table, -1);
                if (group != null) {
                    item.setText(0, group.getName());
                }
                return item;
            }
        });
        List list = Application.get().getPersonPluginController().getActivePersonGroups().sorted((o1, o2) -> StringUtils.compareAscii((String)o1.getName(), (String)o2.getName())).collect(Collectors.toList());
        list.add(0, null);
        this.adapter.setItems(list);
    }

    public MyTableCombo getControl() {
        return this.myTableCombo;
    }

    public void addSelectionListener(Listener listener) {
        this.getControl().addListener(13, listener);
    }

    public void select(XPersonGroup group) {
        this.adapter.select((Object)group);
    }

    public XPersonGroup getSelection() {
        XPersonGroup selection = (XPersonGroup)this.adapter.getSelection3();
        return selection;
    }

    public void setEnabled(boolean enabled) {
        this.myTableCombo.setEnabled(enabled);
    }
}

