/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.util.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nightlabs.util.reflect.CloneDelegate;
import org.nightlabs.util.reflect.CloneException;

public class ReflectUtil {
    private static String CLONE = "clone";

    public static Object clone(Object original) {
        return ReflectUtil.clone(original, Object.class);
    }

    public static Object clone(Object original, String[] ignoredMembers) {
        return ReflectUtil.clone(original, Object.class, ignoredMembers);
    }

    public static Object clone(Object original, Class[] cloneDelegates) {
        return ReflectUtil.clone(original, Object.class, null, cloneDelegates);
    }

    public static Object clone(Object original, String[] ignoredMembers, Class[] cloneDelegtes) {
        return ReflectUtil.clone(original, Object.class, ignoredMembers, cloneDelegtes);
    }

    public static Map initCloneDelegates(Class[] cloneDelegates) throws CloneException {
        HashMap<Class, Class> class2CloneDelegate = new HashMap<Class, Class>(cloneDelegates.length);
        int i = 0;
        while (i < cloneDelegates.length) {
            Class cdClass = cloneDelegates[i];
            if (CloneDelegate.class.isAssignableFrom(cdClass)) {
                try {
                    Method getCloneClass = cdClass.getMethod("getCloneClass", null);
                    Class cloneClass = (Class)getCloneClass.invoke(null, null);
                    class2CloneDelegate.put(cloneClass, cdClass);
                }
                catch (SecurityException e) {
                    throw new CloneException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new CloneException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new CloneException(e);
                }
                catch (IllegalAccessException e) {
                    throw new CloneException(e);
                }
                catch (InvocationTargetException e) {
                    throw new CloneException(e);
                }
            }
            ++i;
        }
        return class2CloneDelegate;
    }

    public static Object clone(Object original, Class stopClass, String[] ignoredMembers, Class[] cloneDelegates) {
        try {
            Class<?> orgClass = original.getClass();
            List fields = ReflectUtil.collectAllFields(orgClass, stopClass, true, ignoredMembers);
            boolean cloneDelegate = false;
            HashMap class2CloneDelegate = new HashMap(0);
            if (cloneDelegates != null) {
                class2CloneDelegate = new HashMap(ReflectUtil.initCloneDelegates(cloneDelegates));
                cloneDelegate = true;
            }
            try {
                Object dcInstance = orgClass.newInstance();
                for (Field field : fields) {
                    Class<?> fieldType = field.getType();
                    if (cloneDelegate && class2CloneDelegate.containsKey(fieldType)) {
                        Class cdClass = (Class)class2CloneDelegate.get(fieldType);
                        Method clone = cdClass.getMethod("clone", fieldType);
                        Object clonedField = clone.invoke(cdClass.newInstance(), field.get(dcInstance));
                        field.set(dcInstance, clonedField);
                        continue;
                    }
                    if (fieldType.isPrimitive()) {
                        field.set(dcInstance, field.get(original));
                        continue;
                    }
                    if (fieldType.isArray()) {
                        Object array = field.get(original);
                        if (array == null) continue;
                        int length = Array.getLength(array);
                        Class<?> arrayType = array.getClass();
                        Object clonedArray = Array.newInstance(arrayType.getComponentType(), length);
                        int i = 0;
                        while (i < length) {
                            Object value = Array.get(array, i);
                            Array.set(clonedArray, i, value);
                            ++i;
                        }
                        field.set(dcInstance, clonedArray);
                        continue;
                    }
                    if (Cloneable.class.isAssignableFrom(fieldType)) {
                        Object org = field.get(original);
                        field.set(dcInstance, org.getClass().getMethod(CLONE, null).invoke(org, null));
                        continue;
                    }
                    throw new IllegalStateException("Not all members are primitive or Cloneable! Class=\"" + original.getClass().getName() + "\" Member=\"" + field.getType().getName() + " " + field.getName() + "\"");
                }
                return dcInstance;
            }
            catch (NoSuchMethodException e) {
                throw new CloneException(e);
            }
            catch (IllegalAccessException e) {
                throw new CloneException(e);
            }
            catch (InstantiationException e) {
                throw new CloneException(e);
            }
            catch (InvocationTargetException e) {
                throw new CloneException(e);
            }
        }
        catch (CloneException x) {
            throw new RuntimeException(x);
        }
    }

    public static Object clone(Object original, Class stopClass, String[] ignoredMembers) {
        return ReflectUtil.clone(original, stopClass, ignoredMembers, null);
    }

    public static Object clone(Object original, Class stopClass) {
        return ReflectUtil.clone(original, stopClass, null);
    }

    public static List collectAllFields(Class originalClass, Class stopClass, boolean ignoreFields, String[] ignoredMembers) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class superClass = originalClass;
        while (superClass != stopClass) {
            Field field;
            int i;
            Field[] f = superClass.getDeclaredFields();
            if (ignoreFields) {
                i = 0;
                while (i < f.length) {
                    if (!ReflectUtil.ignoreField(f[i]) && !ReflectUtil.ignoreMembers(f[i], ignoredMembers)) {
                        field = f[i];
                        field.setAccessible(true);
                        fields.add(field);
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < f.length) {
                    field = f[i];
                    if (!ReflectUtil.ignoreMembers(field, ignoredMembers)) {
                        field.setAccessible(true);
                        fields.add(field);
                    }
                    ++i;
                }
            }
            superClass = superClass.getSuperclass();
        }
        return fields;
    }

    public static List collectAllFields(Class originalClass, boolean ignoreFields) {
        return ReflectUtil.collectAllFields(originalClass, Object.class, ignoreFields, null);
    }

    private static boolean ignoreField(Field field) {
        int modifiers = field.getModifiers();
        if ((modifiers & 8) != 0) {
            return true;
        }
        return (modifiers & 0x10) != 0;
    }

    private static boolean ignoreMembers(Field field, String[] names) {
        if (names == null) {
            return false;
        }
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            if (field.getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean equals(Object original, Object target) {
        Class<?> targetClass;
        if (original == target) {
            return true;
        }
        Class<?> originalClass = original.getClass();
        if (!originalClass.isAssignableFrom(targetClass = target.getClass())) {
            return false;
        }
        List originalFields = ReflectUtil.collectAllFields(originalClass, true);
        List targetFields = ReflectUtil.collectAllFields(targetClass, true);
        if (originalFields.size() != targetFields.size()) {
            return false;
        }
        int i = 0;
        while (i < originalFields.size()) {
            Field originalField = (Field)originalFields.get(i);
            Field targetField = (Field)targetFields.get(i);
            try {
                if (!originalField.get(original).equals(targetField.get(target))) {
                    return false;
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return true;
    }

    public static String toString(Object o, boolean withSuperClasses) {
        Class<?> oClass = o.getClass();
        StringBuffer sb = new StringBuffer();
        sb.append(oClass.getName());
        sb.append("\n");
        if (withSuperClasses) {
            List fields = ReflectUtil.collectAllFields(oClass, false);
            for (Field field : fields) {
                try {
                    sb.append(field.getName());
                    sb.append(" = ");
                    sb.append(String.valueOf(field.get(o)));
                    sb.append("\n");
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        } else {
            Field[] fields = oClass.getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                Field field = fields[i];
                field.setAccessible(true);
                try {
                    sb.append(field.getName());
                    sb.append(" = ");
                    sb.append(String.valueOf(field.get(o)));
                    sb.append("\n");
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public static void findContainedObjectsByClass(Object checkObject, Class clazz, boolean filter, boolean returnOnFirstInBranch, IObjectFoundHandler objectFoundHandler) {
        ReflectUtil.findContainedObjectsByClass(new HashSet<Object>(), "", checkObject, clazz, filter, returnOnFirstInBranch, objectFoundHandler);
    }

    private static void findContainedObjectsByClass(Set<Object> checked, String path, Object checkObject, Class clazz, boolean filter, boolean returnOnFirstInBranch, IObjectFoundHandler objectFoundHandler) {
        if (checkObject == null) {
            return;
        }
        if (clazz.isAssignableFrom(checkObject.getClass()) == filter) {
            objectFoundHandler.objectFound(path, checkObject);
            if (returnOnFirstInBranch) {
                return;
            }
        }
        Object object = checkObject;
        Class<?> classRun = object.getClass();
        while (!classRun.equals(Object.class)) {
            Field[] fields;
            Field[] fieldArray = fields = classRun.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                field.setAccessible(true);
                try {
                    Object o = field.get(object);
                    if (o != null && !checked.contains(o)) {
                        checked.add(o);
                        if (o instanceof Collection) {
                            Collection col = (Collection)o;
                            for (Object o2 : col) {
                                if (o2 == null) continue;
                                ReflectUtil.findContainedObjectsByClass(checked, String.valueOf(path) + "/" + field.getName() + "$value$" + o2.getClass().getName(), o2, clazz, filter, returnOnFirstInBranch, objectFoundHandler);
                            }
                        } else if (o instanceof Map) {
                            Map map = (Map)o;
                            for (Object o2 : map.keySet()) {
                                if (o2 == null) continue;
                                ReflectUtil.findContainedObjectsByClass(checked, String.valueOf(path) + "/" + field.getName() + "$key$" + o2.getClass().getName(), o2, clazz, filter, returnOnFirstInBranch, objectFoundHandler);
                            }
                            for (Object o2 : map.values()) {
                                if (o2 == null) continue;
                                ReflectUtil.findContainedObjectsByClass(checked, String.valueOf(path) + "/" + field.getName() + "$value$" + o2.getClass().getName(), o2, clazz, filter, returnOnFirstInBranch, objectFoundHandler);
                            }
                        } else {
                            ReflectUtil.findContainedObjectsByClass(checked, String.valueOf(path) + "/" + field.getName(), o, clazz, filter, returnOnFirstInBranch, objectFoundHandler);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            classRun = classRun.getSuperclass();
        }
    }

    public static interface IObjectFoundHandler {
        public void objectFound(String var1, Object var2);
    }
}

