/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class FulltextMap
extends HashMap {
    public static final int FEATURE_NONE = 0;
    public static final int FEATURE_BEGINS_WITH = 1;
    public static final int FEATURE_ENDS_WITH = 2;
    public static final int FEATURE_CONTAINS = 4;
    public static final int FIND_MODE_BEGINS_WITH = 1;
    public static final int FIND_MODE_ENDS_WITH = 2;
    public static final int FIND_MODE_CONTAINS = 4;
    protected Locale locale;
    public static final int FEATURE_CASE_SENSITIVE = 8;
    private int features;
    private Collection unmodifiableValues = null;
    private Set unmodifiableKeySet = null;
    private Set unmodifiableEntrySet = null;
    private Map treeBeginsWith = null;
    private Map treeContains = null;
    private Map treeEndsWith = null;
    protected static final Set EMPTY_SET = Collections.unmodifiableSet(new HashSet(0));

    public boolean isFeatureBeginsWithActive() {
        return (this.features & 1) != 0;
    }

    public boolean isFeatureEndsWithActive() {
        return (this.features & 2) != 0;
    }

    public boolean isFeatureContainsActive() {
        return (this.features & 4) != 0;
    }

    public boolean isFeatureCaseSensitiveActive() {
        return (this.features & 8) != 0;
    }

    public FulltextMap(int features) {
        this.init(features, null);
    }

    public FulltextMap(int features, Locale locale) {
        this.init(features, locale);
    }

    public FulltextMap(int initialCapacity, float loadFactor, int features) {
        super(initialCapacity, loadFactor);
        this.init(features, null);
    }

    public FulltextMap(int initialCapacity, float loadFactor, int features, Locale locale) {
        super(initialCapacity, loadFactor);
        this.init(features, locale);
    }

    public FulltextMap(int initialCapacity, int features) {
        super(initialCapacity);
        this.init(features, null);
    }

    public FulltextMap(int initialCapacity, int features, Locale locale) {
        super(initialCapacity);
        this.init(features, locale);
    }

    public FulltextMap(Map map, int features) {
        super(map);
        this.init(features, null);
    }

    public FulltextMap(Map map, int features, Locale locale) {
        super(map);
        this.init(features, locale);
    }

    protected void init(int features, Locale locale) {
        this.features = features;
        this.locale = locale;
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        this.rebuildIndex();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.rebuildIndex();
    }

    public int getFeatures() {
        return this.features;
    }

    public void setFeatures(int features, Locale locale) {
        this.features = features;
        this.locale = locale;
        this.rebuildIndex();
    }

    public void setFeatures(int features) {
        this.features = features;
        this.rebuildIndex();
    }

    @Override
    public Object put(Object key, Object value) {
        Object oldObject = super.put(key, value);
        this.addIndex(key);
        return oldObject;
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException("NYI");
    }

    protected void rebuildIndex() {
        this.clearIndex();
        this.ensureTreesExist();
        Iterator it = this.keySet().iterator();
        while (it.hasNext()) {
            this.addIndex(it.next());
        }
    }

    protected void clearIndex() {
        if (this.treeBeginsWith != null) {
            this.treeBeginsWith.clear();
        }
        if (this.treeContains != null) {
            this.treeContains.clear();
        }
        if (this.treeEndsWith != null) {
            this.treeEndsWith.clear();
        }
    }

    @Override
    public void clear() {
        this.clearIndex();
        super.clear();
    }

    @Override
    public Object clone() {
        return new FulltextMap(this, this.features);
    }

    @Override
    public Collection values() {
        if (this.unmodifiableValues == null) {
            this.unmodifiableValues = Collections.unmodifiableCollection(super.values());
        }
        return this.unmodifiableValues;
    }

    @Override
    public Set keySet() {
        if (this.unmodifiableKeySet == null) {
            this.unmodifiableKeySet = Collections.unmodifiableSet(super.keySet());
        }
        return this.unmodifiableKeySet;
    }

    @Override
    public Set entrySet() {
        if (this.unmodifiableEntrySet == null) {
            this.unmodifiableEntrySet = Collections.unmodifiableSet(super.entrySet());
        }
        return this.unmodifiableEntrySet;
    }

    private void ensureTreesExist() {
        if (this.treeBeginsWith == null && (this.isFeatureBeginsWithActive() || this.isFeatureContainsActive())) {
            this.treeBeginsWith = new HashMap();
        }
        if (this.treeContains == null && this.isFeatureContainsActive()) {
            this.treeContains = new HashMap();
        }
        if (this.treeEndsWith == null && this.isFeatureEndsWithActive() && !this.isFeatureContainsActive()) {
            this.treeEndsWith = new HashMap();
        }
    }

    protected void addIndex(Object _key) {
        String keyInIndex;
        if (!(this.isFeatureBeginsWithActive() || this.isFeatureContainsActive() || this.isFeatureEndsWithActive())) {
            return;
        }
        String key = String.valueOf(_key);
        String string = keyInIndex = this.isFeatureCaseSensitiveActive() ? key : key.toLowerCase(this.locale);
        if (this.isFeatureBeginsWithActive() || this.isFeatureContainsActive()) {
            FulltextMap.addIndexForKeyPart(this.treeBeginsWith, keyInIndex, key, false);
        }
        if (this.isFeatureContainsActive()) {
            Map tree = this.treeContains;
            String keyPart = keyInIndex.substring(1);
            while (keyPart.length() > 0) {
                FulltextMap.addIndexForKeyPart(tree, keyPart, key, false);
                keyPart = keyPart.substring(1);
            }
        }
        if (this.isFeatureEndsWithActive() && !this.isFeatureContainsActive()) {
            FulltextMap.addIndexForKeyPart(this.treeEndsWith, keyInIndex, key, true);
        }
    }

    protected static void addIndexForKeyPart(Map tree, String keyPart, String key, boolean inverse) {
        HashMap<Character, HashMap<Object, HashSet<String>>> treeNode = tree;
        int charIdx = inverse ? keyPart.length() - 1 : 0;
        int increment = inverse ? -1 : 1;
        while (!(inverse ? charIdx < 0 : charIdx >= keyPart.length())) {
            HashSet<String> keys;
            Character c = new Character(keyPart.charAt(charIdx));
            HashMap<Character, HashMap<Object, HashSet<String>>> childTreeNode = (HashMap<Character, HashMap<Object, HashSet<String>>>)treeNode.get(c);
            if (childTreeNode == null) {
                childTreeNode = new HashMap<Character, HashMap<Object, HashSet<String>>>(5);
                treeNode.put(c, childTreeNode);
            }
            if ((keys = (HashSet<String>)childTreeNode.get(null)) == null) {
                keys = new HashSet<String>();
                childTreeNode.put((Character)null, (HashMap<Object, HashSet<String>>)((Object)keys));
            }
            keys.add(key);
            treeNode = childTreeNode;
            charIdx += increment;
        }
    }

    public Collection find(String keyPart, int findMode) {
        Set keySet = this.findKeySet(keyPart, findMode);
        if (keySet.isEmpty()) {
            return keySet;
        }
        ArrayList res = new ArrayList(keySet.size());
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            res.add(super.get(it.next()));
        }
        return res;
    }

    public Set findKeySet(String keyPart, int findMode) {
        Set s;
        if (!this.isFeatureCaseSensitiveActive()) {
            keyPart = keyPart.toLowerCase(this.locale);
        }
        switch (findMode) {
            case 1: {
                if (this.isFeatureBeginsWithActive()) break;
                throw new IllegalStateException("FIND_MODE_BEGINS_WITH requires FEATURE_BEGINS_WITH which is not active!");
            }
            case 4: {
                if (this.isFeatureContainsActive()) break;
                throw new IllegalStateException("FIND_MODE_CONTAINS requires FEATURE_CONTAINS which is not active!");
            }
            case 2: {
                if (this.isFeatureContainsActive()) break;
                throw new IllegalStateException("FIND_MODE_ENDS_WITH requires FEATURE_ENDS_WITH which is not active!");
            }
            default: {
                throw new IllegalArgumentException("findMode=" + findMode + " is invalid! Must be one of: FIND_MODE_BEGINS_WITH, FIND_MODE_CONTAINS, FIND_MODE_ENDS_WITH");
            }
        }
        Set res = null;
        if (1 == findMode || 4 == findMode) {
            res = FulltextMap.findKeySetForKeyPart(this.treeBeginsWith, keyPart, false);
        }
        if (4 == findMode) {
            s = FulltextMap.findKeySetForKeyPart(this.treeContains, keyPart, false);
            if (res != null && s != null) {
                res.addAll(s);
            } else if (s != null) {
                res = s;
            }
        }
        if (2 == findMode) {
            s = FulltextMap.findKeySetForKeyPart(this.treeEndsWith, keyPart, true);
            if (res != null && s != null) {
                res.addAll(s);
            } else if (s != null) {
                res = s;
            }
        }
        if (res == null) {
            return EMPTY_SET;
        }
        return res;
    }

    protected static Set findKeySetForKeyPart(Map tree, String keyPart, boolean inverse) {
        Map treeNode = tree;
        int charIdx = inverse ? keyPart.length() - 1 : 0;
        int increment = inverse ? -1 : 1;
        while (!(inverse ? charIdx < 0 : charIdx >= keyPart.length())) {
            Character c = new Character(keyPart.charAt(charIdx));
            Map childTreeNode = (Map)treeNode.get(c);
            if (childTreeNode == null) {
                return null;
            }
            treeNode = childTreeNode;
            charIdx += increment;
        }
        Set res = (Set)treeNode.get(null);
        if (res != null && res.isEmpty()) {
            res = null;
        }
        return res;
    }

    protected void removeIndex(String key) {
        throw new UnsupportedOperationException("NYI");
    }
}

