/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nightlabs.util.collection.DelegatingCollection;
import org.nightlabs.util.collection.DelegatingList;
import org.nightlabs.util.collection.DelegatingSet;

public class CollectionUtil {
    public static <T> Collection<T> castCollection(Collection<?> in) {
        if (in instanceof Set) {
            return new DelegatingSet((Set)in);
        }
        if (in instanceof List) {
            return new DelegatingList((List)in);
        }
        return new DelegatingCollection(in);
    }

    public static <T> List<T> castList(List<?> in) {
        return new DelegatingList(in);
    }

    public static <T> Set<T> castSet(Set<?> in) {
        return new DelegatingSet(in);
    }

    public static <T> ArrayList<T> array2ArrayList(T[] objects, boolean canReturnNull) {
        if (canReturnNull && objects == null) {
            return null;
        }
        ArrayList<T> l = new ArrayList<T>(objects == null ? 0 : objects.length);
        if (objects != null) {
            int i = 0;
            while (i < objects.length) {
                l.add(objects[i]);
                ++i;
            }
        }
        return l;
    }

    public static <T> HashSet<T> array2HashSet(T[] objects) {
        return CollectionUtil.array2HashSet(objects, true);
    }

    public static <T> ArrayList<T> array2ArrayList(T[] objects) {
        return CollectionUtil.array2ArrayList(objects, true);
    }

    public static <T> HashSet<T> array2HashSet(T[] objects, boolean canReturnNull) {
        if (canReturnNull && objects == null) {
            return null;
        }
        HashSet<T> s = new HashSet<T>(objects == null ? 0 : objects.length);
        if (objects != null) {
            int i = 0;
            while (i < objects.length) {
                s.add(objects[i]);
                ++i;
            }
        }
        return s;
    }

    public static <T> T[] collection2TypedArray(Collection<T> c, Class<T> clazz) {
        return CollectionUtil.collection2TypedArray(c, clazz, true);
    }

    public static <T> T[] collection2TypedArray(Collection<T> c, Class<T> clazz, boolean canReturnNull) {
        if (canReturnNull && c == null) {
            return null;
        }
        Object array = Array.newInstance(clazz, c == null ? 0 : c.size());
        if (c != null) {
            int i = 0;
            Iterator<T> it = c.iterator();
            while (it.hasNext()) {
                Array.set(array, i++, it.next());
            }
        }
        return (Object[])array;
    }

    public static void moveListElementUp(List list, Object element) {
        int index = list.indexOf(element);
        if (index <= 0 || index >= list.size()) {
            return;
        }
        list.remove(index);
        list.add(index - 1, element);
    }

    public static void moveListElementDown(List list, Object element) {
        int index = list.indexOf(element);
        if (index < 0 || index >= list.size() - 1) {
            return;
        }
        list.remove(index);
        list.add(index + 1, element);
    }

    public static <T extends Enum<T>> List<T> enum2List(Enum<T> e) {
        return CollectionUtil.array2ArrayList((Enum[])e.getClass().getEnumConstants());
    }

    public static String toString(Collection c) {
        return CollectionUtil.toString(c, ",", true, null, false, "null");
    }

    public static String toString(Collection c, String fieldPrefix, boolean fieldPrefixBeforeFirst, String fieldSuffix, boolean fieldSuffixAfterLast, String nullString) {
        StringBuffer s = new StringBuffer();
        boolean first = true;
        for (Object object : c) {
            if (fieldPrefix != null) {
                if (first) {
                    first = false;
                    if (fieldPrefixBeforeFirst) {
                        s.append(fieldPrefix);
                    }
                } else {
                    s.append(fieldPrefix);
                }
            }
            String valueString = object == null ? (nullString == null ? "" : nullString) : object.toString();
            s.append(valueString);
            if (fieldSuffix == null) continue;
            s.append(fieldSuffix);
        }
        if (!first && fieldSuffix != null && !fieldSuffixAfterLast) {
            s.delete(s.length() - fieldSuffix.length(), s.length());
        }
        return s.toString();
    }

    public static String toString(Map m) {
        return CollectionUtil.toString(m, ",", true, null, false, "[", "]", "=", "null");
    }

    public static String toString(Map m, String fieldPrefix, boolean fieldPrefixBeforeFirst, String fieldSuffix, boolean fieldSuffixAfterLast, String keyPrefix, String keySuffix, String assignmentString, String nullString) {
        StringBuffer s = new StringBuffer();
        boolean first = true;
        for (Object key : m.keySet()) {
            Object value;
            if (fieldPrefix != null) {
                if (first) {
                    first = false;
                    if (fieldPrefixBeforeFirst) {
                        s.append(fieldPrefix);
                    }
                } else {
                    s.append(fieldPrefix);
                }
            }
            if (keyPrefix != null) {
                s.append(keyPrefix);
            }
            s.append(key);
            if (keySuffix != null) {
                s.append(keySuffix);
            }
            if (assignmentString != null) {
                s.append(assignmentString);
            }
            String valueString = (value = m.get(key)) == null ? (nullString == null ? "" : nullString) : value.toString();
            s.append(valueString);
            if (fieldSuffix == null) continue;
            s.append(fieldSuffix);
        }
        if (!first && !fieldSuffixAfterLast && fieldSuffix != null) {
            s.delete(s.length() - fieldSuffix.length(), s.length());
        }
        return s.toString();
    }

    public static <T> String toString(T[] array) {
        return CollectionUtil.toString(array, ",", true, null, false, "[", "]", "=", "null");
    }

    public static <T> String toString(T[] array, String fieldPrefix, boolean fieldPrefixBeforeFirst, String fieldSuffix, boolean fieldSuffixAfterLast, String keyPrefix, String keySuffix, String assignmentString, String nullString) {
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            T value;
            if (fieldPrefix != null && (i > 0 || fieldPrefixBeforeFirst)) {
                s.append(fieldPrefix);
            }
            if (keyPrefix != null) {
                s.append(keyPrefix);
            }
            s.append(i);
            if (keySuffix != null) {
                s.append(keySuffix);
            }
            if (assignmentString != null) {
                s.append(assignmentString);
            }
            String valueString = (value = array[i]) == null ? (nullString == null ? "" : nullString) : value.toString();
            s.append(valueString);
            if (fieldSuffix != null && (i < array.length - 1 || fieldSuffixAfterLast)) {
                s.append(fieldSuffix);
            }
            ++i;
        }
        return s.toString();
    }

    public static void replaceAllInCollection(Collection collection, Object replace, Object replacement) {
        if (collection instanceof List) {
            List list = (List)collection;
            int idx = list.indexOf(replace);
            while (idx >= 0) {
                list.set(idx, replacement);
                idx = list.indexOf(replace);
            }
        } else if (collection.contains(replace)) {
            collection.remove(replace);
            collection.add(replacement);
        }
    }

    public static <T> ArrayList<T> createArrayList(T ... item) {
        ArrayList<T> list = new ArrayList<T>(item.length);
        T[] TArray = item;
        int n = item.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            list.add(t);
            ++n2;
        }
        return list;
    }

    public static <T> HashSet<T> createHashSet(T ... item) {
        HashSet<T> set = new HashSet<T>(item.length);
        T[] TArray = item;
        int n = item.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            set.add(t);
            ++n2;
        }
        return set;
    }
}

