/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.io.pcx;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import org.nightlabs.io.pcx.PCXFormatException;
import org.nightlabs.io.pcx.PCXHeader;
import org.nightlabs.util.Binary;

public class PCXReader {
    private PCXHeader pcxHeader = null;

    public BufferedImage read(InputStream in) throws IOException {
        Binary binary = new Binary(in);
        this.pcxHeader = new PCXHeader(binary);
        BufferedImage image = new BufferedImage(this.pcxHeader.getWidth(), this.pcxHeader.getHeight(), 12);
        int height = this.pcxHeader.getHeight();
        int bytesPerLine = this.pcxHeader.getBytesPerLine();
        WritableRaster raster = image.getRaster();
        int row = 0;
        while (row < height) {
            int col = 0;
            while (col < bytesPerLine) {
                int b = binary.readUnsignedByte();
                if (b >= 192) {
                    int l = b & 0x3F;
                    b = binary.readUnsignedByte();
                    int i = 0;
                    while (i < l) {
                        if (col >= bytesPerLine) {
                            throw new PCXFormatException("Malformed PCX-flow: Too much data in one row!");
                        }
                        PCXReader.set8BlackWhitePixels(col++, row, raster, b);
                        ++i;
                    }
                    continue;
                }
                PCXReader.set8BlackWhitePixels(col++, row, raster, b);
            }
            ++row;
        }
        return image;
    }

    protected static void set8BlackWhitePixels(int col, int row, WritableRaster raster, int byteValue) {
        int xmax = raster.getBounds().width - 1;
        int[] iArray = new int[1];
        int base = col * 8;
        int i = 0;
        while (i < 8) {
            if (base + i > xmax) break;
            iArray[0] = byteValue >> 7 - i & 1;
            raster.setPixel(base + i, row, iArray);
            ++i;
        }
    }
}

