/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.i18n.unit;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.nightlabs.i18n.unit.CMUnit;
import org.nightlabs.i18n.unit.DefaultScreenUnit;
import org.nightlabs.i18n.unit.IUnit;
import org.nightlabs.i18n.unit.InchUnit;
import org.nightlabs.i18n.unit.MMUnit;
import org.nightlabs.i18n.unit.UnitConstants;

public class UnitRegistry
implements UnitConstants {
    private static UnitRegistry unitRegistry = null;
    private Map<String, Set<IUnit>> context2Units = null;
    private Map<String, IUnit> unitID2unit = null;

    protected UnitRegistry() {
        this.addUnit(new MMUnit(), "global");
        this.addUnit(new CMUnit(), "global");
        this.addUnit(new InchUnit(), "global");
        this.addUnit(new DefaultScreenUnit(), "device");
    }

    public static UnitRegistry sharedInstance() {
        if (unitRegistry == null) {
            unitRegistry = new UnitRegistry();
        }
        return unitRegistry;
    }

    private Map<String, Set<IUnit>> getContext2Units() {
        if (this.context2Units == null) {
            this.context2Units = new HashMap<String, Set<IUnit>>();
        }
        return this.context2Units;
    }

    private Map<String, IUnit> getUnitID2Unit() {
        if (this.unitID2unit == null) {
            this.unitID2unit = new HashMap<String, IUnit>();
        }
        return this.unitID2unit;
    }

    public void addUnit(IUnit unit, String context) {
        if (unit == null) {
            throw new IllegalArgumentException("Param unit must not be null!");
        }
        if (context == null) {
            throw new IllegalArgumentException("Param context must not be null!");
        }
        Set<IUnit> units = this.getContext2Units().get(context);
        if (units == null) {
            units = new LinkedHashSet<IUnit>();
            units.add(unit);
            this.getContext2Units().put(context, units);
        } else {
            units.add(unit);
        }
        this.getUnitID2Unit().put(unit.getUnitID(), unit);
    }

    public void removeUnit(IUnit unit, String context) {
        Set<IUnit> units = this.getContext2Units().get(context);
        if (units != null) {
            units.remove(unit);
        }
        if (unit != null) {
            this.getUnitID2Unit().remove(unit.getUnitID());
        }
    }

    public Set<IUnit> getGlobalUnits() {
        return this.getContext2Units().get("global");
    }

    public Set<IUnit> getUnits(String context, boolean global) {
        Set<IUnit> contextUnits = this.getContext2Units().get(context);
        if (!global) {
            return contextUnits;
        }
        LinkedHashSet<IUnit> allUnits = new LinkedHashSet<IUnit>(this.getGlobalUnits());
        if (contextUnits != null) {
            allUnits.addAll(contextUnits);
        }
        return allUnits;
    }

    public IUnit getUnit(String unitID) {
        return this.getUnitID2Unit().get(unitID);
    }
}

