/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.pdf;

import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.util1.ClosureA;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.PrintService;
import javax.swing.SwingUtilities;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.printing.PDFPageable;

public class PrintPdfX {
    private static final Logger logger = Logger.getLogger(PrintPdfX.class.getName());
    private PDDocument pdfFile;
    private PrinterJob job;
    private PageFormat pageFormat;
    private PRINT_MODE printMode = PRINT_MODE.FIT;

    public PrintPdfX(File file, String printServiceName, String jobName, int copies, PageFormat pageFormat) throws Exception {
        this.pageFormat = pageFormat;
        PrintService printService = PrintPdfX.getService(printServiceName);
        this.job = PrinterJob.getPrinterJob();
        this.pdfFile = PDDocument.load((File)file);
        this.job.setCopies(copies);
        this.job.setJobName(jobName);
        this.job.setPrintService(printService);
    }

    public PrintPdfX(byte[] file, String printServiceName, String jobName, int copies, PageFormat pageFormat) throws Exception {
        this.pageFormat = pageFormat;
        PrintService printService = null;
        printService = PrintPdfX.getService(printServiceName);
        this.job = PrinterJob.getPrinterJob();
        this.pdfFile = PDDocument.load((byte[])file);
        this.job.setCopies(copies);
        this.job.setJobName(jobName);
        this.job.setPrintService(printService);
    }

    public PrintPdfX(byte[] file) throws Exception {
        this.pdfFile = PDDocument.load((byte[])file);
    }

    private static PrintService getService(String name) throws PrinterException {
        return LibPlugin.getDefault().getPrinterList().getPrintService(name);
    }

    public void print() throws PrinterException {
        this.printPdf();
    }

    public static PrintService getPrintService(String printServiceName) throws PrinterException {
        PrintService printService = PrintPdfX.getService(printServiceName);
        return printService;
    }

    public static PageFormat defaultPageFormat(PrintService printService) throws PrinterException {
        PrinterJob job2 = PrinterJob.getPrinterJob();
        job2.setPrintService(printService);
        return PrintPdfX.defaultPageFormat(job2);
    }

    private static PageFormat defaultPageFormat(PrinterJob job2) throws PrinterException {
        PageFormat pf = job2.defaultPage();
        Paper paper1 = pf.getPaper();
        Paper paper2 = new Paper();
        paper2.setSize(paper1.getWidth(), paper1.getHeight());
        paper2.setImageableArea(0.0, 0.0, paper2.getWidth(), paper2.getHeight());
        pf.setPaper(paper2);
        pf = job2.validatePage(pf);
        return pf;
    }

    public static void openPageFormatDialog(String printServiceName, PageFormat pageFormat, final ClosureA<PageFormat> callback) throws PrinterException {
        PrintService printService = PrintPdfX.getService(printServiceName);
        final PrinterJob job2 = PrinterJob.getPrinterJob();
        job2.setPrintService(printService);
        final PageFormat[] pf = new PageFormat[]{pageFormat};
        if (pf[0] == null) {
            pf[0] = job2.defaultPage();
        }
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    pf[0] = job2.pageDialog(pf[0]);
                    callback.execute((Object)pf[0]);
                }
            });
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error while showing pageDialog for printServiceName " + printServiceName, e);
        }
    }

    public double[] getFirstPageSize() {
        int i;
        double[] size = new double[]{0.0, 0.0};
        if (this.pdfFile != null && (i = 0) < this.pdfFile.getNumberOfPages()) {
            PDPage page = this.pdfFile.getPage(i);
            size[0] = page.getBBox().getWidth();
            size[1] = page.getBBox().getHeight();
        }
        return size;
    }

    public void printPdf() throws PrinterException {
        PDFPageable pdfPageable = new PDFPageable(this.pdfFile);
        Book book = new Book();
        int i = 0;
        while (i < this.pdfFile.getNumberOfPages()) {
            PDPage page = this.pdfFile.getPage(i);
            PageFormat pf = this.pageFormat == null ? PrintPdfX.defaultPageFormat(this.job) : this.pageFormat;
            double width = page.getBBox().getWidth();
            double height = page.getBBox().getHeight();
            double sw = pf.getPaper().getWidth() < 0.0 ? width : pf.getPaper().getWidth();
            double sh = pf.getPaper().getHeight() < 0.0 ? height : pf.getPaper().getHeight();
            double ix = pf.getPaper().getImageableX() < 0.0 ? 0.0 : pf.getPaper().getImageableX();
            double iy = pf.getPaper().getImageableY() < 0.0 ? 0.0 : pf.getPaper().getImageableY();
            double iw = pf.getPaper().getImageableWidth() < 0.0 ? width : pf.getPaper().getImageableWidth();
            double ih = pf.getPaper().getImageableHeight() < 0.0 ? height : pf.getPaper().getImageableHeight();
            PageFormat pf2 = new PageFormat();
            pf2.setOrientation(pf.getOrientation());
            Paper paper = new Paper();
            paper.setSize(sw, sh);
            paper.setImageableArea(ix, iy, iw, ih);
            pf2.setPaper(paper);
            book.append(pdfPageable.getPrintable(i), pf2);
            ++i;
        }
        this.job.setPageable(book);
        this.job.print();
    }

    static void logPageFormat(PageFormat format) {
        System.out.println("#start pf");
        if (format != null) {
            PageFormat pf = format;
            System.out.println("pf w : " + pf.getWidth());
            System.out.println("pf h : " + pf.getHeight());
            System.out.println("pf ix : " + pf.getImageableX());
            System.out.println("pf iy : " + pf.getImageableY());
            System.out.println("pf iw : " + pf.getImageableWidth());
            System.out.println("pf ih : " + pf.getImageableHeight());
            System.out.println("pf o : " + (pf.getOrientation() == 0 ? "landscape" : "portrait"));
        } else {
            System.out.println("null");
        }
        System.out.println("#end pf");
    }

    public void setJob(PrinterJob job) {
        this.job = job;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
    }

    public PRINT_MODE getPrintMode() {
        return this.printMode;
    }

    public void setPrintMode(PRINT_MODE printMode) {
        this.printMode = printMode == null ? PRINT_MODE.FIT : printMode;
    }

    public static enum PRINT_MODE {
        ACTUAL_SIZE,
        FIT;

    }
}

