/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.library.log;

import java.util.Arrays;
import java.util.Calendar;
import java.util.List;

public final class LogUtil {
    private static long timeLoggerStart;

    public static void printTimeLogger(String text) {
        System.out.println(String.valueOf(text) + " : " + (System.currentTimeMillis() - timeLoggerStart));
    }

    public static void startTimeLogger() {
        timeLoggerStart = System.currentTimeMillis();
    }

    public static String format(String title, String[] names, Object[] objects) {
        return LogUtil.format(title, names, objects, false);
    }

    public static String format(String title, String[] names, Object[] objects, boolean withTraces) {
        StringBuilder b = new StringBuilder();
        if (withTraces) {
            StackTraceElement[] elements = new Exception().getStackTrace();
            b.append("--> " + elements[1].getClassName() + "." + elements[1].getMethodName() + "(" + title + ")(" + elements[2].getLineNumber() + ") ");
            int i = 0;
            while (i < objects.length) {
                b.append(String.valueOf(names[i].toString()) + " : " + LogUtil.computeLog(objects[i], "") + ", ");
                ++i;
            }
            b.append("\n");
            b.append("    " + elements[2].getClassName() + "." + elements[2].getMethodName() + " (" + elements[2].getLineNumber() + ") ... " + elements[3].getClassName() + "." + elements[3].getMethodName() + " (" + elements[3].getLineNumber() + ")\n");
        } else {
            b.append(String.valueOf(title) + " --> ");
            int i = 0;
            while (i < objects.length) {
                b.append(String.valueOf(names[i].toString()) + " : " + LogUtil.computeLog(objects[i], "") + ", ");
                ++i;
            }
            b.append("\n");
        }
        return b.toString();
    }

    public static String format(Object o) {
        return LogUtil.computeLog(o, "");
    }

    private static String computeLog(Object o, String initial) {
        if (o instanceof List) {
            initial = String.valueOf(initial) + "[";
            int i = 0;
            while (i < ((List)o).size()) {
                initial = LogUtil.computeLog(((List)o).get(i), initial);
                if (i < ((List)o).size() - 1) {
                    initial = String.valueOf(initial) + ",\n ";
                }
                ++i;
            }
            initial = String.valueOf(initial) + "]";
        } else {
            initial = o instanceof Calendar[] ? String.valueOf(initial) + (o == null ? "null" : LogUtil.calendarArrayToString((Calendar[])o)) : (o instanceof Integer[] ? String.valueOf(initial) + (o == null ? "null" : Arrays.deepToString((Integer[])o)) : (o instanceof Calendar ? String.valueOf(initial) + (o == null ? "null" : LogUtil.calendarToString((Calendar)o)) : (o instanceof Object[] ? String.valueOf(initial) + (o == null ? "null" : Arrays.deepToString((Object[])o)) : String.valueOf(initial) + (o == null ? "null" : o.toString()))));
        }
        return initial;
    }

    private static String calendarToString(Calendar a) {
        return String.valueOf(a.get(1)) + "-" + (a.get(2) + 1) + "-" + a.get(5);
    }

    private static String calendarArrayToString(Calendar[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < a.length) {
            if (i == 0) {
                buf.append('[');
            } else {
                buf.append(", ");
            }
            if (a[i] == null) {
                buf.append("null");
            } else {
                buf.append(LogUtil.calendarToString(a[i]));
            }
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    private LogUtil() {
        throw new UnsupportedOperationException();
    }
}

