/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.intro;

import ca.infodata.ofys.ui.controls.statusbar.StatusBarManager;
import ca.infodata.ofys.ui.intro.IntroActionBarAdvisor;
import ca.infodata.ofys.ui.intro.MyCocoaUiEnhancer;
import ca.infodata.ofys.ui.intro.PerspectiveManager;
import ca.infodata.ofys.ui.intro.WindowStateDialogSettings;
import ca.infodata.ofys.ui.library.ResourceGetter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.preferences.ViewPreferencesAction;

public class IntroWindowAdvisor
extends WorkbenchWindowAdvisor {
    private static final Logger logger = Logger.getLogger(IntroWindowAdvisor.class.getName());
    private IWorkbenchWindowConfigurer configurer;
    private WindowStateDialogSettings windowState;

    public IntroWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
        this.configurer = configurer;
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new IntroActionBarAdvisor(configurer);
    }

    public void postWindowClose() {
        logger.fine("postWindowClose");
        super.postWindowClose();
    }

    public void postWindowCreate() {
        logger.fine("poSstWindowCreate");
        PerspectiveManager.initialize();
        super.postWindowCreate();
        Shell shell = this.getWindowConfigurer().getWindow().getShell();
        if (this.windowState != null) {
            shell.setLocation(this.windowState.getLocation());
        }
        Image icon = ResourceGetter.getImage((String)"images/icon.ico");
        shell.setImage(icon);
    }

    public void postWindowOpen() {
        logger.fine("postWindowOpen");
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (Util.isCocoa()) {
            display.getMenuBar();
            MyCocoaUiEnhancer cocoa = new MyCocoaUiEnhancer("Ofys");
            Listener quitListener = new Listener(){

                public void handleEvent(Event arg0) {
                    System.out.println("would quit");
                }
            };
            Action about = new Action("\u00c0 propos de Ofys..."){

                public void run() {
                    IWorkbenchWindow w = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
                    IHandlerService service = (IHandlerService)w.getService(IHandlerService.class);
                    try {
                        service.executeCommand("ca.infodata.ofys.ui.intro.commands.aboutCommand", null);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed to run ca.infodata.ofys.ui.intro.commands.aboutCommand", e);
                    }
                }
            };
            ViewPreferencesAction pref = new ViewPreferencesAction(){

                public void openViewPreferencesDialog() {
                    System.out.println("Devrait ouvrir l'editeur des preferences...");
                }
            };
            cocoa.hookApplicationMenu(display, quitListener, (IAction)about, (IAction)pref);
        }
        super.postWindowOpen();
    }

    public void postWindowRestore() throws WorkbenchException {
        super.postWindowRestore();
    }

    public void preWindowOpen() {
        try {
            this.windowState = new WindowStateDialogSettings(PlatformUI.getWorkbench().getDisplay());
            ResourceGetter.setFontSizeIncrement((int)this.windowState.getFontSize());
            this.configurer.setInitialSize(this.windowState.getSize());
        }
        catch (Exception exception) {
            this.configurer.setInitialSize(new Point(1024, 768));
        }
        this.configurer.setShowCoolBar(true);
        this.configurer.setShowStatusLine(true);
        this.configurer.setShowProgressIndicator(true);
        this.configurer.setShowMenuBar(true);
        this.configurer.setShowPerspectiveBar(false);
        StatusBarManager.init((IWorkbenchWindowConfigurer)this.configurer);
        super.preWindowOpen();
    }

    public boolean preWindowShellClose() {
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        if (shell != null) {
            this.windowState.setLocation(shell.getLocation());
            this.windowState.setSize(shell.getSize());
            this.windowState.setFontSize(ResourceGetter.getFontSizeIncrement());
            this.windowState.save();
        }
        return super.preWindowShellClose();
    }
}

