/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.intro;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.web.core.IWebSocketFilter;
import ca.infodata.ofys.client.web.core.WebApplication;
import ca.infodata.ofys.client.web.core.WebSocketFilterById;
import ca.infodata.ofys.client.web.core.WebSocketResponse;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.LoginAccessorClient;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesAdapter;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesListener;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.dataaccess.util.notification.NotificationHandler;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XClientEnvironment;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.Notification;
import ca.infodata.ofys.data.middle.dataobjects.notification.ProgressStatusNotification;
import ca.infodata.ofys.data.middle.dataobjects.notification.RequestStatusNotification;
import ca.infodata.ofys.data.middle.dataobjects.notification.SessionClosedNotification;
import ca.infodata.ofys.data.middle.dataobjects.notification.SessionLockedNotification;
import ca.infodata.ofys.data.middle.dataobjects.notification.SessionStatusNotification;
import ca.infodata.ofys.ui.controls.BaseView;
import ca.infodata.ofys.ui.controls.ICanBeRefreshed;
import ca.infodata.ofys.ui.intro.ApplicationTimeoutTool;
import ca.infodata.ofys.ui.intro.BadVersionCheckTool;
import ca.infodata.ofys.ui.intro.ClientSessionTimeoutTool;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.intro.InfoWindow;
import ca.infodata.ofys.ui.intro.SessionSourceProvider;
import ca.infodata.ofys.ui.intro.handlers.SessionDialog;
import ca.infodata.ofys.ui.intro.login.autolog.ADManagement;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.util1.JoinList;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.services.ISourceProviderService;
import org.osgi.framework.BundleContext;

public class IntroPlugin
extends AbstractUIPlugin {
    private static final Logger logger = Logger.getLogger(IntroPlugin.class.getName());
    public static final String PLUGIN_ID = "ca.infodata.ofys.ui.intro";
    public static final String ABOUT_COMMAND = "ca.infodata.ofys.ui.intro.commands.aboutCommand";
    public static final String HOME_COMMAND = "ca.infodata.ofys.ui.intro.commands.homeCommand";
    public static final String LOGOUT_COMMAND = "ca.infodata.ofys.ui.intro.commands.logoutCommand";
    public static final String SCREENSHOT_COMMAND = "ca.infodata.ofys.ui.intro.commands.screenshotCommand";
    public static final String EXIT_COMMAND = "ca.infodata.ofys.ui.intro.commands.exitCommand";
    public static final String RUN_ASSIST = "ca.infodata.ofys.ui.intro.commands.remoteDesktopHelp";
    private static IntroPlugin plugin;
    private ResourceBundle resourceBundle;
    private NotificationHandlerImplementation handler;
    private SessionDialog sessionDialog;
    private Shell sessionDialogDialog;
    private GlobalInstancesListener globalInstancesListener;
    private ADManagement autologManager;
    private ApplicationTimeoutTool applicationTimeoutTool;
    private BadVersionCheckTool badVersionCheckTool;
    private static final String cssMacProd = "org.eclipse.e4.ui.css.theme.e4_mac_prod";
    private static final String cssMacTest = "org.eclipse.e4.ui.css.theme.e4_mac_test";
    private static final String cssWinProd = "org.eclipse.e4.ui.css.theme.e4_win_prod";
    private static final String cssWinTest = "org.eclipse.e4.ui.css.theme.e4_win_test";
    protected static ScheduledThreadPoolExecutor mqMsgScheduledThreadPoolExecutor;
    public static ScheduledFuture<?> mqScheduledFuture;
    public static TypeMsg prevMqStatus;

    static {
        prevMqStatus = TypeMsg.INACTIF;
    }

    public static IntroPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = IntroPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public IntroPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("ca.infodata.ofys.ui.intro.IntroPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public ApplicationTimeoutTool getApplicationTimeoutTool() {
        return this.applicationTimeoutTool;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void refreshEditors(Object element) {
        if (this.getWorkbench() != null && this.getWorkbench().getActiveWorkbenchWindow() != null && this.getWorkbench().getWorkbenchWindows()[0].getPages()[0] != null) {
            IEditorReference[] editor = this.getWorkbench().getWorkbenchWindows()[0].getPages()[0].getEditorReferences();
            int i = 0;
            while (i < editor.length) {
                if (editor[i].getEditor(true) instanceof ICanBeRefreshed) {
                    ((ICanBeRefreshed)editor[i].getEditor(true)).refresh(element);
                }
                ++i;
            }
        }
    }

    public void refreshViews(Object element) {
        BaseView.refreshViews((Object)element);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        System.out.println("IntroPlugin.start()");
        String javaVersion = System.getProperty("java.version");
        if (!javaVersion.startsWith("1.6") && System.getProperty("os.name").startsWith("Mac")) {
            SWT_AWT.embeddedFrameClass = "sun.lwawt.macosx.CViewEmbeddedFrame";
        }
        BaseAccessorClient.defaultStatusHandler = DefaultStatusHandler.getInstance();
        ClientSessionTimeoutTool.init();
        this.applicationTimeoutTool = new ApplicationTimeoutTool();
        this.badVersionCheckTool = new BadVersionCheckTool();
        this.autologManager = new ADManagement();
        this.sessionDialog = new SessionDialog();
        this.handler = new NotificationHandlerImplementation();
        this.globalInstancesListener = new GlobalInstancesAdapter(){

            public void sessionChanged() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbench workbench = PlatformUI.getWorkbench();
                        MApplication application = (MApplication)workbench.getService(MApplication.class);
                        IEclipseContext context = application.getContext();
                        IThemeEngine engine = (IThemeEngine)context.get(IThemeEngine.class);
                        XSession session = Application.get().getGlobalInstances().getSession();
                        if (session != null && session.getClient() != null && session.getClient().getEnvironment() == XClientEnvironment.TEST) {
                            if (UI.OS_MAC) {
                                engine.setTheme(IntroPlugin.cssMacTest, false);
                            } else {
                                engine.setTheme(IntroPlugin.cssWinTest, false);
                            }
                        } else if (UI.OS_MAC) {
                            engine.setTheme(IntroPlugin.cssMacProd, true);
                        } else {
                            engine.setTheme(IntroPlugin.cssWinProd, true);
                        }
                    }
                });
                ISourceProviderService service = (ISourceProviderService)IntroPlugin.this.getWorkbench().getService(ISourceProviderService.class);
                final SessionSourceProvider provider = (SessionSourceProvider)service.getSourceProvider("ca.infodata.ofys.ui.loggedIn");
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        provider.refresh();
                        IntroPlugin.this.sessionDialog.setOldSession(IntroPlugin.this.sessionDialog.getActiveSession());
                        IntroPlugin.this.sessionDialog.setActiveSession(Application.get().getGlobalInstances().getSession());
                    }
                });
                if (mqMsgScheduledThreadPoolExecutor != null) {
                    mqMsgScheduledThreadPoolExecutor.shutdownNow();
                }
                if (Application.get().getGlobalInstances().getSession() != null) {
                    prevMqStatus = TypeMsg.INACTIF;
                    mqMsgScheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
                    MqMsgStatusTask task = new MqMsgStatusTask();
                    mqScheduledFuture = mqMsgScheduledThreadPoolExecutor.scheduleAtFixedRate(task, 5L, 5L, TimeUnit.SECONDS);
                }
            }
        };
        Application.get().getGlobalInstances().addGlobalInstancesListener(this.globalInstancesListener);
        Application.get().getGlobalInstances().getNotificationSystem().addNotificationHandler((NotificationHandler)this.handler);
    }

    public void stop(BundleContext context) throws Exception {
        Application.get().getGlobalInstances().removeGlobalInstancesListener(this.globalInstancesListener);
        try {
            TimeUnit.SECONDS.sleep(2L);
            Application.get().getGlobalInstances().getNotificationSystem().applicationShutdown();
        }
        catch (Exception exception) {}
        super.stop(context);
    }

    public static void setApplicationTitle() {
        String title = "";
        XSession session = Application.get().getGlobalInstances().getSession();
        if (session == null) {
            title = Messages.getString((String)"MEDOFFICE2", (String[])new String[0]);
        } else {
            JoinList list = new JoinList(" - ", 4);
            list.add((CharSequence)Messages.getString((String)"MEDOFFICE2", (String[])new String[0]));
            if (Application.get().getGlobalInstances().inDebugMode()) {
                list.add((CharSequence)("SessionId:" + session.getId()));
            }
            list.add((CharSequence)session.getUser().getName());
            if (Application.get().getGlobalInstances().inDebugMode()) {
                list.add((CharSequence)("UserId:" + session.getUser().getId().toString()));
            }
            if (session.getUser().getBasePerson() == null) {
                list.add((CharSequence)session.getUser().getName());
            }
            list.add((CharSequence)session.getClient().getClientCode());
            if (Application.get().getGlobalInstances().inDebugMode()) {
                list.add((CharSequence)("ClientId:" + session.getClient().getId()));
            }
            if (session.getClient().getEnvironment() != null) {
                list.add((CharSequence)session.getClient().getEnvironment().toString());
            }
            title = list.toString();
        }
        UI.getWorkbenchShell().setText(title);
    }

    public void badVersionAndWait() {
        Log.logOperation((String)"IntroPlugin.badVersion", (Object[])new Object[0]);
        try {
            Display current = Display.getCurrent();
            if (current == null) {
                current = Display.getDefault();
            }
            current.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (IntroPlugin.this.sessionDialogDialog == null || IntroPlugin.this.sessionDialogDialog.isDisposed()) {
                        IntroPlugin.this.sessionDialogDialog = IntroPlugin.this.sessionDialog.openDialog();
                    } else {
                        IntroPlugin.this.sessionDialog.refresh();
                    }
                    if (IntroPlugin.this.sessionDialogDialog != null) {
                        UI.waitForWindowToClose((Shell)IntroPlugin.this.sessionDialogDialog);
                    }
                }
            });
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error", e);
        }
    }

    public void forceLogout() {
        Log.logOperation((String)"IntroPlugin.forceLogout", (Object[])new Object[0]);
        mqScheduledFuture.cancel(true);
        ClientSessionTimeoutTool.getInstance().stopTimer();
        try {
            Display current = Display.getCurrent();
            if (current == null) {
                current = Display.getDefault();
            }
            current.syncExec(new Runnable(){

                @Override
                public void run() {
                    IntroPlugin.this.sessionDialog.setActiveSession(null);
                    if (IntroPlugin.this.sessionDialogDialog == null || IntroPlugin.this.sessionDialogDialog.isDisposed()) {
                        IntroPlugin.this.sessionDialogDialog = IntroPlugin.this.sessionDialog.openDialog();
                    } else {
                        IntroPlugin.this.sessionDialog.refresh();
                    }
                    if (IntroPlugin.this.sessionDialogDialog != null) {
                        UI.waitForWindowToClose((Shell)IntroPlugin.this.sessionDialogDialog);
                    }
                }
            });
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error", e);
        }
    }

    public void lockSession(final boolean lock) {
        Display current;
        Log.logOperation((String)"IntroPlugin.lockSession", (Object[])new Object[]{lock});
        XSession session = Application.get().getGlobalInstances().getSession();
        if (session != null) {
            try {
                LoginAccessorClient.getInstance().lockSession(session);
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error", e);
            }
        }
        if (ClientSessionTimeoutTool.getInstance() != null) {
            ClientSessionTimeoutTool.getInstance().stopTimer();
        }
        if ((current = Display.getCurrent()) == null) {
            current = Display.getDefault();
        }
        current.syncExec(new Runnable(){

            @Override
            public void run() {
                if (IntroPlugin.this.sessionDialogDialog == null || IntroPlugin.this.sessionDialogDialog.isDisposed()) {
                    IntroPlugin.this.sessionDialogDialog = IntroPlugin.this.sessionDialog.openDialog();
                } else {
                    IntroPlugin.this.sessionDialog.refresh();
                }
                if (IntroPlugin.this.sessionDialogDialog != null && lock) {
                    UI.waitForWindowToClose((Shell)IntroPlugin.this.sessionDialogDialog);
                }
            }
        });
    }

    public void lockSessionAndWait() {
        this.lockSession(true);
    }

    public ADManagement getAutologService() {
        return this.autologManager;
    }

    public void showInfoWindow(List<String> texte, TypeMsg typeMsg) {
        final String[] ret = new String[texte.size()];
        int j = 0;
        while (j < texte.size()) {
            ret[j] = texte.get(j);
            ++j;
        }
        final RGB rgb = TypeMsg.INACTIF.equals((Object)typeMsg) ? new RGB(255, 0, 0) : new RGB(152, 251, 152);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                new InfoWindow(UI.getWorkbenchShell(), ret, 10000, ResourceGetter.getFontSmallNormal(), rgb);
            }
        });
    }

    static class MqMsgStatusTask
    implements Runnable {
        @Override
        public void run() {
            try {
                if (Application.get().getGlobalInstances().getNotificationSystem().isEnabled()) {
                    if (Application.get().getGlobalInstances().getNotificationSystem().isActive()) {
                        if (TypeMsg.INACTIF.equals((Object)prevMqStatus)) {
                            prevMqStatus = TypeMsg.ACTIF;
                            String m = Messages.getString((String)"AUTO_REFRESH_ACTIVE", (String[])new String[0]);
                            ArrayList<String> lst = new ArrayList<String>();
                            lst.add(m);
                            IntroPlugin.getDefault().showInfoWindow(lst, TypeMsg.ACTIF);
                        }
                    } else {
                        prevMqStatus = TypeMsg.INACTIF;
                        String m = Messages.getString((String)"AUTO_REFRESH_NOT_ACTIVE", (String[])new String[0]);
                        ArrayList<String> lst = new ArrayList<String>();
                        lst.add(m);
                        IntroPlugin.getDefault().showInfoWindow(lst, TypeMsg.INACTIF);
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error on notification system info window update ", e);
            }
        }
    }

    private static final class NotificationHandlerImplementation
    implements NotificationHandler {
        private NotificationHandlerImplementation() {
        }

        public void handle(Notification notification) {
            XSession session;
            if (notification instanceof SessionClosedNotification) {
                XSession session2 = Application.get().getGlobalInstances().getSession();
                if (session2 != null && ((SessionClosedNotification)notification).getSessionId() != null && ((SessionClosedNotification)notification).getSessionId().intValue() == session2.getId().intValue()) {
                    try {
                        IntroPlugin.getDefault().forceLogout();
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "SessionClosedNotification received. Failed to update session. new=" + null + " old=" + session2, e);
                    }
                }
            } else if (notification instanceof SessionStatusNotification) {
                XSession session3 = Application.get().getGlobalInstances().getSession();
                if (session3 != null && session3.getId().equals(((SessionStatusNotification)notification).getSessionId())) {
                    SessionStatusNotification statusNotif = (SessionStatusNotification)notification;
                    System.out.println(statusNotif.getStatus().getMessage());
                    MessageUtil.errorMsg((Shell)UI.getWorkbenchShell(), (String)statusNotif.getStatus().getMessage());
                }
            } else if (notification instanceof RequestStatusNotification) {
                XSession session4 = Application.get().getGlobalInstances().getSession();
                if (session4 != null && session4.getId().equals(((RequestStatusNotification)notification).getSessionId())) {
                    RequestStatusNotification statusNotif = (RequestStatusNotification)notification;
                    System.out.println(statusNotif.getStatus().getMessage());
                    ReturnObject ro = new ReturnObject();
                    if (!statusNotif.getStatus().isOK()) {
                        ro.getStatus().setSeverity(statusNotif.getStatus().getSeverity());
                        ro.getStatus().setMessage(statusNotif.getStatus().getMessage());
                        ro.setObj((Object)statusNotif.getStatus().getData());
                    }
                    WebApplication.get().getWebSocketDelegate().send((IWebSocketFilter)new WebSocketFilterById(statusNotif.getClientUid()), new WebSocketResponse(statusNotif.getChannelName(), (Object)ro));
                }
            } else if (notification instanceof ProgressStatusNotification) {
                ProgressStatusNotification statusNotif;
                XSession session5 = Application.get().getGlobalInstances().getSession();
                if (session5 != null && session5.getId().equals(((ProgressStatusNotification)notification).getSessionId()) && !"dsq.pt.all.search.progress".equals((statusNotif = (ProgressStatusNotification)notification).getChannelName())) {
                    System.out.println("Received progress notif '" + statusNotif.getChannelName() + "': " + statusNotif.getMessage() + " - " + statusNotif.getItem() + "/" + statusNotif.getOver());
                    ReturnObject ro = new ReturnObject();
                    ro.setObj((Object)statusNotif);
                    WebApplication.get().getWebSocketDelegate().send((IWebSocketFilter)new WebSocketFilterById(statusNotif.getClientUid()), new WebSocketResponse(statusNotif.getChannelName(), (Object)ro));
                }
            } else if (notification instanceof SessionLockedNotification && (session = Application.get().getGlobalInstances().getSession()) != null && session.getId().equals(((SessionLockedNotification)notification).getSessionId())) {
                IntroPlugin.getDefault().lockSession(false);
            }
        }
    }

    public static enum TypeMsg {
        ACTIF,
        INACTIF;

    }
}

