/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.intro;

import ca.infodata.ofys.ui.library.ResourceGetter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class InfoWindow {
    public static boolean opened = false;
    public static InfoWindow window = null;
    public static int newViewAutoCloseDelay = -1;
    protected int timeToStay;
    protected Shell shell;
    protected Image image;
    protected Color color;
    protected String[] texte;
    protected int newAutoCloseDelay;
    public static final int EDGE_LT = 2;
    public static final int EDGE_RT = 4;
    public static final int EDGE_LB = 8;
    public static final int EDGE_RB = 16;
    public static final int EDGES_LEFT = 10;
    public static final int EDGES_RIGHT = 20;
    public static final int EDGES_TOP = 6;
    public static final int EDGES_BOTTOM = 24;
    public static final int EDGES_ALL = 30;

    public InfoWindow(Shell shell, String[] texte, int timeToStay, Font f, RGB rgb) {
        if (window != null && InfoWindow.window.shell != null && !InfoWindow.window.shell.isDisposed()) {
            window.closeIt();
        }
        if (shell == null || shell.isDisposed()) {
            return;
        }
        int policeSize = f.getFontData()[0].getHeight();
        this.texte = texte;
        this.newAutoCloseDelay = 0;
        this.timeToStay = timeToStay;
        window = this;
        shell.getDisplay().timerExec(timeToStay, new Runnable(){

            @Override
            public void run() {
                InfoWindow.this.closeIt();
            }
        });
        int yy = shell.getBounds().y + shell.getBounds().height;
        int imageWidth = shell.getBounds().width / 2;
        int shellLeftPos = shell.getBounds().x + imageWidth / 2;
        this.image = new Image((Device)shell.getDisplay(), imageWidth, policeSize + 7);
        this.color = ResourceGetter.getColor((RGB)rgb);
        GC gc = new GC((Drawable)this.image);
        gc.setBackground(this.color);
        gc.fillRectangle(this.image.getBounds());
        gc.setFont(f);
        gc.setForeground(shell.getDisplay().getSystemColor(2));
        int i = 0;
        while (i < texte.length) {
            int w = (imageWidth - gc.textExtent((String)texte[i]).x) / 2;
            int line = (int)(2.0 + (double)i * ((double)policeSize + (double)(policeSize + 1) * 0.3));
            gc.drawText(texte[i], w, line, true);
            ++i;
        }
        gc.dispose();
        this.shell = new Shell(shell, 524296);
        Label label = new Label((Composite)this.shell, 2048);
        label.setImage(this.image);
        label.pack();
        this.shell.pack();
        InfoWindow.addRoundedBoxOnResize(this.shell, 2, 30);
        this.shell.setLocation(shellLeftPos, yy - (policeSize + 12));
        this.shell.setVisible(true);
    }

    protected void closeIt() {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.close();
            this.image.dispose();
            this.shell.dispose();
            window = null;
        }
    }

    public int getNewAutoCloseDelay() {
        return this.newAutoCloseDelay;
    }

    public void setNewAutoCloseDelay(int newAutoCloseDeay) {
        this.newAutoCloseDelay = newAutoCloseDeay;
    }

    public static Region regionRoundedBox(Rectangle bounds, int radius, int edges) {
        Region res = new Region();
        res.add(bounds);
        Rectangle rect = new Rectangle(0, 0, 1, 0);
        int i = 0;
        while (i < radius) {
            int y = radius - (int)Math.round(Math.sqrt(radius * radius - (radius - i) * (radius - i)));
            rect.x = bounds.x + i;
            rect.y = bounds.y;
            rect.height = y + 1;
            if ((edges & 2) != 0) {
                res.subtract(rect);
            }
            rect.x = bounds.x + bounds.width - i - 1;
            if ((edges & 4) != 0) {
                res.subtract(rect);
            }
            rect.y = bounds.y + bounds.height - y - 1;
            if ((edges & 0x10) != 0) {
                res.subtract(rect);
            }
            rect.x = bounds.x + i;
            if ((edges & 8) != 0) {
                res.subtract(rect);
            }
            ++i;
        }
        return res;
    }

    public static void addRoundedBoxOnResize(final Shell c, final int radius, final int edges) {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                Rectangle r = c.getBounds();
                r.x = 0;
                r.y = 0;
                c.setRegion(InfoWindow.regionRoundedBox(r, radius, edges));
            }
        };
        c.addListener(11, listener);
        listener.handleEvent(null);
    }
}

